/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.documentlibrary.service.impl;

import com.liferay.documentlibrary.DirectoryNameException;
import com.liferay.documentlibrary.service.DLLocalService;
import com.liferay.documentlibrary.service.DLService;
import com.liferay.documentlibrary.util.Hook;
import com.liferay.portal.kernel.annotation.BeanReference;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.service.ServiceContext;
import java.io.File;
import java.util.Date;

public class DLServiceImpl
implements DLService {
    public static final String GROUP_NAME = DLServiceImpl.class.getName();
    public static final String[] GROUP_NAME_ARRAY = new String[]{GROUP_NAME};
    @BeanReference(type=DLLocalService.class)
    protected DLLocalService dlLocalService;
    @BeanReference(type=Hook.class)
    protected Hook hook;

    public void addDirectory(long companyId, long repositoryId, String dirName) throws PortalException, SystemException {
        if (dirName == null || dirName.equals("/") || dirName.indexOf("\\\\") != -1 || dirName.indexOf("//") != -1 || dirName.indexOf(":") != -1 || dirName.indexOf("*") != -1 || dirName.indexOf("?") != -1 || dirName.indexOf("\"") != -1 || dirName.indexOf("<") != -1 || dirName.indexOf(">") != -1 || dirName.indexOf("|") != -1 || dirName.indexOf("[") != -1 || dirName.indexOf("]") != -1 || dirName.indexOf("'") != -1 || dirName.indexOf("..\\") != -1 || dirName.indexOf("../") != -1 || dirName.indexOf("\\..") != -1 || dirName.indexOf("/..") != -1) {
            throw new DirectoryNameException(dirName);
        }
        this.hook.addDirectory(companyId, repositoryId, dirName);
    }

    public void addFile(long companyId, String portletId, long groupId, long repositoryId, String fileName, long fileEntryId, String properties, Date modifiedDate, ServiceContext serviceContext, byte[] bytes) throws PortalException, SystemException {
        this.dlLocalService.validate(fileName, true, bytes);
        this.hook.addFile(companyId, portletId, groupId, repositoryId, fileName, fileEntryId, properties, modifiedDate, serviceContext, bytes);
    }

    public void addFile(long companyId, String portletId, long groupId, long repositoryId, String fileName, long fileEntryId, String properties, Date modifiedDate, ServiceContext serviceContext, File file) throws PortalException, SystemException {
        this.dlLocalService.validate(fileName, true, file);
        this.hook.addFile(companyId, portletId, groupId, repositoryId, fileName, fileEntryId, properties, modifiedDate, serviceContext, file);
    }

    public void deleteDirectory(long companyId, String portletId, long repositoryId, String dirName) throws PortalException, SystemException {
        this.hook.deleteDirectory(companyId, portletId, repositoryId, dirName);
    }

    public void deleteFile(long companyId, String portletId, long repositoryId, String fileName) throws PortalException, SystemException {
        this.hook.deleteFile(companyId, portletId, repositoryId, fileName);
    }

    public void deleteFile(long companyId, String portletId, long repositoryId, String fileName, String versionNumber) throws PortalException, SystemException {
        this.hook.deleteFile(companyId, portletId, repositoryId, fileName, versionNumber);
    }

    public byte[] getFile(long companyId, long repositoryId, String fileName) throws PortalException, SystemException {
        return this.hook.getFile(companyId, repositoryId, fileName);
    }

    public byte[] getFile(long companyId, long repositoryId, String fileName, String versionNumber) throws PortalException, SystemException {
        return this.hook.getFile(companyId, repositoryId, fileName, versionNumber);
    }

    public String[] getFileNames(long companyId, long repositoryId, String dirName) throws PortalException, SystemException {
        return this.hook.getFileNames(companyId, repositoryId, dirName);
    }

    public long getFileSize(long companyId, long repositoryId, String fileName) throws PortalException, SystemException {
        return this.hook.getFileSize(companyId, repositoryId, fileName);
    }

    public void updateFile(long companyId, String portletId, long groupId, long repositoryId, long newRepositoryId, String fileName, long fileEntryId) throws PortalException, SystemException {
        this.hook.updateFile(companyId, portletId, groupId, repositoryId, newRepositoryId, fileName, fileEntryId);
    }

    public void updateFile(long companyId, String portletId, long groupId, long repositoryId, String fileName, String versionNumber, String sourceFileName, long fileEntryId, String properties, Date modifiedDate, ServiceContext serviceContext, byte[] bytes) throws PortalException, SystemException {
        this.dlLocalService.validate(fileName, true, bytes);
        this.hook.updateFile(companyId, portletId, groupId, repositoryId, fileName, versionNumber, sourceFileName, fileEntryId, properties, modifiedDate, serviceContext, bytes);
    }

    public void updateFile(long companyId, String portletId, long groupId, long repositoryId, String fileName, String versionNumber, String sourceFileName, long fileEntryId, String properties, Date modifiedDate, ServiceContext serviceContext, File file) throws PortalException, SystemException {
        this.dlLocalService.validate(fileName, true, file);
        this.hook.updateFile(companyId, portletId, groupId, repositoryId, fileName, versionNumber, sourceFileName, fileEntryId, properties, modifiedDate, serviceContext, file);
    }

    public void updateFile(long companyId, String portletId, long groupId, long repositoryId, String fileName, String newFileName, boolean reindex) throws PortalException, SystemException {
        this.hook.updateFile(companyId, portletId, groupId, repositoryId, fileName, newFileName, reindex);
    }
}

