/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene.constraint;

import java.io.IOException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.apache.jackrabbit.core.query.lucene.ScoreNode;
import org.apache.jackrabbit.core.query.lucene.Util;
import org.apache.jackrabbit.core.query.lucene.constraint.DynamicOperand;
import org.apache.jackrabbit.core.query.lucene.constraint.EvaluationContext;
import org.apache.jackrabbit.core.query.lucene.constraint.PropertyValueOperand;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.value.InternalValue;

public class LengthOperand
extends DynamicOperand {
    private final PropertyValueOperand property;

    public LengthOperand(PropertyValueOperand property) {
        this.property = property;
    }

    public Value[] getValues(ScoreNode sn, EvaluationContext context) throws IOException {
        PropertyState ps = this.property.getPropertyState(sn, context);
        if (ps == null) {
            return EMPTY;
        }
        try {
            ValueFactory vf = context.getSession().getValueFactory();
            InternalValue[] values = ps.getValues();
            Value[] lengths = new Value[values.length];
            for (int i = 0; i < lengths.length; ++i) {
                lengths[i] = vf.createValue(Util.getLength(values[i]));
            }
            return lengths;
        }
        catch (RepositoryException e) {
            throw Util.createIOException(e);
        }
    }
}

