/*
 * Decompiled with CFR 0.152.
 */
package uk.org.primrose.pool.core.loadrules;

import java.net.Socket;
import uk.org.primrose.Logger;
import uk.org.primrose.pool.core.Pool;
import uk.org.primrose.pool.core.loadrules.LoadRule;
import uk.org.primrose.pool.core.loadrules.LoadRuleException;

public class EmailEvents
implements LoadRule {
    public void runCheck(Pool pool, Logger logger) throws LoadRuleException {
        String[] eventParts;
        logger.info("[Pool@" + pool.getPoolName() + "] Checking 'emailEvents' rule  ...");
        if (pool.getSmtpMailExchangeServer() == null || pool.getSmtpMailExchangeServer().length() == 0) {
            throw new LoadRuleException("Pool config parameter 'smtpMailExchangeServer' must be specified if you wish to use the 'emailEvents' parameter.");
        }
        if (pool.getAdminEmail() == null || pool.getAdminEmail().length() == 0) {
            throw new LoadRuleException("Pool config parameter 'adminEmail' must be specified if you wish to use the 'emailEvents' parameter.");
        }
        try {
            Integer.parseInt(pool.getSmtpMailExchangeServerPort());
        }
        catch (Exception e) {
            throw new LoadRuleException("'smtpMailExchangeServerPort' parameter is set, the value '" + pool.getSmtpMailExchangeServerPort() + "' is not an integer", e);
        }
        try {
            Socket s = new Socket(pool.getSmtpMailExchangeServer(), Integer.parseInt(pool.getSmtpMailExchangeServerPort()));
            s.close();
        }
        catch (Exception e) {
            throw new LoadRuleException("'smtpMailExchangeServer' parameter is set, but the pool cannot connect to the server on port " + pool.getSmtpMailExchangeServerPort(), e);
        }
        String events = pool.getEmailEvents();
        for (String event : eventParts = events.split(",")) {
            if (!event.toUpperCase().equals("DBCRASH")) continue;
            if (pool.getOnExceptionCheckSQL() != null && pool.getOnExceptionCheckSQL().length() != 0) break;
            throw new LoadRuleException("If you wish to be emailed about the DBCRASH event, then you must set the 'onExceptionCheckSQL', eg 'onExceptionCheckSQL=select 1 from dual'");
        }
    }
}

