/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing;

import java.awt.RenderingHints;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.media.jai.JAI;
import javax.media.jai.TileCache;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.Interpolator2D;
import org.geotools.coverage.processing.AbstractOperation;
import org.geotools.coverage.processing.AbstractProcessor;
import org.geotools.factory.FactoryRegistry;
import org.geotools.factory.Hints;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Loggings;
import org.opengis.coverage.Coverage;
import org.opengis.coverage.processing.Operation;
import org.opengis.coverage.processing.OperationNotFoundException;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultProcessor
extends AbstractProcessor {
    private static final Comparator<String> COMPARATOR;
    private final Map<String, Operation> operations = new TreeMap<String, Operation>(COMPARATOR);
    private final Hints hints;
    private final FactoryRegistry registry = new FactoryRegistry(Arrays.asList(Operation.class));

    public DefaultProcessor(RenderingHints hints) {
        this.hints = new Hints(hints);
        this.hints.put((Object)JAI.KEY_REPLACE_INDEX_COLOR_MODEL, (Object)Boolean.FALSE);
        this.hints.put((Object)JAI.KEY_TRANSFORM_ON_COLORMAP, (Object)Boolean.FALSE);
        this.hints.put((Object)Hints.GRID_COVERAGE_PROCESSOR, (Object)this);
    }

    final void setProcessor(AbstractProcessor processor) {
        this.hints.put((Object)Hints.GRID_COVERAGE_PROCESSOR, (Object)processor);
    }

    @Override
    void setAsDefault() {
        this.hints.remove((Object)Hints.GRID_COVERAGE_PROCESSOR);
    }

    protected synchronized void addOperation(Operation operation) throws IllegalStateException {
        DefaultProcessor.ensureNonNull("operation", operation);
        if (this.operations.isEmpty()) {
            this.scanForPlugins();
        }
        this.addOperation0(operation);
    }

    private void addOperation0(Operation operation) throws IllegalStateException {
        String name = operation.getName().trim();
        Operation old = this.operations.put(name, operation);
        if (old != null && !old.equals(operation)) {
            this.operations.put(old.getName().trim(), old);
            throw new IllegalStateException(Errors.getResources((Locale)this.getLocale()).getString(151, (Object)operation.getName()));
        }
    }

    @Override
    public synchronized Collection<Operation> getOperations() {
        if (this.operations.isEmpty()) {
            this.scanForPlugins();
        }
        return this.operations.values();
    }

    @Override
    public synchronized Operation getOperation(String name) throws OperationNotFoundException {
        Operation operation;
        DefaultProcessor.ensureNonNull("name", name);
        name = name.trim();
        if (this.operations.isEmpty()) {
            this.scanForPlugins();
        }
        if ((operation = this.operations.get(name)) != null) {
            return operation;
        }
        throw new OperationNotFoundException(Errors.getResources((Locale)this.getLocale()).getString(152, (Object)name));
    }

    public final Object getRenderingHint(RenderingHints.Key key) {
        return this.hints.get((Object)key);
    }

    @Override
    public synchronized Coverage doOperation(ParameterValueGroup parameters) throws OperationNotFoundException {
        AbstractOperation op;
        Coverage source = DefaultProcessor.getPrimarySource(parameters);
        String operationName = DefaultProcessor.getOperationName(parameters);
        Operation operation = this.getOperation(operationName);
        Object[] interpolations = null;
        if (!operationName.equalsIgnoreCase("Interpolate")) {
            for (GeneralParameterValue param : parameters.values()) {
                Object value;
                if (!(param instanceof ParameterValue) || !((value = ((ParameterValue)param).getValue()) instanceof Interpolator2D)) continue;
                Object[] interp = ((Interpolator2D)value).getInterpolations();
                if (interpolations == null) {
                    interpolations = interp;
                    continue;
                }
                if (Arrays.equals(interpolations, interp)) continue;
                interpolations = null;
                break;
            }
        }
        try {
            op = (AbstractOperation)operation;
        }
        catch (ClassCastException cause) {
            OperationNotFoundException exception = new OperationNotFoundException(Errors.getResources((Locale)this.getLocale()).getString(152, (Object)operationName));
            exception.initCause((Throwable)cause);
            throw exception;
        }
        Coverage coverage = op.doOperation(parameters, this.hints);
        if (interpolations != null && coverage instanceof GridCoverage2D && !(coverage instanceof Interpolator2D)) {
            coverage = Interpolator2D.create((GridCoverage2D)coverage, interpolations);
        }
        this.log(source, coverage, operationName, false);
        return coverage;
    }

    public synchronized void scanForPlugins() {
        Iterator it = this.registry.getServiceProviders(Operation.class, null, null);
        while (it.hasNext()) {
            Operation operation = (Operation)it.next();
            String name = operation.getName().trim();
            if (this.operations.containsKey(name)) continue;
            this.addOperation0(operation);
        }
    }

    static {
        long targetCapacity = 0x4000000L;
        long maxMemory = Runtime.getRuntime().maxMemory();
        TileCache cache = JAI.getDefaultInstance().getTileCache();
        if (maxMemory >= 0x8000000L && cache.getMemoryCapacity() < 0x4000000L) {
            cache.setMemoryCapacity(0x4000000L);
        }
        LOGGER.config("Java Advanced Imaging: " + JAI.getBuildVersion() + ", TileCache capacity=" + (float)(cache.getMemoryCapacity() / 0x100000L) + " Mb");
        if (cache.getMemoryCapacity() + 0x400000L >= maxMemory) {
            LogRecord record = Loggings.format((Level)Level.SEVERE, (int)20, (Object)((double)maxMemory / 1048576.0));
            record.setLoggerName(LOGGER.getName());
            LOGGER.log(record);
        }
        COMPARATOR = new Comparator<String>(){

            @Override
            public int compare(String name1, String name2) {
                return name1.toLowerCase().compareTo(name2.toLowerCase());
            }
        };
    }
}

