/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.TimeoutException;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.util.Promise;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AckCollector {
    private final List<Object> missing_acks;
    private final Promise<Boolean> all_acks_received = new Promise();
    private final Set<Address> suspected_mbrs = new HashSet<Address>();
    private int expected_acks = 0;

    public AckCollector() {
        this.missing_acks = new ArrayList<Object>();
        this.expected_acks = 0;
    }

    public AckCollector(ViewId v, List<Object> l) {
        this.missing_acks = new ArrayList<Object>(l);
        if (v != null) {
            this.expected_acks = l != null ? l.size() : 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String printMissing() {
        AckCollector ackCollector = this;
        synchronized (ackCollector) {
            return this.missing_acks.toString();
        }
    }

    @Deprecated
    public static String printReceived() {
        return "n/a";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String printSuspected() {
        AckCollector ackCollector = this;
        synchronized (ackCollector) {
            return this.suspected_mbrs.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(Collection<Address> members) {
        AckCollector ackCollector = this;
        synchronized (ackCollector) {
            this.suspected_mbrs.clear();
            this.missing_acks.clear();
            if (members != null && !members.isEmpty()) {
                this.missing_acks.addAll(members);
                this.expected_acks = members.size();
            }
            this.missing_acks.removeAll(this.suspected_mbrs);
            this.all_acks_received.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        AckCollector ackCollector = this;
        synchronized (ackCollector) {
            return this.missing_acks.size();
        }
    }

    @Deprecated
    public static int receivedAcks() {
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int expectedAcks() {
        AckCollector ackCollector = this;
        synchronized (ackCollector) {
            return this.expected_acks;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ack(Object member) {
        AckCollector ackCollector = this;
        synchronized (ackCollector) {
            this.missing_acks.remove(member);
            if (this.missing_acks.isEmpty()) {
                this.all_acks_received.setResult(Boolean.TRUE);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspect(Address member) {
        AckCollector ackCollector = this;
        synchronized (ackCollector) {
            this.ack(member);
            this.suspected_mbrs.add(member);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsuspect(Address member) {
        AckCollector ackCollector = this;
        synchronized (ackCollector) {
            this.suspected_mbrs.remove(member);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleView(View v) {
        if (v == null) {
            return;
        }
        Vector<Address> mbrs = v.getMembers();
        AckCollector ackCollector = this;
        synchronized (ackCollector) {
            this.suspected_mbrs.retainAll(mbrs);
        }
    }

    public boolean waitForAllAcks() {
        if (this.missing_acks.isEmpty()) {
            return true;
        }
        Boolean result = this.all_acks_received.getResult();
        return result != null && result instanceof Boolean && result != false;
    }

    public boolean waitForAllAcks(long timeout) throws TimeoutException {
        if (this.missing_acks.isEmpty()) {
            return true;
        }
        Boolean result = this.all_acks_received.getResultWithTimeout(timeout);
        return result != null && result instanceof Boolean && result != false;
    }

    public String toString() {
        return "missing=" + this.printMissing();
    }
}

