/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jgroups.Address;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.stack.Interval;
import org.jgroups.stack.StaticInterval;
import org.jgroups.util.TimeScheduler;

public abstract class Retransmitter {
    protected Interval RETRANSMIT_TIMEOUTS = new StaticInterval(300L, 600L, 1200L, 2400L);
    protected final Address sender;
    protected final RetransmitCommand cmd;
    protected final TimeScheduler timer;
    protected static final Log log = LogFactory.getLog(Retransmitter.class);

    public Retransmitter(Address sender, RetransmitCommand cmd, TimeScheduler sched) {
        this.sender = sender;
        this.cmd = cmd;
        this.timer = sched;
    }

    public void setRetransmitTimeouts(Interval interval) {
        if (interval != null) {
            this.RETRANSMIT_TIMEOUTS = interval;
        }
    }

    public abstract void add(long var1, long var3);

    public abstract int remove(long var1);

    public abstract void reset();

    public abstract int size();

    protected abstract class Task
    implements TimeScheduler.Task {
        protected final Interval intervals;
        protected volatile Future future;
        protected Address msg_sender = null;
        protected int num_retransmits = 0;
        protected RetransmitCommand command;
        protected volatile boolean cancelled = false;

        protected Task(Interval intervals, RetransmitCommand cmd, Address msg_sender) {
            this.intervals = intervals;
            this.command = cmd;
            this.msg_sender = msg_sender;
        }

        public int getNumRetransmits() {
            return this.num_retransmits;
        }

        public long nextInterval() {
            return this.intervals.next();
        }

        public void doSchedule() {
            if (this.cancelled) {
                return;
            }
            long delay = this.intervals.next();
            this.future = Retransmitter.this.timer.schedule(this, delay, TimeUnit.MILLISECONDS);
        }

        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
            }
            if (this.future != null) {
                this.future.cancel(true);
            }
        }

        public void run() {
            block3: {
                if (this.cancelled) {
                    return;
                }
                try {
                    this.callRetransmissionCommand();
                    ++this.num_retransmits;
                }
                catch (Throwable t) {
                    if (!log.isErrorEnabled()) break block3;
                    log.error("failed retransmission task", t);
                }
            }
            this.doSchedule();
        }

        protected abstract void callRetransmissionCommand();
    }

    public static interface RetransmitCommand {
        public void retransmit(long var1, long var3, Address var5);
    }
}

