/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search;

import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistry;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexerRegistryUtil {
    private static IndexerRegistry _indexerRegistry;

    public static Indexer getIndexer(Class<?> classObj) {
        return IndexerRegistryUtil.getIndexerRegistry().getIndexer(classObj.getName());
    }

    public static Indexer getIndexer(String className) {
        return IndexerRegistryUtil.getIndexerRegistry().getIndexer(className);
    }

    public static IndexerRegistry getIndexerRegistry() {
        return _indexerRegistry;
    }

    public static List<Indexer> getIndexers() {
        return IndexerRegistryUtil.getIndexerRegistry().getIndexers();
    }

    public static void register(Indexer indexer) {
        String[] stringArray = indexer.getClassNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String className = stringArray[n2];
            IndexerRegistryUtil.register(className, indexer);
            ++n2;
        }
        IndexerRegistryUtil.register(indexer.getClass().getName(), indexer);
    }

    public static void register(String className, Indexer indexer) {
        IndexerRegistryUtil.getIndexerRegistry().register(className, indexer);
    }

    public static void unregister(Indexer indexer) {
        String[] stringArray = indexer.getClassNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String className = stringArray[n2];
            IndexerRegistryUtil.unregister(className);
            ++n2;
        }
        IndexerRegistryUtil.unregister(indexer.getClass().getName());
    }

    public static void unregister(String className) {
        IndexerRegistryUtil.getIndexerRegistry().unregister(className);
    }

    public void setIndexerRegistry(IndexerRegistry indexerRegistry) {
        _indexerRegistry = indexerRegistry;
    }
}

