/*
 * Decompiled with CFR 0.152.
 */
package jodd.util;

import java.io.UnsupportedEncodingException;

public class CharUtil {
    public static byte[] toByteArray(char[] carr) {
        if (carr == null) {
            return null;
        }
        byte[] barr = new byte[carr.length];
        for (int i = 0; i < carr.length; ++i) {
            barr[i] = (byte)carr[i];
        }
        return barr;
    }

    public static byte[] toByteArray(char[] carr, String charset) throws UnsupportedEncodingException {
        return new String(carr).getBytes(charset);
    }

    public static byte[] toAsciiArray(char[] carr) {
        if (carr == null) {
            return null;
        }
        byte[] barr = new byte[carr.length];
        for (int i = 0; i < carr.length; ++i) {
            barr[i] = (byte)CharUtil.toAscii(carr[i]);
        }
        return barr;
    }

    public static byte[] toByteArray(CharSequence charSequence) {
        if (charSequence == null) {
            return null;
        }
        byte[] barr = new byte[charSequence.length()];
        for (int i = 0; i < barr.length; ++i) {
            barr[i] = (byte)charSequence.charAt(i);
        }
        return barr;
    }

    public static byte[] toAsciiArray(CharSequence charSequence) {
        if (charSequence == null) {
            return null;
        }
        byte[] barr = new byte[charSequence.length()];
        for (int i = 0; i < barr.length; ++i) {
            barr[i] = (byte)CharUtil.toAscii(charSequence.charAt(i));
        }
        return barr;
    }

    public static char[] toCharArray(byte[] barr) {
        if (barr == null) {
            return null;
        }
        char[] carr = new char[barr.length];
        for (int i = 0; i < barr.length; ++i) {
            carr[i] = (char)barr[i];
        }
        return carr;
    }

    public static char[] toCharArray(byte[] barr, String charset) throws UnsupportedEncodingException {
        return new String(barr, charset).toCharArray();
    }

    public static int toAscii(char c) {
        if (c <= '\u00ff') {
            return c;
        }
        return 63;
    }

    public static boolean equalsOne(char c, char[] match) {
        for (char aMatch : match) {
            if (c != aMatch) continue;
            return true;
        }
        return false;
    }

    public static int findFirstEqual(char[] source, int index, char[] match) {
        for (int i = index; i < source.length; ++i) {
            if (!CharUtil.equalsOne(source[i], match)) continue;
            return i;
        }
        return -1;
    }

    public static int findFirstEqual(char[] source, int index, char match) {
        for (int i = index; i < source.length; ++i) {
            if (source[i] != match) continue;
            return i;
        }
        return -1;
    }

    public static int findFirstDiff(char[] source, int index, char[] match) {
        for (int i = index; i < source.length; ++i) {
            if (CharUtil.equalsOne(source[i], match)) continue;
            return i;
        }
        return -1;
    }

    public static int findFirstDiff(char[] source, int index, char match) {
        for (int i = index; i < source.length; ++i) {
            if (source[i] == match) continue;
            return i;
        }
        return -1;
    }

    public static boolean isCharAtEqual(char[] source, int index, char match) {
        if (index < 0 || index >= source.length) {
            return false;
        }
        return source[index] == match;
    }

    public static boolean isCharAtEqual(CharSequence source, int index, char match) {
        if (index < 0 || index >= source.length()) {
            return false;
        }
        return source.charAt(index) == match;
    }

    public static boolean isWhitespace(char c) {
        return c <= ' ';
    }

    public static boolean isLowercaseLetter(char c) {
        return c >= 'a' && c <= 'z';
    }

    public static boolean isUppercaseLetter(char c) {
        return c >= 'A' && c <= 'Z';
    }

    public static boolean isLetter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    public static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static boolean isLetterOrDigit(char c) {
        return CharUtil.isDigit(c) || CharUtil.isLetter(c);
    }

    public static boolean isWordChar(char c) {
        return CharUtil.isDigit(c) || CharUtil.isLetter(c) || c == '_';
    }

    public static boolean isPropertyNameChar(char c) {
        return CharUtil.isDigit(c) || CharUtil.isLetter(c) || c == '_' || c == '.' || c == '[' || c == ']';
    }

    public static char toUpperAscii(char c) {
        if (CharUtil.isLowercaseLetter(c)) {
            c = (char)(c - 32);
        }
        return c;
    }

    public static char toLowerAscii(char c) {
        if (CharUtil.isUppercaseLetter(c)) {
            c = (char)(c + 32);
        }
        return c;
    }
}

