/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.asset;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.asset.model.AssetRenderer;
import com.liferay.portlet.asset.model.BaseAssetRendererFactory;
import com.liferay.portlet.wiki.NoSuchPageException;
import com.liferay.portlet.wiki.asset.WikiPageAssetRenderer;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.model.WikiPageResource;
import com.liferay.portlet.wiki.service.WikiPageLocalServiceUtil;
import com.liferay.portlet.wiki.service.WikiPageResourceLocalServiceUtil;
import com.liferay.portlet.wiki.service.permission.WikiPagePermission;
import javax.portlet.PortletURL;

public class WikiPageAssetRendererFactory
extends BaseAssetRendererFactory {
    public static final String CLASS_NAME = WikiPage.class.getName();
    public static final String TYPE = "wiki";

    public AssetRenderer getAssetRenderer(long classPK, int type) throws PortalException, SystemException {
        WikiPage page = null;
        try {
            page = WikiPageLocalServiceUtil.getWikiPage((long)classPK);
        }
        catch (NoSuchPageException noSuchPageException) {
            if (type == 1) {
                page = WikiPageLocalServiceUtil.getPage((long)classPK);
            }
            WikiPageResource wikiPageResource = WikiPageResourceLocalServiceUtil.getPageResource((long)classPK);
            page = WikiPageLocalServiceUtil.getPage((long)wikiPageResource.getNodeId(), (String)wikiPageResource.getTitle(), null);
        }
        return new WikiPageAssetRenderer(page);
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public String getType() {
        return TYPE;
    }

    public PortletURL getURLAdd(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) {
        return null;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws Exception {
        return WikiPagePermission.contains(permissionChecker, classPK, actionId);
    }

    protected String getIconPath(ThemeDisplay themeDisplay) {
        return String.valueOf(themeDisplay.getPathThemeImages()) + "/common/pages.png";
    }
}

