/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.imagegallery.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.asset.util.AssetUtil;
import com.liferay.portlet.imagegallery.DuplicateFolderNameException;
import com.liferay.portlet.imagegallery.FolderNameException;
import com.liferay.portlet.imagegallery.model.IGFolder;
import com.liferay.portlet.imagegallery.model.IGImage;
import com.liferay.portlet.imagegallery.service.base.IGFolderLocalServiceBaseImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IGFolderLocalServiceImpl
extends IGFolderLocalServiceBaseImpl {
    public IGFolder addFolder(long userId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long groupId = serviceContext.getScopeGroupId();
        parentFolderId = this.getParentFolderId(groupId, parentFolderId);
        Date now = new Date();
        this.validate(groupId, parentFolderId, name);
        long folderId = this.counterLocalService.increment();
        IGFolder folder = this.igFolderPersistence.create(folderId);
        folder.setUuid(serviceContext.getUuid());
        folder.setGroupId(groupId);
        folder.setCompanyId(user.getCompanyId());
        folder.setUserId(user.getUserId());
        folder.setCreateDate(serviceContext.getCreateDate(now));
        folder.setModifiedDate(serviceContext.getModifiedDate(now));
        folder.setParentFolderId(parentFolderId);
        folder.setName(name);
        folder.setDescription(description);
        folder.setExpandoBridgeAttributes(serviceContext);
        this.igFolderPersistence.update((BaseModel)folder, false);
        if (serviceContext.getAddCommunityPermissions() || serviceContext.getAddGuestPermissions()) {
            this.addFolderResources(folder, serviceContext.getAddCommunityPermissions(), serviceContext.getAddGuestPermissions());
        } else {
            this.addFolderResources(folder, serviceContext.getCommunityPermissions(), serviceContext.getGuestPermissions());
        }
        return folder;
    }

    public void addFolderResources(IGFolder folder, boolean addCommunityPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addResources(folder.getCompanyId(), folder.getGroupId(), folder.getUserId(), IGFolder.class.getName(), folder.getFolderId(), false, addCommunityPermissions, addGuestPermissions);
    }

    public void addFolderResources(IGFolder folder, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addModelResources(folder.getCompanyId(), folder.getGroupId(), folder.getUserId(), IGFolder.class.getName(), folder.getFolderId(), communityPermissions, guestPermissions);
    }

    public void addFolderResources(long folderId, boolean addCommunityPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        IGFolder folder = this.igFolderPersistence.findByPrimaryKey(folderId);
        this.addFolderResources(folder, addCommunityPermissions, addGuestPermissions);
    }

    public void addFolderResources(long folderId, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        IGFolder folder = this.igFolderPersistence.findByPrimaryKey(folderId);
        this.addFolderResources(folder, communityPermissions, guestPermissions);
    }

    public void deleteFolder(IGFolder folder) throws PortalException, SystemException {
        List folders = this.igFolderPersistence.findByG_P(folder.getGroupId(), folder.getFolderId());
        for (IGFolder curFolder : folders) {
            this.deleteFolder(curFolder);
        }
        this.igFolderPersistence.remove((BaseModel)folder);
        this.resourceLocalService.deleteResource(folder.getCompanyId(), IGFolder.class.getName(), 4, folder.getFolderId());
        this.igImageLocalService.deleteImages(folder.getGroupId(), folder.getFolderId());
        this.expandoValueLocalService.deleteValues(IGFolder.class.getName(), folder.getFolderId());
    }

    public void deleteFolder(long folderId) throws PortalException, SystemException {
        IGFolder folder = this.igFolderPersistence.findByPrimaryKey(folderId);
        this.deleteFolder(folder);
    }

    public void deleteFolders(long groupId) throws PortalException, SystemException {
        List folders = this.igFolderPersistence.findByG_P(groupId, 0L);
        for (IGFolder folder : folders) {
            this.deleteFolder(folder);
        }
    }

    public List<IGFolder> getCompanyFolders(long companyId, int start, int end) throws SystemException {
        return this.igFolderPersistence.findByCompanyId(companyId, start, end);
    }

    public int getCompanyFoldersCount(long companyId) throws SystemException {
        return this.igFolderPersistence.countByCompanyId(companyId);
    }

    public IGFolder getFolder(long folderId) throws PortalException, SystemException {
        return this.igFolderPersistence.findByPrimaryKey(folderId);
    }

    public IGFolder getFolder(long groupId, long parentFolderId, String name) throws PortalException, SystemException {
        return this.igFolderPersistence.findByG_P_N(groupId, parentFolderId, name);
    }

    public List<IGFolder> getFolders(long groupId) throws SystemException {
        return this.igFolderPersistence.findByGroupId(groupId);
    }

    public List<IGFolder> getFolders(long groupId, long parentFolderId) throws SystemException {
        return this.igFolderPersistence.findByG_P(groupId, parentFolderId);
    }

    public List<IGFolder> getFolders(long groupId, long parentFolderId, int start, int end) throws SystemException {
        return this.igFolderPersistence.findByG_P(groupId, parentFolderId, start, end);
    }

    public int getFoldersCount(long groupId, long parentFolderId) throws SystemException {
        return this.igFolderPersistence.countByG_P(groupId, parentFolderId);
    }

    public void getSubfolderIds(List<Long> folderIds, long groupId, long folderId) throws SystemException {
        List folders = this.igFolderPersistence.findByG_P(groupId, folderId);
        for (IGFolder folder : folders) {
            folderIds.add(folder.getFolderId());
            this.getSubfolderIds(folderIds, folder.getGroupId(), folder.getFolderId());
        }
    }

    public IGFolder updateFolder(long folderId, long parentFolderId, String name, String description, boolean mergeWithParentFolder, ServiceContext serviceContext) throws PortalException, SystemException {
        IGFolder folder = this.igFolderPersistence.findByPrimaryKey(folderId);
        parentFolderId = this.getParentFolderId(folder, parentFolderId);
        if (mergeWithParentFolder && folderId != parentFolderId) {
            this.mergeFolders(folder, parentFolderId);
            return folder;
        }
        this.validate(folder.getFolderId(), folder.getGroupId(), parentFolderId, name);
        folder.setModifiedDate(serviceContext.getModifiedDate(null));
        folder.setParentFolderId(parentFolderId);
        folder.setName(name);
        folder.setDescription(description);
        folder.setExpandoBridgeAttributes(serviceContext);
        this.igFolderPersistence.update((BaseModel)folder, false);
        return folder;
    }

    protected long getParentFolderId(IGFolder folder, long parentFolderId) throws SystemException {
        if (parentFolderId == 0L) {
            return parentFolderId;
        }
        if (folder.getFolderId() == parentFolderId) {
            return folder.getParentFolderId();
        }
        IGFolder parentFolder = this.igFolderPersistence.fetchByPrimaryKey(parentFolderId);
        if (parentFolder == null || folder.getGroupId() != parentFolder.getGroupId()) {
            return folder.getParentFolderId();
        }
        ArrayList<Long> subfolderIds = new ArrayList<Long>();
        this.getSubfolderIds(subfolderIds, folder.getGroupId(), folder.getFolderId());
        if (subfolderIds.contains(parentFolderId)) {
            return folder.getParentFolderId();
        }
        return parentFolderId;
    }

    protected long getParentFolderId(long groupId, long parentFolderId) throws SystemException {
        IGFolder parentFolder;
        if (parentFolderId != 0L && ((parentFolder = this.igFolderPersistence.fetchByPrimaryKey(parentFolderId)) == null || groupId != parentFolder.getGroupId())) {
            parentFolderId = 0L;
        }
        return parentFolderId;
    }

    protected void mergeFolders(IGFolder fromFolder, long toFolderId) throws PortalException, SystemException {
        List folders = this.igFolderPersistence.findByG_P(fromFolder.getGroupId(), fromFolder.getFolderId());
        for (IGFolder folder : folders) {
            this.mergeFolders(folder, toFolderId);
        }
        List images = this.igImagePersistence.findByG_F(fromFolder.getGroupId(), fromFolder.getFolderId());
        for (IGImage image : images) {
            image.setFolderId(toFolderId);
            this.igImagePersistence.update((BaseModel)image, false);
            Indexer indexer = IndexerRegistryUtil.getIndexer(IGImage.class);
            indexer.reindex((Object)image);
        }
        this.deleteFolder(fromFolder);
    }

    protected void validate(long folderId, long groupId, long parentFolderId, String name) throws PortalException, SystemException {
        if (!AssetUtil.isValidWord(name)) {
            throw new FolderNameException();
        }
        IGFolder folder = this.igFolderPersistence.fetchByG_P_N(groupId, parentFolderId, name);
        if (folder != null && folder.getFolderId() != folderId) {
            throw new DuplicateFolderNameException();
        }
        if (name.indexOf(46) != -1) {
            String nameWithExtension = name;
            name = FileUtil.stripExtension((String)nameWithExtension);
            List images = this.igImagePersistence.findByG_F_N(groupId, parentFolderId, name);
            for (IGImage image : images) {
                if (!nameWithExtension.equals(image.getNameWithExtension())) continue;
                throw new DuplicateFolderNameException();
            }
        }
    }

    protected void validate(long groupId, long parentFolderId, String name) throws PortalException, SystemException {
        long folderId = 0L;
        this.validate(folderId, groupId, parentFolderId, name);
    }
}

