/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.action;

import com.liferay.documentlibrary.DuplicateFileException;
import com.liferay.documentlibrary.FileNameException;
import com.liferay.documentlibrary.FileSizeException;
import com.liferay.documentlibrary.SourceFileNameException;
import com.liferay.portal.DuplicateLockException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PropertiesParamUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.asset.AssetTagException;
import com.liferay.portlet.assetpublisher.util.AssetPublisherUtil;
import com.liferay.portlet.documentlibrary.DuplicateFolderNameException;
import com.liferay.portlet.documentlibrary.NoSuchFileEntryException;
import com.liferay.portlet.documentlibrary.NoSuchFolderException;
import com.liferay.portlet.documentlibrary.action.ActionUtil;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileVersion;
import com.liferay.portlet.documentlibrary.service.DLFileEntryServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileVersionLocalServiceUtil;
import java.io.File;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditFileEntryAction
extends PortletAction {
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                this.updateFileEntry(actionRequest, actionResponse);
            } else if (cmd.equals("delete")) {
                this.deleteFileEntry(actionRequest);
            } else if (cmd.equals("lock")) {
                this.lockFileEntry(actionRequest);
            } else if (cmd.equals("move")) {
                this.moveFileEntry(actionRequest);
            } else if (cmd.equals("revert")) {
                this.revertFileEntry(actionRequest);
            } else if (cmd.equals("unlock")) {
                this.unlockFileEntry(actionRequest);
            }
            this.sendRedirect(actionRequest, actionResponse);
        }
        catch (Exception e) {
            if (e instanceof DuplicateLockException || e instanceof NoSuchFileEntryException || e instanceof PrincipalException) {
                if (e instanceof DuplicateLockException) {
                    DuplicateLockException dle = (DuplicateLockException)e;
                    SessionErrors.add((PortletRequest)actionRequest, (String)dle.getClass().getName(), (Object)dle.getLock());
                } else {
                    SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
                }
                this.setForward((PortletRequest)actionRequest, "portlet.document_library.error");
            }
            if (e instanceof DuplicateFileException || e instanceof DuplicateFolderNameException || e instanceof FileNameException || e instanceof FileSizeException || e instanceof NoSuchFolderException || e instanceof SourceFileNameException) {
                if (e instanceof DuplicateFileException) {
                    HttpServletResponse response = PortalUtil.getHttpServletResponse((PortletResponse)actionResponse);
                    response.setStatus(1000);
                } else if (e instanceof FileNameException) {
                    HttpServletResponse response = PortalUtil.getHttpServletResponse((PortletResponse)actionResponse);
                    response.setStatus(1001);
                } else if (e instanceof FileSizeException) {
                    HttpServletResponse response = PortalUtil.getHttpServletResponse((PortletResponse)actionResponse);
                    response.setStatus(1002);
                }
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
            }
            if (e instanceof AssetTagException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName(), (Object)e);
            }
            throw e;
        }
    }

    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getFileEntry((PortletRequest)renderRequest);
        }
        catch (Exception e) {
            if (e instanceof NoSuchFileEntryException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, (String)e.getClass().getName());
                return mapping.findForward("portlet.document_library.error");
            }
            throw e;
        }
        String forward = "portlet.document_library.edit_file_entry";
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, forward));
    }

    protected void deleteFileEntry(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        long groupId = themeDisplay.getScopeGroupId();
        long folderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"folderId");
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        String version = ParamUtil.getString((PortletRequest)actionRequest, (String)"version");
        DLFileEntryServiceUtil.deleteFileEntry((long)groupId, (long)folderId, (String)name, (String)version);
    }

    protected void lockFileEntry(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        long groupId = themeDisplay.getScopeGroupId();
        long folderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"folderId");
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        DLFileEntryServiceUtil.lockFileEntry((long)groupId, (long)folderId, (String)name);
    }

    protected void moveFileEntry(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        long groupId = themeDisplay.getScopeGroupId();
        long folderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"folderId");
        long newFolderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"newFolderId");
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)DLFileEntry.class.getName(), (PortletRequest)actionRequest);
        DLFileEntryServiceUtil.moveFileEntry((long)groupId, (long)folderId, (long)newFolderId, (String)name, (ServiceContext)serviceContext);
    }

    protected void revertFileEntry(ActionRequest actionRequest) throws Exception {
        String name;
        long folderId;
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        long groupId = themeDisplay.getScopeGroupId();
        DLFileVersion fileVersion = DLFileVersionLocalServiceUtil.getLatestFileVersion((long)groupId, (long)(folderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"folderId")), (String)(name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name")));
        if (fileVersion.getStatus() != 2) {
            return;
        }
        DLFileEntryServiceUtil.deleteFileEntry((long)groupId, (long)folderId, (String)name, (String)fileVersion.getVersion());
    }

    protected void unlockFileEntry(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        long groupId = themeDisplay.getScopeGroupId();
        long folderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"folderId");
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        DLFileEntryServiceUtil.unlockFileEntry((long)groupId, (long)folderId, (String)name);
    }

    protected void updateFileEntry(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        UploadPortletRequest uploadRequest = PortalUtil.getUploadPortletRequest((PortletRequest)actionRequest);
        String cmd = ParamUtil.getString((HttpServletRequest)uploadRequest, (String)"cmd");
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        long groupId = themeDisplay.getScopeGroupId();
        long folderId = ParamUtil.getLong((HttpServletRequest)uploadRequest, (String)"folderId");
        String name = ParamUtil.getString((HttpServletRequest)uploadRequest, (String)"name");
        String sourceFileName = uploadRequest.getFileName("file");
        String title = ParamUtil.getString((HttpServletRequest)uploadRequest, (String)"title");
        String description = ParamUtil.getString((HttpServletRequest)uploadRequest, (String)"description");
        String changeLog = ParamUtil.getString((HttpServletRequest)uploadRequest, (String)"changeLog");
        boolean majorVersion = ParamUtil.getBoolean((HttpServletRequest)uploadRequest, (String)"majorVersion");
        UnicodeProperties extraSettingsProperties = PropertiesParamUtil.getProperties((PortletRequest)actionRequest, (String)"extraSettingsProperties--");
        String extraSettings = extraSettingsProperties.toString();
        File file = uploadRequest.getFile("file");
        if (Validator.isNotNull((String)sourceFileName) && !file.exists()) {
            file.createNewFile();
        }
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)DLFileEntry.class.getName(), (PortletRequest)actionRequest);
        if (cmd.equals("add")) {
            DLFileEntry fileEntry = DLFileEntryServiceUtil.addFileEntry((long)groupId, (long)folderId, (String)sourceFileName, (String)title, (String)description, (String)changeLog, (String)extraSettings, (File)file, (ServiceContext)serviceContext);
            AssetPublisherUtil.addAndStoreSelection(actionRequest, DLFileEntry.class.getName(), fileEntry.getFileEntryId(), -1);
        } else {
            DLFileEntryServiceUtil.updateFileEntry((long)groupId, (long)folderId, (String)name, (String)sourceFileName, (String)title, (String)description, (String)changeLog, (boolean)majorVersion, (String)extraSettings, (File)file, (ServiceContext)serviceContext);
        }
        AssetPublisherUtil.addRecentFolderId((PortletRequest)actionRequest, DLFileEntry.class.getName(), folderId);
    }
}

