/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.communities.action;

import com.liferay.portal.NoSuchGroupException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.LayoutServiceUtil;
import com.liferay.portal.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.communities.action.ActionUtil;
import com.liferay.util.servlet.ServletResponseUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class ExportPagesAction
extends PortletAction {
    private static Log _log = LogFactoryUtil.getLog(ExportPagesAction.class);

    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        try {
            ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
            long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
            boolean privateLayout = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"privateLayout");
            String fileName = ParamUtil.getString((PortletRequest)actionRequest, (String)"exportFileName");
            String range = ParamUtil.getString((PortletRequest)actionRequest, (String)"range");
            Date startDate = null;
            Date endDate = null;
            if (range.equals("dateRange")) {
                int startDateMonth = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"startDateMonth");
                int startDateDay = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"startDateDay");
                int startDateYear = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"startDateYear");
                int startDateHour = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"startDateHour");
                int startDateMinute = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"startDateMinute");
                int startDateAmPm = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"startDateAmPm");
                if (startDateAmPm == 1) {
                    startDateHour += 12;
                }
                startDate = PortalUtil.getDate((int)startDateMonth, (int)startDateDay, (int)startDateYear, (int)startDateHour, (int)startDateMinute, (TimeZone)themeDisplay.getTimeZone(), (PortalException)new PortalException());
                int endDateMonth = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"endDateMonth");
                int endDateDay = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"endDateDay");
                int endDateYear = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"endDateYear");
                int endDateHour = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"endDateHour");
                int endDateMinute = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"endDateMinute");
                int endDateAmPm = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"endDateAmPm");
                if (endDateAmPm == 1) {
                    endDateHour += 12;
                }
                endDate = PortalUtil.getDate((int)endDateMonth, (int)endDateDay, (int)endDateYear, (int)endDateHour, (int)endDateMinute, (TimeZone)themeDisplay.getTimeZone(), (PortalException)new PortalException());
            } else if (range.equals("fromLastPublishDate")) {
                LayoutSet layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)groupId, (boolean)privateLayout);
                UnicodeProperties settingsProperties = layoutSet.getSettingsProperties();
                long lastPublishDate = GetterUtil.getLong((String)settingsProperties.getProperty("last-publish-date"));
                if (lastPublishDate > 0L) {
                    Calendar cal = Calendar.getInstance(themeDisplay.getTimeZone(), themeDisplay.getLocale());
                    endDate = cal.getTime();
                    cal.setTimeInMillis(lastPublishDate);
                    startDate = cal.getTime();
                }
            } else if (range.equals("last")) {
                int rangeLast = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"last");
                Date now = new Date();
                startDate = new Date(now.getTime() - (long)rangeLast * 3600000L);
                endDate = now;
            }
            File file = LayoutServiceUtil.exportLayoutsAsFile((long)groupId, (boolean)privateLayout, null, (Map)actionRequest.getParameterMap(), startDate, endDate);
            HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)actionRequest);
            HttpServletResponse response = PortalUtil.getHttpServletResponse((PortletResponse)actionResponse);
            ServletResponseUtil.sendFile((HttpServletRequest)request, (HttpServletResponse)response, (String)fileName, (InputStream)new FileInputStream(file), (String)"application/zip");
            this.setForward((PortletRequest)actionRequest, "/common/null.jsp");
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
            String pagesRedirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"pagesRedirect");
            this.sendRedirect(actionRequest, actionResponse, pagesRedirect);
        }
    }

    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getGroup((PortletRequest)renderRequest);
        }
        catch (Exception e) {
            if (e instanceof NoSuchGroupException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, (String)e.getClass().getName());
                return mapping.findForward("portlet.communities.error");
            }
            throw e;
        }
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.communities.export_pages"));
    }
}

