/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.calendar.asset;

import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.asset.model.BaseAssetRenderer;
import com.liferay.portlet.calendar.model.CalEvent;
import com.liferay.portlet.calendar.service.permission.CalEventPermission;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

public class CalEventAssetRenderer
extends BaseAssetRenderer {
    private CalEvent _event;

    public CalEventAssetRenderer(CalEvent event) {
        this._event = event;
    }

    public long getClassPK() {
        return this._event.getEventId();
    }

    public String getDiscussionPath() {
        if (PropsValues.CALENDAR_EVENT_COMMENTS_ENABLED) {
            return "edit_event_discussion";
        }
        return null;
    }

    public long getGroupId() {
        return this._event.getGroupId();
    }

    public String getSummary() {
        return this._event.getTitle();
    }

    public String getTitle() {
        return this._event.getTitle();
    }

    public PortletURL getURLEdit(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) {
        LiferayPortletURL editPortletURL = liferayPortletResponse.createRenderURL("8");
        editPortletURL.setParameter("struts_action", "/calendar/edit_event");
        editPortletURL.setParameter("eventId", String.valueOf(this._event.getEventId()));
        return editPortletURL;
    }

    public String getURLViewInContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, String noSuchEntryRedirect) {
        ThemeDisplay themeDisplay = (ThemeDisplay)liferayPortletRequest.getAttribute("THEME_DISPLAY");
        return String.valueOf(themeDisplay.getPathMain()) + "/calendar/find_event?eventId=" + this._event.getEventId();
    }

    public long getUserId() {
        return this._event.getUserId();
    }

    public String getUuid() {
        return this._event.getUuid();
    }

    public boolean hasEditPermission(PermissionChecker permissionChecker) {
        return CalEventPermission.contains(permissionChecker, this._event, "UPDATE");
    }

    public boolean hasViewPermission(PermissionChecker permissionChecker) {
        return CalEventPermission.contains(permissionChecker, this._event, "VIEW");
    }

    public boolean isPrintable() {
        return true;
    }

    public String render(RenderRequest renderRequest, RenderResponse renderResponse, String template) throws Exception {
        if (template.equals("abstract") || template.equals("full_content")) {
            renderRequest.setAttribute("CALENDAR_EVENT", (Object)this._event);
            return "/html/portlet/calendar/asset/" + template + ".jsp";
        }
        return null;
    }

    protected String getIconPath(ThemeDisplay themeDisplay) {
        return String.valueOf(themeDisplay.getPathThemeImages()) + "/common/date.png";
    }
}

