/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.security.auth.HttpPrincipal;
import com.liferay.portal.service.http.TunnelUtil;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.asset.model.AssetEntryDisplay;
import com.liferay.portlet.asset.service.AssetEntryServiceUtil;
import com.liferay.portlet.asset.service.persistence.AssetEntryQuery;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssetEntryServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(AssetEntryServiceHttp.class);

    public static void deleteEntry(HttpPrincipal httpPrincipal, long entryId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(AssetEntryServiceUtil.class.getName(), "deleteEntry", new Class[]{Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{entryId});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<AssetEntry> getCompanyEntries(HttpPrincipal httpPrincipal, long companyId, int start, int end) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(AssetEntryServiceUtil.class.getName(), "getCompanyEntries", new Class[]{Long.TYPE, Integer.TYPE, Integer.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, start, end});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static int getCompanyEntriesCount(HttpPrincipal httpPrincipal, long companyId) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(AssetEntryServiceUtil.class.getName(), "getCompanyEntriesCount", new Class[]{Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Integer)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static String getCompanyEntriesRSS(HttpPrincipal httpPrincipal, long companyId, int max, String type, double version, String displayStyle, String feedURL, String tagURL) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(AssetEntryServiceUtil.class.getName(), "getCompanyEntriesRSS", new Class[]{Long.TYPE, Integer.TYPE, String.class, Double.TYPE, String.class, String.class, String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, max, type, version, displayStyle, feedURL, tagURL});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (String)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static AssetEntryDisplay[] getCompanyEntryDisplays(HttpPrincipal httpPrincipal, long companyId, int start, int end, String languageId) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(AssetEntryServiceUtil.class.getName(), "getCompanyEntryDisplays", new Class[]{Long.TYPE, Integer.TYPE, Integer.TYPE, String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, start, end, languageId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (AssetEntryDisplay[])returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<AssetEntry> getEntries(HttpPrincipal httpPrincipal, AssetEntryQuery entryQuery) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(AssetEntryServiceUtil.class.getName(), "getEntries", new Class[]{AssetEntryQuery.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{entryQuery});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static int getEntriesCount(HttpPrincipal httpPrincipal, AssetEntryQuery entryQuery) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(AssetEntryServiceUtil.class.getName(), "getEntriesCount", new Class[]{AssetEntryQuery.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{entryQuery});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Integer)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static String getEntriesRSS(HttpPrincipal httpPrincipal, AssetEntryQuery entryQuery, String name, String type, double version, String displayStyle, String feedURL, String tagURL) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(AssetEntryServiceUtil.class.getName(), "getEntriesRSS", new Class[]{AssetEntryQuery.class, String.class, String.class, Double.TYPE, String.class, String.class, String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{entryQuery, name, type, version, displayStyle, feedURL, tagURL});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (String)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static AssetEntry getEntry(HttpPrincipal httpPrincipal, long entryId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(AssetEntryServiceUtil.class.getName(), "getEntry", new Class[]{Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{entryId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (AssetEntry)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void incrementViewCounter(HttpPrincipal httpPrincipal, String className, long classPK) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(AssetEntryServiceUtil.class.getName(), "incrementViewCounter", new Class[]{String.class, Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{className, classPK});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static AssetEntryDisplay[] searchEntryDisplays(HttpPrincipal httpPrincipal, long companyId, String portletId, String keywords, String languageId, int start, int end) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(AssetEntryServiceUtil.class.getName(), "searchEntryDisplays", new Class[]{Long.TYPE, String.class, String.class, String.class, Integer.TYPE, Integer.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, portletId, keywords, languageId, start, end});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (AssetEntryDisplay[])returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static int searchEntryDisplaysCount(HttpPrincipal httpPrincipal, long companyId, String portletId, String keywords, String languageId) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(AssetEntryServiceUtil.class.getName(), "searchEntryDisplaysCount", new Class[]{Long.TYPE, String.class, String.class, String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, portletId, keywords, languageId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Integer)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static AssetEntry updateEntry(HttpPrincipal httpPrincipal, long groupId, String className, long classPK, String classUuid, long[] categoryIds, String[] tagNames, boolean visible, Date startDate, Date endDate, Date publishDate, Date expirationDate, String mimeType, String title, String description, String summary, String url, int height, int width, Integer priority, boolean sync) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(AssetEntryServiceUtil.class.getName(), "updateEntry", new Class[]{Long.TYPE, String.class, Long.TYPE, String.class, long[].class, String[].class, Boolean.TYPE, Date.class, Date.class, Date.class, Date.class, String.class, String.class, String.class, String.class, String.class, Integer.TYPE, Integer.TYPE, Integer.class, Boolean.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, className, classPK, classUuid, categoryIds, tagNames, visible, startDate, endDate, publishDate, expirationDate, mimeType, title, description, summary, url, height, width, priority, sync});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (AssetEntry)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }
}

