/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.io.unsync.UnsyncPrintWriter;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.velocity.VelocityContext;
import com.liferay.portal.kernel.velocity.VelocityEngineUtil;
import com.liferay.portal.util.PortalUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.MimeResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apache.velocity.io.VelocityWriter;
import org.apache.velocity.util.SimplePool;

public class VelocityPortlet
extends GenericPortlet {
    private static SimplePool _writerPool = new SimplePool(40);
    private String _portletContextName;
    private String _actionTemplateId;
    private String _editTemplateId;
    private String _helpTemplateId;
    private String _resourceTemplateId;
    private String _viewTemplateId;

    public void init(PortletConfig portletConfig) throws PortletException {
        super.init(portletConfig);
        PortletContext portletContext = portletConfig.getPortletContext();
        this._portletContextName = portletContext.getPortletContextName();
        this._actionTemplateId = this.getVelocityTemplateId(this.getInitParameter("action-template"));
        this._editTemplateId = this.getVelocityTemplateId(this.getInitParameter("edit-template"));
        this._helpTemplateId = this.getVelocityTemplateId(this.getInitParameter("help-template"));
        this._resourceTemplateId = this.getVelocityTemplateId(this.getInitParameter("resource-template"));
        this._viewTemplateId = this.getVelocityTemplateId(this.getInitParameter("view-template"));
    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException {
        if (Validator.isNull((String)this._actionTemplateId)) {
            return;
        }
        try {
            this.mergeTemplate(this._actionTemplateId, (PortletRequest)actionRequest, (PortletResponse)actionResponse);
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    public void serveResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws PortletException, IOException {
        if (Validator.isNull((String)this._resourceTemplateId)) {
            String resourceId = resourceRequest.getResourceID();
            if (!PortalUtil.isValidResourceId((String)resourceId)) {
                return;
            }
            super.serveResource(resourceRequest, resourceResponse);
            return;
        }
        try {
            this.mergeTemplate(this._resourceTemplateId, (PortletRequest)resourceRequest, (PortletResponse)resourceResponse);
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    public void doEdit(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        if (renderRequest.getPreferences() == null) {
            super.doEdit(renderRequest, renderResponse);
            return;
        }
        try {
            this.mergeTemplate(this._editTemplateId, (PortletRequest)renderRequest, (PortletResponse)renderResponse);
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    public void doHelp(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException {
        try {
            this.mergeTemplate(this._helpTemplateId, (PortletRequest)renderRequest, (PortletResponse)renderResponse);
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    public void doView(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException {
        try {
            this.mergeTemplate(this._viewTemplateId, (PortletRequest)renderRequest, (PortletResponse)renderResponse);
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    protected VelocityContext getVelocityContext(PortletRequest portletRequest, PortletResponse portletResponse) {
        VelocityContext velocityContext = VelocityEngineUtil.getWrappedStandardToolsContext();
        velocityContext.put("portletConfig", (Object)this.getPortletConfig());
        velocityContext.put("portletContext", (Object)this.getPortletContext());
        velocityContext.put("preferences", (Object)portletRequest.getPreferences());
        velocityContext.put("userInfo", portletRequest.getAttribute("javax.portlet.userinfo"));
        velocityContext.put("portletRequest", (Object)portletRequest);
        if (portletRequest instanceof ActionRequest) {
            velocityContext.put("actionRequest", (Object)portletRequest);
        } else if (portletRequest instanceof RenderRequest) {
            velocityContext.put("renderRequest", (Object)portletRequest);
        } else {
            velocityContext.put("resourceRequest", (Object)portletRequest);
        }
        velocityContext.put("portletResponse", (Object)portletResponse);
        if (portletResponse instanceof ActionResponse) {
            velocityContext.put("actionResponse", (Object)portletResponse);
        } else if (portletRequest instanceof RenderResponse) {
            velocityContext.put("renderResponse", (Object)portletResponse);
        } else {
            velocityContext.put("resourceResponse", (Object)portletResponse);
        }
        return velocityContext;
    }

    protected String getVelocityTemplateId(String name) {
        if (Validator.isNull((String)name)) {
            return name;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(this._portletContextName);
        sb.append("_SERVLET_CONTEXT_");
        sb.append("/html");
        sb.append(name);
        return sb.toString();
    }

    protected void mergeTemplate(String velocityTemplateId, PortletRequest portletRequest, PortletResponse portletResponse) throws Exception {
        this.mergeTemplate(velocityTemplateId, this.getVelocityContext(portletRequest, portletResponse), portletRequest, portletResponse);
    }

    protected void mergeTemplate(String velocityTemplateId, VelocityContext velocityContext, PortletRequest portletRequest, PortletResponse portletResponse) throws Exception {
        if (portletResponse instanceof MimeResponse) {
            MimeResponse mimeResponse = (MimeResponse)portletResponse;
            mimeResponse.setContentType(portletRequest.getResponseContentType());
        }
        VelocityWriter velocityWriter = null;
        try {
            velocityWriter = (VelocityWriter)_writerPool.get();
            Object output = null;
            if (portletResponse instanceof MimeResponse) {
                MimeResponse mimeResponse = (MimeResponse)portletResponse;
                output = mimeResponse.getWriter();
            } else {
                output = new UnsyncPrintWriter((OutputStream)System.out);
            }
            if (velocityWriter == null) {
                velocityWriter = new VelocityWriter((Writer)output, 4096, true);
            } else {
                velocityWriter.recycle((Writer)output);
            }
            VelocityEngineUtil.mergeTemplate((String)velocityTemplateId, null, (VelocityContext)velocityContext, (Writer)velocityWriter);
        }
        catch (Throwable throwable) {
            try {
                if (velocityWriter != null) {
                    velocityWriter.flush();
                    velocityWriter.recycle(null);
                    _writerPool.put((Object)velocityWriter);
                }
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            if (velocityWriter != null) {
                velocityWriter.flush();
                velocityWriter.recycle(null);
                _writerPool.put((Object)velocityWriter);
            }
        }
        catch (Exception exception) {}
    }
}

