/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.PortletFilterUtil;
import com.liferay.portal.kernel.servlet.StringServletResponse;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.PortletApp;
import com.liferay.portlet.FilterChainImpl;
import com.liferay.portlet.InvokerPortlet;
import com.liferay.portlet.InvokerPortletResponse;
import com.liferay.portlet.PortletConfigImpl;
import com.liferay.portlet.PortletContextBag;
import com.liferay.portlet.PortletContextBagPool;
import com.liferay.portlet.PortletContextImpl;
import com.liferay.portlet.PortletFilterFactory;
import com.liferay.portlet.PortletResponseImpl;
import com.liferay.portlet.PortletSessionImpl;
import com.liferay.portlet.RenderRequestImpl;
import com.liferay.portlet.RenderResponseImpl;
import com.liferay.portlet.StrutsPortlet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.filter.ActionFilter;
import javax.portlet.filter.EventFilter;
import javax.portlet.filter.FilterChain;
import javax.portlet.filter.PortletFilter;
import javax.portlet.filter.RenderFilter;
import javax.portlet.filter.ResourceFilter;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.time.StopWatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvokerPortletImpl
implements InvokerPortlet {
    private static Log _log = LogFactoryUtil.getLog(InvokerPortletImpl.class);
    private com.liferay.portal.model.Portlet _portletModel;
    private String _portletId;
    private Portlet _portlet;
    private PortletConfigImpl _portletConfigImpl;
    private PortletContextImpl _portletContextImpl;
    private Integer _expCache;
    private boolean _checkAuthToken;
    private boolean _destroyable;
    private boolean _facesPortlet;
    private boolean _strutsPortlet;
    private boolean _strutsBridgePortlet;
    private Map<String, List<ActionFilter>> _actionFiltersMap = new HashMap<String, List<ActionFilter>>();
    private Map<String, List<EventFilter>> _eventFiltersMap = new HashMap<String, List<EventFilter>>();
    private Map<String, List<RenderFilter>> _renderFiltersMap = new HashMap<String, List<RenderFilter>>();
    private Map<String, List<ResourceFilter>> _resourceFiltersMap = new HashMap<String, List<ResourceFilter>>();

    public static void clearResponse(HttpSession session, long plid, String portletId, String languageId) {
        String sesResponseId = InvokerPortletImpl.encodeResponseKey(plid, portletId, languageId);
        InvokerPortletImpl.getResponses(session).remove(sesResponseId);
    }

    public static void clearResponses(HttpSession session) {
        InvokerPortletImpl.getResponses(session).clear();
    }

    public static void clearResponses(PortletSession session) {
        InvokerPortletImpl.getResponses(session).clear();
    }

    public static String encodeResponseKey(long plid, String portletId, String languageId) {
        StringBundler sb = new StringBundler(5);
        sb.append(plid);
        sb.append("_");
        sb.append(portletId);
        sb.append("_");
        sb.append(languageId);
        return sb.toString();
    }

    public static Map<String, InvokerPortletResponse> getResponses(HttpSession session) {
        ConcurrentHashMap responses = (ConcurrentHashMap)session.getAttribute("CACHE_PORTLET_RESPONSES");
        if (responses == null) {
            responses = new ConcurrentHashMap();
            session.setAttribute("CACHE_PORTLET_RESPONSES", responses);
        }
        return responses;
    }

    public static Map<String, InvokerPortletResponse> getResponses(PortletSession portletSession) {
        return InvokerPortletImpl.getResponses(((PortletSessionImpl)portletSession).getHttpSession());
    }

    public InvokerPortlet create(com.liferay.portal.model.Portlet portletModel, Portlet portlet, PortletContext portletContext) throws PortletException {
        try {
            InvokerPortlet invokerPortlet = (InvokerPortlet)this.clone();
            invokerPortlet.prepare(portletModel, portlet, portletContext);
            return invokerPortlet;
        }
        catch (PortletException pe) {
            throw pe;
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    public InvokerPortlet create(com.liferay.portal.model.Portlet portletModel, Portlet portlet, PortletConfig portletConfig, PortletContext portletContext, boolean checkAuthToken, boolean facesPortlet, boolean strutsPortlet, boolean strutsBridgePortlet) throws PortletException {
        try {
            InvokerPortlet invokerPortlet = (InvokerPortlet)this.clone();
            invokerPortlet.prepare(portletModel, portlet, portletConfig, portletContext, checkAuthToken, facesPortlet, strutsPortlet, strutsBridgePortlet);
            return invokerPortlet;
        }
        catch (PortletException pe) {
            throw pe;
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    public void destroy() {
        if (this._destroyable) {
            Thread currentThread = Thread.currentThread();
            ClassLoader contextClassLoader = currentThread.getContextClassLoader();
            ClassLoader portletClassLoader = this.getPortletClassLoader();
            try {
                if (portletClassLoader != null) {
                    currentThread.setContextClassLoader(portletClassLoader);
                }
                this.removePortletFilters();
                this._portlet.destroy();
            }
            finally {
                if (portletClassLoader != null) {
                    currentThread.setContextClassLoader(contextClassLoader);
                }
            }
        }
        this._destroyable = false;
    }

    public Portlet getPortlet() {
        return this._portlet;
    }

    public ClassLoader getPortletClassLoader() {
        return (ClassLoader)this._portletContextImpl.getAttribute("PORTLET_CLASS_LOADER");
    }

    public PortletConfigImpl getPortletConfig() {
        return this._portletConfigImpl;
    }

    public PortletContextImpl getPortletContext() {
        return this._portletContextImpl;
    }

    public Portlet getPortletInstance() {
        return this._portlet;
    }

    public Integer getExpCache() {
        return this._expCache;
    }

    public void init(PortletConfig portletConfig) throws PortletException {
        this._portletConfigImpl = (PortletConfigImpl)portletConfig;
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        ClassLoader portletClassLoader = this.getPortletClassLoader();
        try {
            if (portletClassLoader != null) {
                currentThread.setContextClassLoader(portletClassLoader);
            }
            this._portlet.init(portletConfig);
        }
        finally {
            if (portletClassLoader != null) {
                currentThread.setContextClassLoader(contextClassLoader);
            }
        }
        this._destroyable = true;
    }

    public boolean isCheckAuthToken() {
        return this._checkAuthToken;
    }

    public boolean isDestroyable() {
        return this._destroyable;
    }

    public boolean isFacesPortlet() {
        return this._facesPortlet;
    }

    public boolean isStrutsBridgePortlet() {
        return this._strutsBridgePortlet;
    }

    public boolean isStrutsPortlet() {
        return this._strutsPortlet;
    }

    public void prepare(com.liferay.portal.model.Portlet portletModel, Portlet portlet, PortletContext portletContext) throws PortletException {
        this._portletModel = portletModel;
        this._portletId = this._portletModel.getPortletId();
        this._portlet = portlet;
        this._portletContextImpl = (PortletContextImpl)portletContext;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Create root cache wrapper for " + this._portletContextImpl.getPortlet().getPortletId()));
        }
        Map initParams = portletModel.getInitParams();
        this._checkAuthToken = GetterUtil.getBoolean((String)((String)initParams.get("check-auth-token")), (boolean)true);
        if (ClassUtil.isSubclass(this._portlet.getClass(), (String)"org.apache.myfaces.portlet.MyFacesGenericPortlet") || ClassUtil.isSubclass(this._portlet.getClass(), (String)"javax.portlet.faces.GenericFacesPortlet") || ClassUtil.isSubclass(this._portlet.getClass(), (String)"com.sun.faces.portlet.FacesPortlet")) {
            this._facesPortlet = true;
        }
        this._strutsPortlet = ClassUtil.isSubclass(portlet.getClass(), StrutsPortlet.class);
        this._strutsBridgePortlet = ClassUtil.isSubclass(portlet.getClass(), (String)"org.apache.portals.bridges.struts.StrutsPortlet");
        this._expCache = portletModel.getExpCache();
        this.setPortletFilters();
    }

    public void prepare(com.liferay.portal.model.Portlet portletModel, Portlet portlet, PortletConfig portletConfig, PortletContext portletContext, boolean checkAuthToken, boolean facesPortlet, boolean strutsPortlet, boolean strutsBridgePortlet) throws PortletException {
        this._portletModel = portletModel;
        this._portlet = portlet;
        this._portletId = this._portletModel.getPortletId();
        this._portletContextImpl = (PortletContextImpl)portletContext;
        this._checkAuthToken = checkAuthToken;
        this._facesPortlet = facesPortlet;
        this._strutsPortlet = strutsPortlet;
        this._strutsBridgePortlet = strutsBridgePortlet;
        this._expCache = portletModel.getExpCache();
        this.setPortletFilters();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Create instance cache wrapper for " + this._portletContextImpl.getPortlet().getPortletId()));
        }
        this._portletConfigImpl = (PortletConfigImpl)portletConfig;
    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws IOException {
        StopWatch stopWatch = null;
        if (_log.isDebugEnabled()) {
            stopWatch = new StopWatch();
            stopWatch.start();
        }
        try {
            this.invokeAction(actionRequest, actionResponse);
        }
        catch (PortletException pe) {
            actionRequest.setAttribute(String.valueOf(this._portletId) + PortletException.class.getName(), (Object)pe);
        }
        if (_log.isDebugEnabled()) {
            if (stopWatch != null) {
                _log.debug((Object)("processAction for " + this._portletId + " takes " + stopWatch.getTime() + " ms"));
            } else {
                _log.debug((Object)("processAction for " + this._portletId + " is finished"));
            }
        }
    }

    public void processEvent(EventRequest eventRequest, EventResponse eventResponse) throws IOException, PortletException {
        StopWatch stopWatch = null;
        if (_log.isDebugEnabled()) {
            stopWatch = new StopWatch();
            stopWatch.start();
        }
        this.invokeEvent(eventRequest, eventResponse);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("processEvent for " + this._portletId + " takes " + stopWatch.getTime() + " ms"));
        }
    }

    public void render(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        String remoteUser;
        PortletException portletException = (PortletException)((Object)renderRequest.getAttribute(String.valueOf(this._portletId) + PortletException.class.getName()));
        if (portletException != null) {
            throw portletException;
        }
        StopWatch stopWatch = null;
        if (_log.isDebugEnabled()) {
            stopWatch = new StopWatch();
            stopWatch.start();
        }
        if ((remoteUser = renderRequest.getRemoteUser()) == null || this._expCache == null || this._expCache == 0) {
            this.invokeRender(renderRequest, renderResponse);
        } else {
            String sessionResponseId;
            RenderResponseImpl renderResponseImpl = (RenderResponseImpl)renderResponse;
            StringServletResponse stringResponse = (StringServletResponse)renderResponseImpl.getHttpServletResponse();
            PortletSession portletSession = renderRequest.getPortletSession();
            long now = System.currentTimeMillis();
            Layout layout = (Layout)renderRequest.getAttribute("LAYOUT");
            Map<String, InvokerPortletResponse> sessionResponses = InvokerPortletImpl.getResponses(portletSession);
            InvokerPortletResponse response = sessionResponses.get(sessionResponseId = InvokerPortletImpl.encodeResponseKey(layout.getPlid(), this._portletId, LanguageUtil.getLanguageId((PortletRequest)renderRequest)));
            if (response == null) {
                String title = this.invokeRender(renderRequest, renderResponse);
                response = new InvokerPortletResponse(title, stringResponse.getString(), now + 1000L * (long)this._expCache.intValue());
                sessionResponses.put(sessionResponseId, response);
            } else if (response.getTime() < now && this._expCache > 0) {
                String title = this.invokeRender(renderRequest, renderResponse);
                response.setTitle(title);
                response.setContent(stringResponse.getString());
                response.setTime(now + 1000L * (long)this._expCache.intValue());
            } else {
                renderResponseImpl.setTitle(response.getTitle());
                stringResponse.getWriter().print(response.getContent());
            }
        }
        Map<String, String[]> properties = ((RenderResponseImpl)renderResponse).getProperties();
        if (properties.containsKey("clear-request-parameters")) {
            Map<String, String[]> renderParameters = ((RenderRequestImpl)renderRequest).getRenderParameters();
            renderParameters.clear();
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("render for " + this._portletId + " takes " + stopWatch.getTime() + " ms"));
        }
    }

    public void serveResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws IOException {
        StopWatch stopWatch = null;
        if (_log.isDebugEnabled()) {
            stopWatch = new StopWatch();
            stopWatch.start();
        }
        try {
            this.invokeResource(resourceRequest, resourceResponse);
        }
        catch (PortletException pe) {
            resourceRequest.setAttribute(String.valueOf(this._portletId) + PortletException.class.getName(), (Object)pe);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("serveResource for " + this._portletId + " takes " + stopWatch.getTime() + " ms"));
        }
    }

    public void setPortletFilters() throws PortletException {
        PortletApp portletApp = this._portletModel.getPortletApp();
        PortletContextBag portletContextBag = PortletContextBagPool.get(portletApp.getServletContextName());
        if (portletApp.isWARFile() && portletContextBag == null) {
            return;
        }
        this.removePortletFilters();
        Map portletFilters = this._portletModel.getPortletFilters();
        for (Map.Entry entry : portletFilters.entrySet()) {
            com.liferay.portal.model.PortletFilter portletFilterModel = (com.liferay.portal.model.PortletFilter)entry.getValue();
            PortletFilter portletFilter = PortletFilterFactory.create(portletFilterModel, this._portletContextImpl);
            Set lifecycles = portletFilterModel.getLifecycles();
            if (lifecycles.contains("ACTION_PHASE")) {
                List<ActionFilter> actionFilters = this._actionFiltersMap.get(this._portletId);
                if (actionFilters == null) {
                    actionFilters = new ArrayList<ActionFilter>();
                }
                actionFilters.add((ActionFilter)portletFilter);
                this._actionFiltersMap.put(this._portletId, actionFilters);
            }
            if (lifecycles.contains("EVENT_PHASE")) {
                List<EventFilter> eventFilters = this._eventFiltersMap.get(this._portletId);
                if (eventFilters == null) {
                    eventFilters = new ArrayList<EventFilter>();
                }
                eventFilters.add((EventFilter)portletFilter);
                this._eventFiltersMap.put(this._portletId, eventFilters);
            }
            if (lifecycles.contains("RENDER_PHASE")) {
                List<RenderFilter> renderFilters = this._renderFiltersMap.get(this._portletId);
                if (renderFilters == null) {
                    renderFilters = new ArrayList<RenderFilter>();
                }
                renderFilters.add((RenderFilter)portletFilter);
                this._renderFiltersMap.put(this._portletId, renderFilters);
            }
            if (!lifecycles.contains("RESOURCE_PHASE")) continue;
            List<ResourceFilter> resourceFilters = this._resourceFiltersMap.get(this._portletId);
            if (resourceFilters == null) {
                resourceFilters = new ArrayList<ResourceFilter>();
            }
            resourceFilters.add((ResourceFilter)portletFilter);
            this._resourceFiltersMap.put(this._portletId, resourceFilters);
        }
    }

    protected void invoke(LiferayPortletRequest portletRequest, LiferayPortletResponse portletResponse, String lifecycle, List<? extends PortletFilter> filters) throws IOException, PortletException {
        String[] expCache;
        FilterChainImpl filterChain = new FilterChainImpl(this._portlet, filters);
        if (this._portletConfigImpl.isWARFile()) {
            String invokerPortletName = this._portletConfigImpl.getInitParameter("com.liferay.portal.invokerPortletName");
            if (invokerPortletName == null) {
                invokerPortletName = this._portletConfigImpl.getPortletName();
            }
            String path = "/" + invokerPortletName + "/invoke";
            RequestDispatcher requestDispatcher = this._portletContextImpl.getServletContext().getRequestDispatcher(path);
            HttpServletRequest request = portletRequest.getHttpServletRequest();
            HttpServletResponse response = portletResponse.getHttpServletResponse();
            request.setAttribute("javax.portlet.portlet", (Object)this._portlet);
            request.setAttribute("javax.portlet.lifecycle_phase", (Object)lifecycle);
            request.setAttribute("com.liferay.portal.kernel.servlet.PortletServletFilterChain", (Object)filterChain);
            try {
                if (lifecycle.equals("RESOURCE_PHASE")) {
                    requestDispatcher.forward((ServletRequest)request, (ServletResponse)response);
                }
                requestDispatcher.include((ServletRequest)request, (ServletResponse)response);
            }
            catch (ServletException se) {
                Throwable cause = se.getRootCause();
                if (cause instanceof PortletException) {
                    throw (PortletException)cause;
                }
                throw new PortletException(cause);
            }
        } else {
            PortletFilterUtil.doFilter((PortletRequest)portletRequest, (PortletResponse)portletResponse, (String)lifecycle, (FilterChain)filterChain);
        }
        portletResponse.transferMarkupHeadElements();
        Map properties = portletResponse.getProperties();
        if (properties != null && properties.size() > 0 && this._expCache != null && (expCache = (String[])properties.get("portlet.expiration-cache")) != null && expCache.length > 0 && expCache[0] != null) {
            this._expCache = new Integer(GetterUtil.getInteger((String)expCache[0]));
        }
    }

    protected void invokeAction(ActionRequest actionRequest, ActionResponse actionResponse) throws IOException, PortletException {
        LiferayPortletRequest portletRequest = (LiferayPortletRequest)actionRequest;
        LiferayPortletResponse portletResponse = (LiferayPortletResponse)actionResponse;
        String portletId = this._getPortletId(portletResponse);
        List<ActionFilter> actionFilters = this._actionFiltersMap.get(portletId);
        this.invoke(portletRequest, portletResponse, "ACTION_PHASE", actionFilters);
    }

    protected void invokeEvent(EventRequest eventRequest, EventResponse eventResponse) throws IOException, PortletException {
        LiferayPortletRequest portletRequest = (LiferayPortletRequest)eventRequest;
        LiferayPortletResponse portletResponse = (LiferayPortletResponse)eventResponse;
        String portletId = this._getPortletId(portletResponse);
        List<EventFilter> eventFilters = this._eventFiltersMap.get(portletId);
        this.invoke(portletRequest, portletResponse, "EVENT_PHASE", eventFilters);
    }

    protected String invokeRender(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        LiferayPortletRequest portletRequest = (LiferayPortletRequest)renderRequest;
        LiferayPortletResponse portletResponse = (LiferayPortletResponse)renderResponse;
        String portletId = this._getPortletId(portletResponse);
        List<RenderFilter> renderFilters = this._renderFiltersMap.get(portletId);
        this.invoke(portletRequest, portletResponse, "RENDER_PHASE", renderFilters);
        RenderResponseImpl renderResponseImpl = (RenderResponseImpl)renderResponse;
        return renderResponseImpl.getTitle();
    }

    protected void invokeResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws IOException, PortletException {
        LiferayPortletRequest portletRequest = (LiferayPortletRequest)resourceRequest;
        LiferayPortletResponse portletResponse = (LiferayPortletResponse)resourceResponse;
        String portletId = this._getPortletId(portletResponse);
        List<ResourceFilter> resourceFilters = this._resourceFiltersMap.get(portletId);
        this.invoke(portletRequest, portletResponse, "RESOURCE_PHASE", resourceFilters);
    }

    protected void removePortletFilters() {
        this._actionFiltersMap.remove(this._portletId);
        this._eventFiltersMap.remove(this._portletId);
        this._renderFiltersMap.remove(this._portletId);
        this._resourceFiltersMap.remove(this._portletId);
    }

    private String _getPortletId(LiferayPortletResponse portletResponse) {
        PortletResponseImpl portletResponseImpl = (PortletResponseImpl)portletResponse;
        com.liferay.portal.model.Portlet portlet = portletResponseImpl.getPortlet();
        return portlet.getPortletId();
    }
}

