/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v5_2_0;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.util.TempUpgradeColumnImpl;
import com.liferay.portal.kernel.upgrade.util.UpgradeColumn;
import com.liferay.portal.kernel.upgrade.util.UpgradeTable;
import com.liferay.portal.kernel.upgrade.util.UpgradeTableFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.model.ResourceConstants;
import com.liferay.portal.upgrade.v5_2_0.util.OrganizationTable;
import com.liferay.portal.upgrade.v5_2_0.util.OrganizationTypeUpgradeColumnImpl;
import com.liferay.portal.util.PortalInstances;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class UpgradeOrganization
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        TempUpgradeColumnImpl locationColumn = new TempUpgradeColumnImpl("location", new Integer(16));
        OrganizationTypeUpgradeColumnImpl typeColumn = new OrganizationTypeUpgradeColumnImpl((UpgradeColumn)locationColumn);
        Object[][] organizationColumns1 = new Object[][]{{"location", new Integer(16)}};
        Object[][] organizationColumns2 = (Object[][])OrganizationTable.TABLE_COLUMNS.clone();
        Object[][] organizationColumns = ArrayUtil.append((Object[][])organizationColumns1, (Object[][])organizationColumns2);
        UpgradeTable upgradeTable = UpgradeTableFactoryUtil.getUpgradeTable((String)"Organization_", (Object[][])organizationColumns, (UpgradeColumn[])new UpgradeColumn[]{locationColumn, typeColumn});
        upgradeTable.updateTable();
        this.updateLocationResources();
    }

    protected long getCodeId(long companyId, String name, int scope) throws Exception {
        long codeId = 0L;
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement("select codeId from ResourceCode where companyId = ? and name = ? and scope = ?");
            ps.setLong(1, companyId);
            ps.setString(2, name);
            ps.setInt(3, scope);
            rs = ps.executeQuery();
            if (rs.next()) {
                codeId = rs.getLong("codeId");
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return codeId;
    }

    protected void updateCodeId(long companyId, int scope) throws Exception {
        long oldCodeId = this.getCodeId(companyId, "com.liferay.portal.model.Location", scope);
        long newCodeId = this.getCodeId(companyId, "com.liferay.portal.model.Organization", scope);
        this.runSQL("update Resource_ set codeId = " + newCodeId + " where codeId = " + oldCodeId);
        this.runSQL("delete from ResourceCode where codeId = " + oldCodeId);
    }

    protected void updateLocationResources() throws Exception {
        long[] companyIds;
        long[] lArray = companyIds = PortalInstances.getCompanyIdsBySQL();
        int n = companyIds.length;
        int n2 = 0;
        while (n2 < n) {
            long companyId = lArray[n2];
            int[] nArray = ResourceConstants.SCOPES;
            int n3 = ResourceConstants.SCOPES.length;
            int n4 = 0;
            while (n4 < n3) {
                int scope = nArray[n4];
                this.updateCodeId(companyId, scope);
                ++n4;
            }
            ++n2;
        }
    }
}

