/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.samplesqlbuilder;

import com.liferay.portal.freemarker.FreeMarkerUtil;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBFactoryUtil;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil_IW;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Contact;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.Resource;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.tools.samplesqlbuilder.DataFactory;
import com.liferay.portal.util.InitUtil;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.blogs.model.BlogsStatsUser;
import com.liferay.portlet.messageboards.model.MBCategory;
import com.liferay.portlet.messageboards.model.MBDiscussion;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.model.MBStatsUser;
import com.liferay.portlet.messageboards.model.MBThread;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.util.SimpleCounter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SampleSQLBuilder {
    private static final String _TPL_ROOT = "com/liferay/portal/tools/samplesqlbuilder/dependencies/";
    private SimpleCounter _counter;
    private DataFactory _dataFactory;
    private String _dbType;
    private int _maxBlogsEntryCommentCount;
    private int _maxBlogsEntryCount;
    private int _maxGroupCount;
    private int _maxMBCategoryCount;
    private int _maxMBMessageCount;
    private int _maxMBThreadCount;
    private int _maxUserCount;
    private int _maxUserToGroupCount;
    private int _maxWikiNodeCount;
    private int _maxWikiPageCommentCount;
    private int _maxWikiPageCount;
    private String _outputDir;
    private SimpleCounter _permissionCounter;
    private SimpleCounter _resourceCodeCounter;
    private SimpleCounter _resourceCounter;
    private boolean _securityEnabled;
    private String _tplAssetEntry = "com/liferay/portal/tools/samplesqlbuilder/dependencies/asset_entry.ftl";
    private String _tplGroup = "com/liferay/portal/tools/samplesqlbuilder/dependencies/group.ftl";
    private String _tplBlogsEntry = "com/liferay/portal/tools/samplesqlbuilder/dependencies/blogs_entry.ftl";
    private String _tplBlogsStatsUser = "com/liferay/portal/tools/samplesqlbuilder/dependencies/blogs_stats_user.ftl";
    private String _tplMBCategory = "com/liferay/portal/tools/samplesqlbuilder/dependencies/mb_category.ftl";
    private String _tplMBDiscussion = "com/liferay/portal/tools/samplesqlbuilder/dependencies/mb_discussion.ftl";
    private String _tplMBMessage = "com/liferay/portal/tools/samplesqlbuilder/dependencies/mb_message.ftl";
    private String _tplMBStatsUser = "com/liferay/portal/tools/samplesqlbuilder/dependencies/mb_stats_user.ftl";
    private String _tplMBThread = "com/liferay/portal/tools/samplesqlbuilder/dependencies/mb_thread.ftl";
    private String _tplSample = "com/liferay/portal/tools/samplesqlbuilder/dependencies/sample.ftl";
    private String _tplSecurity = "com/liferay/portal/tools/samplesqlbuilder/dependencies/security.ftl";
    private String _tplUser = "com/liferay/portal/tools/samplesqlbuilder/dependencies/user.ftl";
    private String _tplWikiNode = "com/liferay/portal/tools/samplesqlbuilder/dependencies/wiki_node.ftl";
    private String _tplWikiPage = "com/liferay/portal/tools/samplesqlbuilder/dependencies/wiki_page.ftl";
    private SimpleCounter _userScreenNameIncrementer;
    private Writer _writerGeneric;
    private Writer _writerSpecific;

    public static void main(String[] args) {
        InitUtil.initWithSpring();
        String outputDir = System.getProperty("sample.sql.output.dir");
        String dbType = System.getProperty("sample.sql.db.type");
        int maxBlogsEntryCommentCount = GetterUtil.getInteger((String)System.getProperty("sample.sql.blogs.entry.comment.count"));
        int maxBlogsEntryCount = GetterUtil.getInteger((String)System.getProperty("sample.sql.blogs.entry.count"));
        int maxGroupCount = GetterUtil.getInteger((String)System.getProperty("sample.sql.group.count"));
        int maxMBCategoryCount = GetterUtil.getInteger((String)System.getProperty("sample.sql.mb.category.count"));
        int maxMBMessageCount = GetterUtil.getInteger((String)System.getProperty("sample.sql.mb.message.count"));
        int maxMBThreadCount = GetterUtil.getInteger((String)System.getProperty("sample.sql.mb.thread.count"));
        int maxUserCount = GetterUtil.getInteger((String)System.getProperty("sample.sql.user.count"));
        int maxUserToGroupCount = GetterUtil.getInteger((String)System.getProperty("sample.sql.user.to.group.count"));
        int maxWikiNodeCount = GetterUtil.getInteger((String)System.getProperty("sample.sql.wiki.node.count"));
        int maxWikiPageCommentCount = GetterUtil.getInteger((String)System.getProperty("sample.sql.wiki.page.comment.count"));
        int maxWikiPageCount = GetterUtil.getInteger((String)System.getProperty("sample.sql.wiki.page.count"));
        boolean securityEnabled = GetterUtil.getBoolean((String)System.getProperty("sample.sql.security.enabled"));
        new SampleSQLBuilder(outputDir, dbType, maxBlogsEntryCommentCount, maxBlogsEntryCount, maxGroupCount, maxMBCategoryCount, maxMBMessageCount, maxMBThreadCount, maxUserCount, maxUserToGroupCount, maxWikiNodeCount, maxWikiPageCommentCount, maxWikiPageCount, securityEnabled);
    }

    public SampleSQLBuilder(String outputDir, String dbType, int maxBlogsEntryCommentCount, int maxBlogsEntryCount, int maxGroupCount, int maxMBCategoryCount, int maxMBMessageCount, int maxMBThreadCount, int maxUserCount, int maxUserToGroupCount, int maxWikiNodeCount, int maxWikiPageCommentCount, int maxWikiPageCount, boolean securityEnabled) {
        try {
            this._outputDir = outputDir;
            this._dbType = dbType;
            this._maxBlogsEntryCommentCount = maxBlogsEntryCommentCount;
            this._maxBlogsEntryCount = maxBlogsEntryCount;
            this._maxGroupCount = maxGroupCount;
            this._maxMBCategoryCount = maxMBCategoryCount;
            this._maxMBMessageCount = maxMBMessageCount;
            this._maxMBThreadCount = maxMBThreadCount;
            this._maxUserCount = maxUserCount;
            this._maxUserToGroupCount = maxUserToGroupCount;
            this._maxWikiNodeCount = maxWikiNodeCount;
            this._maxWikiPageCommentCount = maxWikiPageCommentCount;
            this._maxWikiPageCount = maxWikiPageCount;
            this._securityEnabled = securityEnabled;
            int totalMThreadCount = maxMBCategoryCount * maxMBThreadCount;
            int totalMBMessageCount = totalMThreadCount * maxMBMessageCount;
            int counterOffset = this._maxGroupCount + this._maxGroupCount * (maxMBCategoryCount + totalMThreadCount + totalMBMessageCount) + 1;
            this._counter = new SimpleCounter((long)counterOffset);
            this._permissionCounter = new SimpleCounter();
            this._resourceCounter = new SimpleCounter();
            this._resourceCodeCounter = new SimpleCounter();
            this._userScreenNameIncrementer = new SimpleCounter();
            this._dataFactory = new DataFactory(this._maxGroupCount, this._maxUserToGroupCount, this._counter, this._permissionCounter, this._resourceCounter, this._resourceCodeCounter);
            this._writerGeneric = new FileWriter(String.valueOf(this._outputDir) + "/sample.sql");
            this.createSample();
            this._writerGeneric.flush();
            this._writerSpecific = new FileWriter(String.valueOf(this._outputDir) + "/sample-" + dbType + ".sql");
            DB specificDB = DBFactoryUtil.getDB((String)this._dbType);
            boolean previousBlankLine = false;
            UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new FileReader(String.valueOf(this._outputDir) + "/sample.sql"));
            String s = null;
            while ((s = unsyncBufferedReader.readLine()) != null) {
                s = specificDB.buildSQL(s).trim();
                this._writerSpecific.write(s);
                if (!previousBlankLine || !Validator.isNull((String)s)) {
                    this._writerSpecific.write("\n");
                }
                if (!Validator.isNull((String)s)) continue;
                previousBlankLine = true;
            }
            unsyncBufferedReader.close();
            this._writerSpecific.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void insertAssetEntry(AssetEntry assetEntry) throws Exception {
        Map<String, Object> context = this.getContext();
        this.put(context, "assetEntry", assetEntry);
        this.processTemplate(this._tplAssetEntry, context);
    }

    public void insertBlogsEntry(BlogsEntry blogsEntry) throws Exception {
        Map<String, Object> context = this.getContext();
        this.put(context, "blogsEntry", blogsEntry);
        this.processTemplate(this._tplBlogsEntry, context);
    }

    public void insertBlogsStatsUser(BlogsStatsUser blogsStatsUser) throws Exception {
        Map<String, Object> context = this.getContext();
        this.put(context, "blogsStatsUser", blogsStatsUser);
        this.processTemplate(this._tplBlogsStatsUser, context);
    }

    public void insertGroup(Group group, List<Layout> privateLayouts, List<Layout> publicLayouts) throws Exception {
        Map<String, Object> context = this.getContext();
        this.put(context, "group", group);
        this.put(context, "privateLayouts", privateLayouts);
        this.put(context, "publicLayouts", publicLayouts);
        this.processTemplate(this._tplGroup, context);
    }

    public void insertMBCategory(MBCategory mbCategory) throws Exception {
        Map<String, Object> context = this.getContext();
        this.put(context, "mbCategory", mbCategory);
        this.processTemplate(this._tplMBCategory, context);
    }

    public void insertMBDiscussion(MBDiscussion mbDiscussion) throws Exception {
        Map<String, Object> context = this.getContext();
        this.put(context, "mbDiscussion", mbDiscussion);
        this.processTemplate(this._tplMBDiscussion, context);
    }

    public void insertMBMessage(MBMessage mbMessage) throws Exception {
        Map<String, Object> context = this.getContext();
        this.put(context, "mbMessage", mbMessage);
        this.processTemplate(this._tplMBMessage, context);
    }

    public void insertMBStatsUser(MBStatsUser mbStatsUser) throws Exception {
        Map<String, Object> context = this.getContext();
        this.put(context, "mbStatsUser", mbStatsUser);
        this.processTemplate(this._tplMBStatsUser, context);
    }

    public void insertMBThread(MBThread mbThread) throws Exception {
        Map<String, Object> context = this.getContext();
        this.put(context, "mbThread", mbThread);
        this.processTemplate(this._tplMBThread, context);
    }

    public void insertSecurity(String name, long primKey) throws Exception {
        this.insertSecurity(name, String.valueOf(primKey));
    }

    public void insertSecurity(String name, String primKey) throws Exception {
        if (!this._securityEnabled) {
            return;
        }
        Map<String, Object> context = this.getContext();
        Resource resource = this._dataFactory.addResource(name, primKey);
        this.put(context, "resource", resource);
        this.processTemplate(this._tplSecurity, context);
    }

    public void insertUser(Contact contact, Group group, List<Long> groupIds, List<Long> organizationIds, List<Layout> privateLayouts, List<Layout> publicLayouts, List<Role> roleIds, User user) throws Exception {
        Map<String, Object> context = this.getContext();
        this.put(context, "contact", contact);
        this.put(context, "group", group);
        this.put(context, "groupIds", groupIds);
        this.put(context, "organizationIds", organizationIds);
        this.put(context, "privateLayouts", privateLayouts);
        this.put(context, "publicLayouts", publicLayouts);
        this.put(context, "roleIds", roleIds);
        this.put(context, "user", user);
        this.processTemplate(this._tplUser, context);
    }

    public void insertWikiNode(WikiNode wikiNode) throws Exception {
        Map<String, Object> context = this.getContext();
        this.put(context, "wikiNode", wikiNode);
        this.processTemplate(this._tplWikiNode, context);
    }

    public void insertWikiPage(WikiNode wikiNode, WikiPage wikiPage) throws Exception {
        Map<String, Object> context = this.getContext();
        this.put(context, "wikiNode", wikiNode);
        this.put(context, "wikiPage", wikiPage);
        this.processTemplate(this._tplWikiPage, context);
    }

    protected void createSample() throws Exception {
        Map<String, Object> context = this.getContext();
        Writer blogsEntriesCsvWriter = this.getWriter("blogs_entries.csv");
        Writer mbMessagesCsvWriter = this.getWriter("mb_messages.csv");
        Writer usersCsvWriter = this.getWriter("users.csv");
        Writer wikiPagesCsvWriter = this.getWriter("wiki_pages.csv");
        this.put(context, "blogsEntriesCsvWriter", blogsEntriesCsvWriter);
        this.put(context, "mbMessagesCsvWriter", mbMessagesCsvWriter);
        this.put(context, "usersCsvWriter", usersCsvWriter);
        this.put(context, "wikiPagesCsvWriter", wikiPagesCsvWriter);
        this.processTemplate(this._tplSample, context);
        blogsEntriesCsvWriter.flush();
        mbMessagesCsvWriter.flush();
        usersCsvWriter.flush();
        wikiPagesCsvWriter.flush();
    }

    protected Map<String, Object> getContext() {
        HashMap<String, Object> context = new HashMap<String, Object>();
        Company company = this._dataFactory.getCompany();
        User defaultUser = this._dataFactory.getDefaultUser();
        this.put(context, "companyId", company.getCompanyId());
        this.put(context, "counter", this._counter);
        this.put(context, "dataFactory", this._dataFactory);
        this.put(context, "defaultUserId", defaultUser.getCompanyId());
        this.put(context, "maxBlogsEntryCommentCount", this._maxBlogsEntryCommentCount);
        this.put(context, "maxBlogsEntryCount", this._maxBlogsEntryCount);
        this.put(context, "maxGroupCount", this._maxGroupCount);
        this.put(context, "maxMBCategoryCount", this._maxMBCategoryCount);
        this.put(context, "maxMBMessageCount", this._maxMBMessageCount);
        this.put(context, "maxMBThreadCount", this._maxMBThreadCount);
        this.put(context, "maxUserCount", this._maxUserCount);
        this.put(context, "maxUserToGroupCount", this._maxUserToGroupCount);
        this.put(context, "maxWikiNodeCount", this._maxWikiNodeCount);
        this.put(context, "maxWikiPageCommentCount", this._maxWikiPageCommentCount);
        this.put(context, "maxWikiPageCount", this._maxWikiPageCount);
        this.put(context, "portalUUIDUtil", PortalUUIDUtil.getPortalUUID());
        this.put(context, "sampleSQLBuilder", this);
        this.put(context, "stringUtil", StringUtil_IW.getInstance());
        this.put(context, "userScreenNameIncrementer", this._userScreenNameIncrementer);
        return context;
    }

    protected Writer getWriter(String fileName) throws Exception {
        return new FileWriter(new File(String.valueOf(this._outputDir) + "/" + fileName));
    }

    protected void processTemplate(String name, Map<String, Object> context) throws Exception {
        FreeMarkerUtil.process(name, context, this._writerGeneric);
    }

    protected void put(Map<String, Object> context, String key, Object value) {
        context.put(key, value);
    }
}

