/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.tools.WSDDMerger;
import com.liferay.portal.util.InitUtil;
import com.liferay.util.ant.Java2WsddTask;
import java.io.File;
import java.util.List;

public class WSDDBuilder {
    private String _serverConfigFileName;
    private boolean _portalWsdd = true;
    private String _portletShortName;
    private String _outputPath;
    private String _packagePath;

    public static void main(String[] args) {
        InitUtil.initWithSpring();
        if (args.length != 2) {
            throw new IllegalArgumentException();
        }
        new WSDDBuilder(args[0], args[1]);
    }

    public WSDDBuilder(String fileName, String serverConfigFileName) {
        try {
            this._serverConfigFileName = serverConfigFileName;
            if (!FileUtil.exists((String)this._serverConfigFileName)) {
                ClassLoader classLoader = this.getClass().getClassLoader();
                String serverConfigContent = StringUtil.read((ClassLoader)classLoader, (String)"com/liferay/portal/tools/dependencies/server-config.wsdd");
                FileUtil.write((String)this._serverConfigFileName, (String)serverConfigContent);
            }
            if (FileUtil.exists((String)"docroot/WEB-INF/src/")) {
                this._portalWsdd = false;
            }
            Document doc = SAXReaderUtil.read((File)new File(fileName), (boolean)true);
            Element root = doc.getRootElement();
            String packagePath = root.attributeValue("package-path");
            Element portlet = root.element("portlet");
            Element namespace = root.element("namespace");
            this._portletShortName = portlet != null ? portlet.attributeValue("short-name") : namespace.getText();
            this._outputPath = this._portalWsdd ? "src/" : "docroot/WEB-INF/src/";
            this._outputPath = String.valueOf(this._outputPath) + StringUtil.replace((String)packagePath, (String)".", (String)"/") + "/service/http";
            this._packagePath = packagePath;
            List entities = root.elements("entity");
            for (Element entity : entities) {
                String entityName = entity.attributeValue("name");
                boolean remoteService = GetterUtil.getBoolean((String)entity.attributeValue("remote-service"), (boolean)true);
                if (!remoteService) continue;
                this._createServiceWSDD(entityName);
                WSDDMerger.merge(String.valueOf(this._outputPath) + "/" + entityName + "Service_deploy.wsdd", this._serverConfigFileName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void _createServiceWSDD(String entityName) throws Exception {
        String className = String.valueOf(this._packagePath) + ".service.http." + entityName + "ServiceSoap";
        String serviceName = StringUtil.replace((String)this._portletShortName, (String)" ", (String)"_");
        if (!this._portalWsdd) {
            serviceName = "Plugin_" + serviceName;
        } else if (!this._portletShortName.equals("Portal")) {
            serviceName = "Portlet_" + serviceName;
        }
        serviceName = String.valueOf(serviceName) + "_" + entityName + "Service";
        String[] wsdds = Java2WsddTask.generateWsdd((String)className, (String)serviceName);
        FileUtil.write((File)new File(String.valueOf(this._outputPath) + "/" + entityName + "Service_deploy.wsdd"), (String)wsdds[0], (boolean)true);
        FileUtil.write((File)new File(String.valueOf(this._outputPath) + "/" + entityName + "Service_undeploy.wsdd"), (String)wsdds[1], (boolean)true);
    }
}

