/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.servlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.PrincipalThreadLocal;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.spring.context.TunnelApplicationContext;
import com.liferay.portal.util.PortalInstances;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.DispatcherServlet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemotingServlet
extends DispatcherServlet {
    public static final String CONTEXT_CLASS = TunnelApplicationContext.class.getName();
    public static final String CONTEXT_CONFIG_LOCATION = "/WEB-INF/remoting-servlet.xml,/WEB-INF/remoting-servlet-ext.xml";
    private static Log _log = LogFactoryUtil.getLog(RemotingServlet.class);

    public Class<?> getContextClass() {
        try {
            return Class.forName(CONTEXT_CLASS);
        }
        catch (Exception e) {
            _log.error((Throwable)e);
            return null;
        }
    }

    public String getContextConfigLocation() {
        return CONTEXT_CONFIG_LOCATION;
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        try {
            PortalInstances.getCompanyId(request);
            String remoteUser = request.getRemoteUser();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Remote user " + remoteUser));
            }
            if (remoteUser != null) {
                PrincipalThreadLocal.setName((String)remoteUser);
                long userId = GetterUtil.getLong((String)remoteUser);
                User user = UserLocalServiceUtil.getUserById((long)userId);
                PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)user, (boolean)true);
                PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
            } else if (_log.isWarnEnabled()) {
                _log.warn((Object)"User id is not provided. An exception will be thrown  if a protected method is accessed.");
            }
            super.service(request, response);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }
}

