/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.portal.kernel.cache.MultiVMPool;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.servlet.ImageServletToken;
import com.liferay.portal.servlet.filters.cache.CacheUtil;
import com.liferay.portlet.journalcontent.util.JournalContentUtil;
import java.io.Serializable;

public class ImageServletTokenImpl
implements ImageServletToken {
    public static final String CACHE_NAME = ImageServletToken.class.getName();
    private MultiVMPool _multiVMPool;
    private PortalCache _portalCache;

    public void afterPropertiesSet() {
        this._portalCache = this._multiVMPool.getCache(CACHE_NAME);
    }

    public String getToken(long imageId) {
        String key = this._encodeKey(imageId);
        String token = (String)this._portalCache.get(key);
        if (token == null) {
            token = this._createToken(imageId);
            this._portalCache.put(key, (Serializable)((Object)token));
        }
        return token;
    }

    public void resetToken(long imageId) {
        String key = this._encodeKey(imageId);
        this._portalCache.remove(key);
        JournalContentUtil.clearCache();
        CacheUtil.clearCache();
    }

    public void setMultiVMPool(MultiVMPool multiVMPool) {
        this._multiVMPool = multiVMPool;
    }

    private String _createToken(long imageId) {
        return String.valueOf(System.currentTimeMillis());
    }

    private String _encodeKey(long imageId) {
        return CACHE_NAME.concat("#").concat(String.valueOf(imageId));
    }
}

