/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.portal.kernel.servlet.ServletContextUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.MinifierUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.util.servlet.ServletResponseUtil;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ComboServlet
extends HttpServlet {
    private static final String _CSS_EXTENSION = "css";
    private static final String _CSS_MINIFIED_SUFFIX = "-min.css";
    private static final FileContentBag _EMPTY_FILE_CONTENT_BAG = new FileContentBag(new byte[0], 0L);
    private static final String _JAVASCRIPT_DIR = "html/js";
    private static final String _JAVASCRIPT_MINIFIED_SUFFIX = "-min.js";
    private ConcurrentMap<String, FileContentBag> _fileContents = new ConcurrentHashMap<String, FileContentBag>();

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String contextPath = PortalUtil.getPathContext();
        String[] modulePaths = request.getParameterValues("m");
        if (modulePaths == null || modulePaths.length == 0) {
            response.sendError(400);
            return;
        }
        String p = ParamUtil.getString((HttpServletRequest)request, (String)"p");
        String minifierType = ParamUtil.getString((HttpServletRequest)request, (String)"minifierType");
        int length = modulePaths.length;
        byte[][] bytesArray = new byte[length][];
        String[] stringArray = modulePaths;
        int n = modulePaths.length;
        int n2 = 0;
        while (n2 < n) {
            String modulePath = stringArray[n2];
            byte[] bytes = new byte[]{};
            if (Validator.isNotNull((String)modulePath)) {
                modulePath = StringUtil.replaceFirst((String)p.concat(modulePath), (String)contextPath, (String)"");
                bytes = this.getFileContent(modulePath, minifierType);
            }
            bytesArray[--length] = bytes;
            ++n2;
        }
        String contentType = "text/javascript";
        String firstModulePath = (String)request.getParameterNames().nextElement();
        String extension = FileUtil.getExtension((String)firstModulePath);
        if (extension.equalsIgnoreCase(_CSS_EXTENSION)) {
            contentType = "text/css";
        }
        response.setContentType(contentType);
        ServletResponseUtil.write((HttpServletResponse)response, (byte[][])bytesArray);
    }

    protected File getFile(String path) throws IOException {
        ServletContext servletContext = this.getServletContext();
        String basePath = ServletContextUtil.getRealPath((ServletContext)servletContext, (String)_JAVASCRIPT_DIR);
        if (basePath == null) {
            return null;
        }
        File baseDir = new File(basePath = StringUtil.replace((String)basePath, (String)"\\", (String)"/"));
        if (!baseDir.exists()) {
            return null;
        }
        String filePath = ServletContextUtil.getRealPath((ServletContext)servletContext, (String)path);
        if (filePath == null) {
            return null;
        }
        File file = new File(filePath = StringUtil.replace((String)filePath, (String)"\\", (String)"/"));
        if (!file.exists()) {
            return null;
        }
        String baseCanonicalPath = baseDir.getCanonicalPath();
        String fileCanonicalPath = file.getCanonicalPath();
        if (fileCanonicalPath.indexOf(baseCanonicalPath) == 0) {
            return file;
        }
        return null;
    }

    protected byte[] getFileContent(String path, String minifierType) throws IOException {
        String fileContentKey = path.concat("?").concat(minifierType);
        FileContentBag fileContentBag = (FileContentBag)this._fileContents.get(fileContentKey);
        if (fileContentBag != null && !PropsValues.COMBO_CHECK_TIMESTAMP) {
            return fileContentBag._fileContent;
        }
        File file = this.getFile(path);
        if (fileContentBag != null && PropsValues.COMBO_CHECK_TIMESTAMP) {
            if (file != null && file.lastModified() == fileContentBag._lastModified) {
                return fileContentBag._fileContent;
            }
            this._fileContents.remove(fileContentKey, fileContentBag);
        }
        if (file == null) {
            fileContentBag = _EMPTY_FILE_CONTENT_BAG;
        } else {
            String stringFileContent = FileUtil.read((File)file);
            if (!StringUtil.endsWith((String)path, (String)_CSS_MINIFIED_SUFFIX) && !StringUtil.endsWith((String)path, (String)_JAVASCRIPT_MINIFIED_SUFFIX)) {
                if (minifierType.equals(_CSS_EXTENSION)) {
                    stringFileContent = MinifierUtil.minifyCss(stringFileContent);
                } else if (minifierType.equals("js")) {
                    stringFileContent = MinifierUtil.minifyJavaScript(stringFileContent);
                }
            }
            fileContentBag = new FileContentBag(stringFileContent.getBytes("UTF-8"), file.lastModified());
        }
        FileContentBag oldFileContentBag = this._fileContents.putIfAbsent(fileContentKey, fileContentBag);
        if (oldFileContentBag != null) {
            fileContentBag = oldFileContentBag;
        }
        return fileContentBag._fileContent;
    }

    private static class FileContentBag {
        private byte[] _fileContent;
        private long _lastModified;

        public FileContentBag(byte[] fileContent, long lastModifiedTime) {
            this._fileContent = fileContent;
            this._lastModified = lastModifiedTime;
        }
    }
}

