/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.portal.kernel.servlet.BrowserSniffer;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;

public class BrowserSnifferImpl
implements BrowserSniffer {
    private static Pattern _firefoxPattern = Pattern.compile("(firefox|minefield|granparadiso|bonecho|firebird|phoenix|camino)");
    private static Pattern _majorVersionPattern = Pattern.compile("(\\d+[.]\\d+)");
    private static Pattern _revisionPattern = Pattern.compile("(?:rv|it|ra|ie)[\\/: ]([\\d.]+)");
    private static Pattern _versionChromePattern = Pattern.compile("(?:chrome)[\\/]([\\d.]+)");
    private static Pattern _versionFirefoxPattern = Pattern.compile("(?:firefox|minefield)[\\/]([\\d.]+)");
    private static Pattern _versionPattern = Pattern.compile("(?:version)[\\/]([\\d.]+)");
    private static Pattern _webKitPattern = Pattern.compile("(khtml|applewebkit)");
    private static Pattern _windowsPattern = Pattern.compile("(windows|win32|16bit)");

    public boolean acceptsGzip(HttpServletRequest request) {
        String acceptEncoding = request.getHeader("Accept-Encoding");
        return acceptEncoding != null && acceptEncoding.indexOf("gzip") != -1;
    }

    public String getBrowserId(HttpServletRequest request) {
        if (this.isIe(request)) {
            return "ie";
        }
        if (this.isFirefox(request)) {
            return "firefox";
        }
        return "other";
    }

    public float getMajorVersion(HttpServletRequest request) {
        float majorVersion = 0.0f;
        String version = this.getVersion(request);
        Matcher matcher = _majorVersionPattern.matcher(version);
        if (matcher.find()) {
            majorVersion = GetterUtil.getFloat((String)matcher.group(1));
        }
        return majorVersion;
    }

    public String getRevision(HttpServletRequest request) {
        String revision = "";
        String userAgent = this.getUserAgent(request);
        Matcher matcher = _revisionPattern.matcher(userAgent);
        if (matcher.find()) {
            revision = matcher.group(1);
        }
        return revision;
    }

    public String getVersion(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        String version = "";
        Matcher matcher = _versionPattern.matcher(userAgent);
        if (matcher.find()) {
            version = matcher.group(1);
        } else if (this.isFirefox(request)) {
            Matcher versionFirefoxMatcher = _versionFirefoxPattern.matcher(userAgent);
            if (versionFirefoxMatcher.find()) {
                version = versionFirefoxMatcher.group(1);
            }
        } else if (this.isChrome(request)) {
            Matcher versionChromeMatcher = _versionChromePattern.matcher(userAgent);
            if (versionChromeMatcher.find()) {
                version = versionChromeMatcher.group(1);
            }
        } else {
            version = this.getRevision(request);
        }
        return version;
    }

    public boolean isAir(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        return userAgent.indexOf("adobeair") != -1;
    }

    public boolean isChrome(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        return userAgent.indexOf("chrome") != -1;
    }

    public boolean isFirefox(HttpServletRequest request) {
        if (!this.isMozilla(request)) {
            return false;
        }
        String userAgent = this.getUserAgent(request);
        Matcher matcher = _firefoxPattern.matcher(userAgent);
        return matcher.find();
    }

    public boolean isGecko(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        return userAgent.indexOf("gecko") != -1;
    }

    public boolean isIe(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        return userAgent.indexOf("msie") != -1 && userAgent.indexOf("opera") == -1;
    }

    public boolean isIphone(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        return userAgent.indexOf("iphone") != -1;
    }

    public boolean isLinux(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        return userAgent.indexOf("linux") != -1;
    }

    public boolean isMac(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        return userAgent.indexOf("mac") != -1;
    }

    public boolean isMobile(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        return userAgent.indexOf("mobile") != -1;
    }

    public boolean isMozilla(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        return userAgent.indexOf("mozilla") != -1 && !userAgent.matches("compatible|webkit");
    }

    public boolean isOpera(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        return userAgent.indexOf("opera") != -1;
    }

    public boolean isRtf(HttpServletRequest request) {
        float majorVersion = this.getMajorVersion(request);
        if (this.isIe(request) && (double)majorVersion >= 5.5) {
            return true;
        }
        if (this.isMozilla(request) && (double)majorVersion >= 1.3) {
            return true;
        }
        return this.isSafari(request) && (double)majorVersion >= 3.0 && !this.isMobile(request);
    }

    public boolean isSafari(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        return this.isWebKit(request) && userAgent.indexOf("safari") != -1;
    }

    public boolean isSun(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        return userAgent.indexOf("sunos") != -1;
    }

    public boolean isWap(HttpServletRequest request) {
        return this.isWapXhtml(request);
    }

    public boolean isWapXhtml(HttpServletRequest request) {
        String accept = this.getAccept(request);
        return accept.indexOf("wap.xhtml") != -1;
    }

    public boolean isWebKit(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        Matcher matcher = _webKitPattern.matcher(userAgent);
        return matcher.find();
    }

    public boolean isWindows(HttpServletRequest request) {
        String userAgent = this.getUserAgent(request);
        Matcher matcher = _windowsPattern.matcher(userAgent);
        return matcher.find();
    }

    public boolean isWml(HttpServletRequest request) {
        String accept = this.getAccept(request);
        return accept.indexOf("wap.wml") != -1;
    }

    protected String getAccept(HttpServletRequest request) {
        String acceptHeader;
        String accept = "";
        if (request != null && (acceptHeader = request.getHeader("ACCEPT")) != null) {
            accept = acceptHeader.toLowerCase();
        }
        return accept;
    }

    protected String getUserAgent(HttpServletRequest request) {
        String userAgentHeader;
        String userAgent = "";
        if (request != null && (userAgentHeader = request.getHeader("User-Agent")) != null) {
            userAgent = userAgentHeader.toLowerCase();
        }
        return userAgent;
    }
}

