/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.NoSuchWorkflowDefinitionLinkException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.workflow.WorkflowEngineManagerUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.User;
import com.liferay.portal.model.WorkflowDefinitionLink;
import com.liferay.portal.service.base.WorkflowDefinitionLinkLocalServiceBaseImpl;
import com.liferay.portal.util.PortalUtil;
import java.util.Date;

public class WorkflowDefinitionLinkLocalServiceImpl
extends WorkflowDefinitionLinkLocalServiceBaseImpl {
    public WorkflowDefinitionLink addWorkflowDefinitionLink(long userId, long companyId, long groupId, String className, String workflowDefinitionName, int workflowDefinitionVersion) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long classNameId = PortalUtil.getClassNameId((String)className);
        Date now = new Date();
        long workflowDefinitionLinkId = this.counterLocalService.increment();
        WorkflowDefinitionLink workflowDefinitionLink = this.workflowDefinitionLinkPersistence.create(workflowDefinitionLinkId);
        workflowDefinitionLink.setCreateDate(now);
        workflowDefinitionLink.setModifiedDate(now);
        workflowDefinitionLink.setUserId(userId);
        workflowDefinitionLink.setUserName(user.getFullName());
        workflowDefinitionLink.setGroupId(groupId);
        workflowDefinitionLink.setCompanyId(companyId);
        workflowDefinitionLink.setClassNameId(classNameId);
        workflowDefinitionLink.setWorkflowDefinitionName(workflowDefinitionName);
        workflowDefinitionLink.setWorkflowDefinitionVersion(workflowDefinitionVersion);
        this.workflowDefinitionLinkPersistence.update((BaseModel)workflowDefinitionLink, false);
        return workflowDefinitionLink;
    }

    public void deleteWorkflowDefinitionLink(long companyId, long groupId, String className) throws PortalException, SystemException {
        try {
            WorkflowDefinitionLink workflowDefinitionLink = this.getWorkflowDefinitionLink(companyId, groupId, className, true);
            this.deleteWorkflowDefinitionLink(workflowDefinitionLink);
        }
        catch (NoSuchWorkflowDefinitionLinkException noSuchWorkflowDefinitionLinkException) {}
    }

    public WorkflowDefinitionLink getDefaultWorkflowDefinitionLink(long companyId, String className) throws PortalException, SystemException {
        if (!WorkflowEngineManagerUtil.isDeployed()) {
            throw new NoSuchWorkflowDefinitionLinkException();
        }
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.workflowDefinitionLinkPersistence.findByG_C_C(0L, companyId, classNameId);
    }

    public WorkflowDefinitionLink getWorkflowDefinitionLink(long companyId, long groupId, String className) throws PortalException, SystemException {
        return this.getWorkflowDefinitionLink(companyId, groupId, className, false);
    }

    public WorkflowDefinitionLink getWorkflowDefinitionLink(long companyId, long groupId, String className, boolean strict) throws PortalException, SystemException {
        Group group;
        if (!WorkflowEngineManagerUtil.isDeployed()) {
            throw new NoSuchWorkflowDefinitionLinkException();
        }
        long classNameId = PortalUtil.getClassNameId((String)className);
        WorkflowDefinitionLink workflowDefinitionLink = null;
        if (groupId > 0L && (group = this.groupLocalService.getGroup(groupId)).isLayout()) {
            groupId = group.getParentGroupId();
        }
        workflowDefinitionLink = this.workflowDefinitionLinkPersistence.fetchByG_C_C(groupId, companyId, classNameId);
        if (!strict && workflowDefinitionLink == null) {
            workflowDefinitionLink = this.workflowDefinitionLinkPersistence.fetchByG_C_C(0L, companyId, classNameId);
        }
        if (workflowDefinitionLink == null) {
            throw new NoSuchWorkflowDefinitionLinkException("No workflow for groupId=" + groupId + ", companyId=" + companyId + " and classNameId=" + classNameId);
        }
        return workflowDefinitionLink;
    }

    public int getWorkflowDefinitionLinksCount(long companyId, String workflowDefinitionName, int workflowDefinitionVersion) throws SystemException {
        if (!WorkflowEngineManagerUtil.isDeployed()) {
            return 0;
        }
        return this.workflowDefinitionLinkPersistence.countByC_W_W(companyId, workflowDefinitionName, workflowDefinitionVersion);
    }

    public boolean hasWorkflowDefinitionLink(long companyId, long groupId, String className) throws PortalException, SystemException {
        if (!WorkflowEngineManagerUtil.isDeployed()) {
            return false;
        }
        try {
            this.getWorkflowDefinitionLink(companyId, groupId, className);
            return true;
        }
        catch (NoSuchWorkflowDefinitionLinkException noSuchWorkflowDefinitionLinkException) {
            return false;
        }
    }

    public WorkflowDefinitionLink updateWorkflowDefinitionLink(long userId, long companyId, long groupId, String className, String workflowDefinitionName, int workflowDefinitionVersion) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long classNameId = PortalUtil.getClassNameId((String)className);
        Date now = new Date();
        WorkflowDefinitionLink workflowDefinitionLink = this.workflowDefinitionLinkPersistence.fetchByG_C_C(groupId, companyId, classNameId);
        if (workflowDefinitionLink == null) {
            workflowDefinitionLink = this.addWorkflowDefinitionLink(userId, companyId, groupId, className, workflowDefinitionName, workflowDefinitionVersion);
        }
        workflowDefinitionLink.setModifiedDate(now);
        workflowDefinitionLink.setUserId(userId);
        workflowDefinitionLink.setUserName(user.getFullName());
        workflowDefinitionLink.setGroupId(groupId);
        workflowDefinitionLink.setCompanyId(companyId);
        workflowDefinitionLink.setClassNameId(classNameId);
        workflowDefinitionLink.setWorkflowDefinitionName(workflowDefinitionName);
        workflowDefinitionLink.setWorkflowDefinitionVersion(workflowDefinitionVersion);
        this.workflowDefinitionLinkPersistence.update((BaseModel)workflowDefinitionLink, false);
        return workflowDefinitionLink;
    }
}

