/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Subscription;
import com.liferay.portal.model.User;
import com.liferay.portal.service.base.SubscriptionLocalServiceBaseImpl;
import com.liferay.portal.util.PortalUtil;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubscriptionLocalServiceImpl
extends SubscriptionLocalServiceBaseImpl {
    public Subscription addSubscription(long userId, String className, long classPK) throws PortalException, SystemException {
        return this.addSubscription(userId, className, classPK, "instant");
    }

    public Subscription addSubscription(long userId, String className, long classPK, String frequency) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long classNameId = PortalUtil.getClassNameId((String)className);
        Date now = new Date();
        long subscriptionId = this.counterLocalService.increment();
        Subscription subscription = this.subscriptionPersistence.create(subscriptionId);
        subscription.setCompanyId(user.getCompanyId());
        subscription.setUserId(user.getUserId());
        subscription.setUserName(user.getFullName());
        subscription.setCreateDate(now);
        subscription.setModifiedDate(now);
        subscription.setClassNameId(classNameId);
        subscription.setClassPK(classPK);
        subscription.setFrequency(frequency);
        this.subscriptionPersistence.update((BaseModel)subscription, false);
        return subscription;
    }

    @Override
    public void deleteSubscription(long subscriptionId) throws PortalException, SystemException {
        this.subscriptionPersistence.remove(subscriptionId);
    }

    public void deleteSubscription(long userId, String className, long classPK) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long classNameId = PortalUtil.getClassNameId((String)className);
        this.subscriptionPersistence.removeByC_U_C_C(user.getCompanyId(), userId, classNameId, classPK);
    }

    public void deleteSubscriptions(long userId) throws SystemException {
        this.subscriptionPersistence.removeByUserId(userId);
    }

    public void deleteSubscriptions(long companyId, String className, long classPK) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        this.subscriptionPersistence.removeByC_C_C(companyId, classNameId, classPK);
    }

    public Subscription getSubscription(long companyId, long userId, String className, long classPK) throws PortalException, SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.subscriptionPersistence.findByC_U_C_C(companyId, userId, classNameId, classPK);
    }

    public List<Subscription> getSubscriptions(long companyId, String className, long classPK) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.subscriptionPersistence.findByC_C_C(companyId, classNameId, classPK);
    }

    public List<Subscription> getUserSubscriptions(long userId, String className) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.subscriptionPersistence.findByU_C(userId, classNameId);
    }

    public boolean isSubscribed(long companyId, long userId, String className, long classPK) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        Subscription subscription = this.subscriptionPersistence.fetchByC_U_C_C(companyId, userId, classNameId, classPK);
        return subscription != null;
    }
}

