/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.annotation.Propagation;
import com.liferay.portal.kernel.annotation.Transactional;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.ClassName;
import com.liferay.portal.model.ModelHintsUtil;
import com.liferay.portal.model.impl.ClassNameImpl;
import com.liferay.portal.service.base.ClassNameLocalServiceBaseImpl;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassNameLocalServiceImpl
extends ClassNameLocalServiceBaseImpl {
    private static ClassName _nullClassName = new ClassNameImpl();
    private static Map<String, ClassName> _classNames = new ConcurrentHashMap<String, ClassName>();

    public ClassName addClassName(String value) throws SystemException {
        long classNameId = this.counterLocalService.increment();
        ClassName className = this.classNamePersistence.create(classNameId);
        className.setValue(value);
        this.classNamePersistence.update((BaseModel)className, false);
        return className;
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public void checkClassNames() throws SystemException {
        if (_classNames.isEmpty()) {
            List classNames = this.classNamePersistence.findAll();
            for (ClassName className : classNames) {
                _classNames.put(className.getValue(), className);
            }
        }
        List models = ModelHintsUtil.getModels();
        for (String model : models) {
            this.getClassName(model);
        }
    }

    @Override
    public ClassName getClassName(long classNameId) throws PortalException, SystemException {
        return this.classNamePersistence.findByPrimaryKey(classNameId);
    }

    public ClassName getClassName(String value) throws SystemException {
        if (Validator.isNull((String)value)) {
            return _nullClassName;
        }
        ClassName className = _classNames.get(value);
        if (className == null) {
            className = this.classNamePersistence.fetchByValue(value);
            if (className == null) {
                className = this.classNameLocalService.addClassName(value);
            }
            _classNames.put(value, className);
        }
        return className;
    }

    public long getClassNameId(Class<?> classObj) {
        return this.getClassNameId(classObj.getName());
    }

    public long getClassNameId(String value) {
        try {
            ClassName className = this.getClassName(value);
            return className.getClassNameId();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get class name from value " + value, e);
        }
    }
}

