/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.json;

import com.liferay.portal.json.JSONArrayImpl;
import com.liferay.portal.json.JSONObjectImpl;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import org.jabsorb.JSONSerializer;
import org.jabsorb.serializer.MarshallException;
import org.jabsorb.serializer.UnmarshallException;

public class JSONFactoryImpl
implements JSONFactory {
    private static Log _log = LogFactoryUtil.getLog(JSONFactoryImpl.class);
    private JSONSerializer _serializer = new JSONSerializer();

    public JSONFactoryImpl() {
        try {
            this._serializer.registerDefaultSerializers();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public JSONArray createJSONArray() {
        return new JSONArrayImpl();
    }

    public JSONArray createJSONArray(String json) throws JSONException {
        return new JSONArrayImpl(json);
    }

    public JSONObject createJSONObject() {
        return new JSONObjectImpl();
    }

    public JSONObject createJSONObject(String json) throws JSONException {
        return new JSONObjectImpl(json);
    }

    public Object deserialize(JSONObject jsonObj) {
        return this.deserialize(jsonObj.toString());
    }

    public Object deserialize(String json) {
        try {
            return this._serializer.fromJSON(json);
        }
        catch (UnmarshallException ue) {
            _log.error((Object)ue, (Throwable)ue);
            throw new IllegalStateException("Unable to deserialize oject", ue);
        }
    }

    public String serialize(Object obj) {
        try {
            return this._serializer.toJSON(obj);
        }
        catch (MarshallException me) {
            _log.error((Object)me, (Throwable)me);
            throw new IllegalStateException("Unable to serialize oject", me);
        }
    }
}

