/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.jdbc.aop;

import com.liferay.portal.dao.jdbc.aop.DynamicDataSourceTargetSource;
import com.liferay.portal.dao.jdbc.aop.Operation;
import com.liferay.portal.kernel.util.InfrastructureUtil;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionInterceptor;

public class DynamicDataSourceTransactionInterceptor
extends TransactionInterceptor {
    private DynamicDataSourceTargetSource _dynamicDataSourceTargetSource;

    public void afterPropertiesSet() {
        if (this._dynamicDataSourceTargetSource == null) {
            this._dynamicDataSourceTargetSource = (DynamicDataSourceTargetSource)InfrastructureUtil.getDynamicDataSourceTargetSource();
        }
    }

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        if (this._dynamicDataSourceTargetSource == null) {
            return super.invoke(methodInvocation);
        }
        Class<?> targetClass = null;
        if (methodInvocation.getThis() != null) {
            targetClass = methodInvocation.getThis().getClass();
        }
        Method targetMethod = methodInvocation.getMethod();
        TransactionAttributeSource transactionAttributeSource = this.getTransactionAttributeSource();
        TransactionAttribute transactionAttribute = transactionAttributeSource.getTransactionAttribute(targetMethod, targetClass);
        if (transactionAttribute != null && transactionAttribute.isReadOnly()) {
            this._dynamicDataSourceTargetSource.setOperation(Operation.READ);
        } else {
            this._dynamicDataSourceTargetSource.setOperation(Operation.WRITE);
        }
        this._dynamicDataSourceTargetSource.pushMethod(targetClass.getName().concat(".").concat(targetMethod.getName()));
        Object returnValue = null;
        try {
            returnValue = super.invoke(methodInvocation);
        }
        finally {
            this._dynamicDataSourceTargetSource.popMethod();
        }
        return returnValue;
    }

    public void setDynamicDataSourceTargetSource(DynamicDataSourceTargetSource dynamicDataSourceTargetSource) {
        this._dynamicDataSourceTargetSource = dynamicDataSourceTargetSource;
    }
}

