/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cluster;

import com.liferay.portal.cluster.AddressImpl;
import com.liferay.portal.cluster.BaseReceiver;
import com.liferay.portal.cluster.ClusterExecutorImpl;
import com.liferay.portal.cluster.ClusterInvokeThreadLocal;
import com.liferay.portal.kernel.bean.PortletBeanLocatorUtil;
import com.liferay.portal.kernel.cluster.Address;
import com.liferay.portal.kernel.cluster.ClusterException;
import com.liferay.portal.kernel.cluster.ClusterMessageType;
import com.liferay.portal.kernel.cluster.ClusterNode;
import com.liferay.portal.kernel.cluster.ClusterNodeResponse;
import com.liferay.portal.kernel.cluster.ClusterRequest;
import com.liferay.portal.kernel.cluster.FutureClusterResponses;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jgroups.ChannelException;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterRequestReceiver
extends BaseReceiver {
    private static Log _log = LogFactoryUtil.getLog(ClusterRequestReceiver.class);
    private ClusterExecutorImpl _clusterExecutorImpl;
    private View _lastView;

    public ClusterRequestReceiver(ClusterExecutorImpl clusterExecutorImpl) {
        this._clusterExecutorImpl = clusterExecutorImpl;
    }

    @Override
    public void receive(Message message) {
        boolean isProcessed;
        org.jgroups.Address sourceAddress = message.getSrc();
        JChannel controlChannel = this._clusterExecutorImpl.getControlChannel();
        org.jgroups.Address localAddress = controlChannel.getAddress();
        Object obj = message.getObject();
        if (obj == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Message content is null");
            }
            return;
        }
        if (localAddress.equals(sourceAddress) && (isProcessed = this.processLocalMessage(obj, sourceAddress))) {
            return;
        }
        if (obj instanceof ClusterRequest) {
            ClusterRequest clusterRequest = (ClusterRequest)obj;
            this.processClusterRequest(clusterRequest, sourceAddress, localAddress);
        } else if (obj instanceof ClusterNodeResponse) {
            ClusterNodeResponse clusterNodeResponse = (ClusterNodeResponse)obj;
            this.processClusterResponse(clusterNodeResponse, sourceAddress, localAddress);
        } else if (_log.isWarnEnabled()) {
            _log.warn((Object)("Unable to process message content of type " + obj.getClass().getName()));
        }
    }

    @Override
    public void viewAccepted(View view) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Accepted view " + view));
        }
        if (this._lastView == null) {
            this._lastView = view;
            return;
        }
        List<Address> departAddresses = this.getDepartAddresses(view);
        this._lastView = view;
        if (departAddresses.isEmpty()) {
            return;
        }
        this._clusterExecutorImpl.memberRemoved(departAddresses);
    }

    protected Object invoke(String servletContextName, MethodHandler methodHandler) throws Exception {
        if (servletContextName == null) {
            return methodHandler.invoke(true);
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            ClassLoader classLoader = (ClassLoader)PortletBeanLocatorUtil.locate((String)servletContextName, (String)"portletClassLoader");
            currentThread.setContextClassLoader(classLoader);
            Object object = methodHandler.invoke(true);
            return object;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            currentThread.setContextClassLoader(contextClassLoader);
        }
    }

    protected List<Address> getDepartAddresses(View view) {
        ArrayList<Address> departAddresses = new ArrayList<Address>();
        Vector jGroupsAddresses = view.getMembers();
        Vector lastJGroupsAddresses = this._lastView.getMembers();
        ArrayList tempAddresses = new ArrayList(jGroupsAddresses.size());
        tempAddresses.addAll(jGroupsAddresses);
        ArrayList lastAddresses = new ArrayList(lastJGroupsAddresses.size());
        lastAddresses.addAll(lastJGroupsAddresses);
        tempAddresses.retainAll(lastJGroupsAddresses);
        lastAddresses.removeAll(tempAddresses);
        if (!lastAddresses.isEmpty()) {
            Iterator itr = lastAddresses.iterator();
            while (itr.hasNext()) {
                departAddresses.add(new AddressImpl((org.jgroups.Address)itr.next()));
            }
        }
        return departAddresses;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void processClusterRequest(ClusterRequest clusterRequest, org.jgroups.Address sourceAddress, org.jgroups.Address localAddress) {
        ClusterNodeResponse clusterNodeResponse;
        block17: {
            ClusterMessageType clusterMessageType = clusterRequest.getClusterMessageType();
            clusterNodeResponse = new ClusterNodeResponse();
            try {
                ClusterNode localClusterNode = this._clusterExecutorImpl.getLocalClusterNode();
                clusterNodeResponse.setClusterNode(localClusterNode);
            }
            catch (Exception e) {
                clusterNodeResponse.setException(e);
            }
            if (clusterMessageType.equals((Object)ClusterMessageType.NOTIFY) || clusterMessageType.equals((Object)ClusterMessageType.UPDATE)) {
                ClusterNode originatingClusterNode = clusterRequest.getOriginatingClusterNode();
                if (originatingClusterNode == null) {
                    if (!_log.isWarnEnabled()) return;
                    _log.warn((Object)"Content of notify message does not contain cluster node information");
                    return;
                }
                this._clusterExecutorImpl.memberJoined(new AddressImpl(sourceAddress), originatingClusterNode);
                clusterNodeResponse.setClusterMessageType(clusterMessageType);
            } else {
                clusterNodeResponse.setClusterMessageType(ClusterMessageType.EXECUTE);
                clusterNodeResponse.setMulticast(clusterRequest.isMulticast());
                clusterNodeResponse.setUuid(clusterRequest.getUuid());
                MethodHandler methodHandler = clusterRequest.getMethodHandler();
                if (methodHandler != null) {
                    block16: {
                        try {
                            try {
                                ClusterInvokeThreadLocal.setEnabled(false);
                                Object returnValue = this.invoke(clusterRequest.getServletContextName(), methodHandler);
                                if (returnValue instanceof Serializable) {
                                    clusterNodeResponse.setResult(returnValue);
                                    break block16;
                                }
                                if (returnValue != null) {
                                    clusterNodeResponse.setException((Exception)new ClusterException("Return value is not serializable"));
                                }
                            }
                            catch (Exception e) {
                                clusterNodeResponse.setException(e);
                                _log.error((Object)("Failed to invoke method " + methodHandler), (Throwable)e);
                                ClusterInvokeThreadLocal.setEnabled(true);
                                break block17;
                            }
                        }
                        catch (Throwable throwable) {
                            ClusterInvokeThreadLocal.setEnabled(true);
                            throw throwable;
                        }
                    }
                    ClusterInvokeThreadLocal.setEnabled(true);
                } else {
                    clusterNodeResponse.setException((Exception)new ClusterException("Payload is not of type " + MethodHandler.class.getName()));
                }
            }
        }
        JChannel controlChannel = this._clusterExecutorImpl.getControlChannel();
        try {
            controlChannel.send(sourceAddress, localAddress, (Serializable)clusterNodeResponse);
            return;
        }
        catch (ChannelException ce) {
            _log.error((Object)("Unable to send response message " + clusterNodeResponse), (Throwable)ce);
            return;
        }
        catch (Throwable t) {
            _log.error((Object)t, t);
        }
    }

    protected void processClusterResponse(ClusterNodeResponse clusterNodeResponse, org.jgroups.Address sourceAddress, org.jgroups.Address localAddress) {
        ClusterMessageType clusterMessageType = clusterNodeResponse.getClusterMessageType();
        if (clusterMessageType.equals((Object)ClusterMessageType.NOTIFY) || clusterMessageType.equals((Object)ClusterMessageType.UPDATE)) {
            ClusterNode clusterNode = clusterNodeResponse.getClusterNode();
            if (clusterNode != null) {
                AddressImpl joinAddress = new AddressImpl(sourceAddress);
                this._clusterExecutorImpl.memberJoined(joinAddress, clusterNode);
            } else if (_log.isWarnEnabled()) {
                _log.warn((Object)"Response of notify message does not contain cluster node information");
            }
            return;
        }
        String uuid = clusterNodeResponse.getUuid();
        FutureClusterResponses futureClusterResponses = this._clusterExecutorImpl.getExecutionResults(uuid);
        if (futureClusterResponses == null) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Unable to find response container for " + uuid));
            }
            return;
        }
        AddressImpl address = new AddressImpl(sourceAddress);
        if (futureClusterResponses.expectsReply((Address)address)) {
            futureClusterResponses.addClusterNodeResponse(clusterNodeResponse);
        } else if (_log.isWarnEnabled()) {
            _log.warn((Object)("Unknown uuid " + uuid + " from " + sourceAddress));
        }
    }

    protected boolean processLocalMessage(Object message, org.jgroups.Address sourceAddress) {
        if (message instanceof ClusterRequest) {
            ClusterRequest clusterRequest = (ClusterRequest)message;
            if (clusterRequest.isSkipLocal()) {
                return true;
            }
            ClusterMessageType clusterMessageType = clusterRequest.getClusterMessageType();
            if (clusterMessageType.equals((Object)ClusterMessageType.NOTIFY) || clusterMessageType.equals((Object)ClusterMessageType.UPDATE)) {
                ClusterNode originatingClusterNode = clusterRequest.getOriginatingClusterNode();
                if (originatingClusterNode != null) {
                    AddressImpl joinAddress = new AddressImpl(sourceAddress);
                    this._clusterExecutorImpl.memberJoined(joinAddress, originatingClusterNode);
                } else if (_log.isWarnEnabled()) {
                    _log.warn((Object)"Content of notify message does not contain cluster node information");
                }
                return true;
            }
        }
        return this._clusterExecutorImpl.isShortcutLocalMethod();
    }
}

