/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.cluster.clusterlink.messaging;

import com.liferay.portal.cache.ehcache.EhcachePortalCacheManager;
import com.liferay.portal.dao.orm.hibernate.EhCacheProvider;
import com.liferay.portal.kernel.cache.cluster.PortalCacheClusterEvent;
import com.liferay.portal.kernel.cache.cluster.PortalCacheClusterEventType;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;

public class ClusterLinkPortalCacheClusterRemoveListener
implements MessageListener {
    private static Log _log = LogFactoryUtil.getLog(ClusterLinkPortalCacheClusterRemoveListener.class);
    private CacheManager _hibernateCacheManager = EhCacheProvider.getCacheManager();
    private CacheManager _portalCacheManager;

    public ClusterLinkPortalCacheClusterRemoveListener(EhcachePortalCacheManager ehcachePortalCacheManager) throws SystemException {
        this._portalCacheManager = ehcachePortalCacheManager.getEhcacheManager();
    }

    public void receive(Message message) {
        PortalCacheClusterEvent portalCacheClusterEvent = (PortalCacheClusterEvent)message.getPayload();
        if (portalCacheClusterEvent == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Payload is null");
            }
            return;
        }
        String cacheName = portalCacheClusterEvent.getCacheName();
        Cache cache = this._portalCacheManager.getCache(cacheName);
        if (cache == null) {
            cache = this._hibernateCacheManager.getCache(cacheName);
        }
        if (cache != null) {
            PortalCacheClusterEventType portalCacheClusterEventType = portalCacheClusterEvent.getEventType();
            if (portalCacheClusterEventType.equals((Object)PortalCacheClusterEventType.REMOVEALL)) {
                cache.removeAll(true);
            } else {
                cache.remove(portalCacheClusterEvent.getElementKey(), true);
            }
        }
    }
}

