/*
 * Decompiled with CFR 0.152.
 */
package org.compass.needle.gigaspaces.service;

import java.io.Externalizable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.compass.needle.gigaspaces.service.CompassSearchService;
import org.compass.needle.gigaspaces.service.SearchResourceResult;
import org.compass.needle.gigaspaces.service.SearchResourceResults;
import org.compass.needle.gigaspaces.service.SearchResult;
import org.compass.needle.gigaspaces.service.SearchResults;
import org.openspaces.core.GigaSpace;
import org.openspaces.remoting.ExecutorRemotingProxyConfigurer;
import org.openspaces.remoting.RemoteResultReducer;
import org.openspaces.remoting.SpaceRemotingInvocation;
import org.openspaces.remoting.SpaceRemotingResult;

public class ClientCompassSearchService
implements CompassSearchService {
    private CompassSearchService searchService;

    public ClientCompassSearchService(GigaSpace gigaSpace) {
        this.searchService = (CompassSearchService)new ExecutorRemotingProxyConfigurer(gigaSpace, CompassSearchService.class).broadcast((RemoteResultReducer)new SearchReducer()).proxy();
    }

    public SearchResourceResults searchResource(String query) {
        return this.searchService.searchResource(query);
    }

    public SearchResults search(String query) {
        return this.searchService.search(query);
    }

    public SearchResourceResults searchResource(String query, int maxResults) {
        return this.searchService.searchResource(query, maxResults);
    }

    public SearchResults search(String query, int maxResults) {
        return this.searchService.search(query, maxResults);
    }

    public SearchResourceResults searchResource(String query, int maxResults, float fromScore) {
        return this.searchService.searchResource(query, maxResults, fromScore);
    }

    public SearchResults search(String query, int maxResults, float fromScore) {
        return this.searchService.search(query, maxResults, fromScore);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SearchResourceResultComparator
    implements Comparator<SearchResourceResult> {
        private SearchResourceResultComparator() {
        }

        @Override
        public int compare(SearchResourceResult o1, SearchResourceResult o2) {
            int ret = Float.compare(o1.getScore(), o2.getScore());
            if (ret == -1) {
                return 1;
            }
            if (ret == 1) {
                return -1;
            }
            return ret;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SearchResultComparator
    implements Comparator<SearchResult> {
        private SearchResultComparator() {
        }

        @Override
        public int compare(SearchResult o1, SearchResult o2) {
            int ret = Float.compare(o1.getScore(), o2.getScore());
            if (ret == -1) {
                return 1;
            }
            if (ret == 1) {
                return -1;
            }
            return ret;
        }
    }

    private class SearchReducer
    implements RemoteResultReducer {
        private SearchReducer() {
        }

        public Object reduce(SpaceRemotingResult[] spaceRemotingResults, SpaceRemotingInvocation spaceRemotingInvocation) throws Exception {
            ArrayList<Externalizable> ret;
            for (SpaceRemotingResult result : spaceRemotingResults) {
                if (result.getException() == null) continue;
                throw (Exception)result.getException();
            }
            if (spaceRemotingInvocation.getMethodName().equals("searchResource")) {
                ret = new ArrayList<Externalizable>();
                long totalLength = 0L;
                for (SpaceRemotingResult result : spaceRemotingResults) {
                    SearchResourceResults searchResourceResults = (SearchResourceResults)result.getResult();
                    for (int i = 0; i < searchResourceResults.getResults().length; ++i) {
                        ret.add(searchResourceResults.getResults()[i]);
                    }
                    totalLength += searchResourceResults.getTotalLength();
                }
                SearchResourceResult[] retArray = ret.toArray(new SearchResourceResult[ret.size()]);
                Arrays.sort(retArray, new SearchResourceResultComparator());
                return new SearchResourceResults(retArray, totalLength);
            }
            if (spaceRemotingInvocation.getMethodName().equals("search")) {
                ret = new ArrayList();
                int totalLength = 0;
                for (SpaceRemotingResult result : spaceRemotingResults) {
                    SearchResults searchResults = (SearchResults)result.getResult();
                    for (int i = 0; i < searchResults.getResults().length; ++i) {
                        ret.add(searchResults.getResults()[i]);
                    }
                    totalLength = (int)((long)totalLength + searchResults.getTotalLength());
                }
                SearchResult[] retArray = ret.toArray(new SearchResult[ret.size()]);
                Arrays.sort(retArray, new SearchResultComparator());
                return new SearchResults(retArray, totalLength);
            }
            return null;
        }
    }
}

