/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.mapping.json.builder;

import org.compass.core.converter.Converter;
import org.compass.core.converter.mapping.ResourcePropertyConverter;
import org.compass.core.converter.mapping.support.FormatDelegateConverter;
import org.compass.core.mapping.ExcludeFromAll;
import org.compass.core.mapping.SpellCheck;
import org.compass.core.mapping.json.JsonIdMapping;

public class JsonIdMappingBuilder {
    final JsonIdMapping mapping = new JsonIdMapping();

    public JsonIdMappingBuilder(String name) {
        this.mapping.setName(name);
        this.mapping.setOmitNorms(true);
        this.mapping.setOmitTf(true);
    }

    public JsonIdMappingBuilder analyzer(String analyzer) {
        this.mapping.setAnalyzer(analyzer);
        return this;
    }

    public JsonIdMappingBuilder omitNorms(boolean omitNorms) {
        this.mapping.setOmitNorms(omitNorms);
        return this;
    }

    public JsonIdMappingBuilder omitTf(boolean omitTf) {
        this.mapping.setOmitTf(omitTf);
        return this;
    }

    public JsonIdMappingBuilder boost(float boost) {
        this.mapping.setBoost(boost);
        return this;
    }

    public JsonIdMappingBuilder format(String format) {
        this.mapping.setValueConverter(new FormatDelegateConverter(format));
        this.mapping.setFormat(format);
        return this;
    }

    public JsonIdMappingBuilder mappingConverter(String converterName) {
        this.mapping.setConverterName(converterName);
        return this;
    }

    public JsonIdMappingBuilder mappingConverter(Converter converter) {
        this.mapping.setConverter(converter);
        return this;
    }

    public JsonIdMappingBuilder valueConverter(String converterName) {
        this.mapping.setValueConverterName(converterName);
        return this;
    }

    public JsonIdMappingBuilder valueConverter(Converter converter) {
        this.mapping.setValueConverter(converter);
        return this;
    }

    public JsonIdMappingBuilder valueConverter(ResourcePropertyConverter converter) {
        this.mapping.setValueConverter(converter);
        return this;
    }

    public JsonIdMappingBuilder excludeFromAll(ExcludeFromAll excludeFromAll) {
        this.mapping.setExcludeFromAll(excludeFromAll);
        return this;
    }

    public JsonIdMappingBuilder spellCheck(SpellCheck spellCheck) {
        this.mapping.setSpellCheck(spellCheck);
        return this;
    }
}

