/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;

public abstract class LuceneUtils {
    public static void copy(Directory src, Directory dest, byte[] buffer) throws IOException {
        String[] files = src.list();
        if (files != null) {
            for (String name : files) {
                LuceneUtils.copy(src, dest, name, buffer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(Directory src, Directory dest, String name, byte[] buffer) throws IOException {
        if (!src.fileExists(name)) {
            return;
        }
        IndexInput indexInput = null;
        IndexOutput indexOutput = null;
        try {
            indexInput = src.openInput(name);
            indexOutput = dest.createOutput(name);
            LuceneUtils.copy(indexInput, indexOutput, name, buffer);
        }
        finally {
            if (indexInput != null) {
                indexInput.close();
            }
            if (indexOutput != null) {
                indexOutput.close();
            }
        }
    }

    public static void copy(IndexInput indexInput, IndexOutput indexOutput, String name, byte[] buffer) throws IOException {
        long length;
        long remainder;
        int len;
        int chunk = buffer.length;
        for (remainder = length = indexInput.length(); remainder > 0L; remainder -= (long)len) {
            len = (int)Math.min((long)chunk, remainder);
            indexInput.readBytes(buffer, 0, len);
            indexOutput.writeBytes(buffer, len);
        }
        if (remainder != 0L) {
            throw new IOException("Non-zero remainder length after copying [" + remainder + "] (id [" + name + "] length [" + length + "] buffer size [" + chunk + "])");
        }
    }

    public static boolean isCompound(Directory directory) throws IOException {
        if (!IndexReader.indexExists((Directory)directory)) {
            return true;
        }
        SegmentInfos segmentInfos = new SegmentInfos();
        segmentInfos.read(directory);
        if (segmentInfos.isEmpty()) {
            return true;
        }
        for (int i = 0; i < segmentInfos.size(); ++i) {
            SegmentInfo segmentInfo = segmentInfos.info(i);
            if (segmentInfo.getUseCompoundFile()) continue;
            return false;
        }
        return true;
    }

    public static boolean isUnCompound(Directory directory) throws IOException {
        if (!IndexReader.indexExists((Directory)directory)) {
            return true;
        }
        SegmentInfos segmentInfos = new SegmentInfos();
        segmentInfos.read(directory);
        if (segmentInfos.isEmpty()) {
            return true;
        }
        for (int i = 0; i < segmentInfos.size(); ++i) {
            SegmentInfo segmentInfo = segmentInfos.info(i);
            if (!segmentInfo.getUseCompoundFile()) continue;
            return false;
        }
        return true;
    }

    public static void clearLocks(Lock[] locks) {
        if (locks == null) {
            return;
        }
        for (Lock lock : locks) {
            if (lock == null) continue;
            try {
                lock.release();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }
}

