/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.ext.features;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.abdera.ext.features.Feature;
import org.apache.abdera.ext.features.FeaturesHelper;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.ExtensibleElementWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Features
extends ExtensibleElementWrapper {
    public Features(Element internal) {
        super(internal);
    }

    public Features(Factory factory, QName qname) {
        super(factory, qname);
    }

    public IRI getResolvedHref() {
        IRI base = this.getResolvedBaseUri();
        IRI href = this.getHref();
        return base != null ? base.resolve(href) : href;
    }

    public IRI getHref() {
        String href = this.getAttributeValue("href");
        return href != null ? new IRI(href) : null;
    }

    public void setHref(String href) {
        this.setAttributeValue("href", new IRI(href).toString());
    }

    public String getName() {
        return this.getAttributeValue("name");
    }

    public void setName(String name) {
        this.setAttributeValue("name", name);
    }

    public void addFeature(Feature feature) {
        this.addExtension(feature);
    }

    public void addFeature(Feature ... features) {
        for (Feature feature : features) {
            this.addFeature(feature);
        }
    }

    public Feature addFeature(String feature) {
        Feature f = (Feature)this.addExtension(FeaturesHelper.FEATURE);
        f.setRef(feature);
        return f;
    }

    public Feature addFeature(String feature, String href, String label) {
        Feature f = (Feature)this.addExtension(FeaturesHelper.FEATURE);
        f.setRef(feature);
        f.setHref(href);
        f.setLabel(label);
        return f;
    }

    public Feature[] addFeatures(String ... features) {
        ArrayList<Feature> list = new ArrayList<Feature>();
        for (String feature : features) {
            list.add(this.addFeature(feature));
        }
        return list.toArray(new Feature[list.size()]);
    }

    public List<Feature> getFeatures() {
        return this.getExtensions(FeaturesHelper.FEATURE);
    }
}

