/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso.lineage;

import java.util.Collection;
import org.geotools.metadata.iso.MetadataEntity;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.identification.RepresentativeFraction;
import org.opengis.metadata.lineage.ProcessStep;
import org.opengis.metadata.lineage.Source;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.util.InternationalString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceImpl
extends MetadataEntity
implements Source {
    private static final long serialVersionUID = 2660914446466438044L;
    private InternationalString description;
    private RepresentativeFraction scaleDenominator;
    private ReferenceSystem sourceReferenceSystem;
    private Citation sourceCitation;
    private Collection<Extent> sourceExtents;
    private Collection<ProcessStep> sourceSteps;

    public SourceImpl() {
    }

    public SourceImpl(Source source) {
        super(source);
    }

    public SourceImpl(InternationalString description) {
        this.setDescription(description);
    }

    public InternationalString getDescription() {
        return this.description;
    }

    public synchronized void setDescription(InternationalString newValue) {
        this.checkWritePermission();
        this.description = newValue;
    }

    public synchronized RepresentativeFraction getScaleDenominator() {
        return this.scaleDenominator;
    }

    public synchronized void setScaleDenominator(RepresentativeFraction newValue) {
        this.checkWritePermission();
        this.scaleDenominator = newValue;
    }

    public ReferenceSystem getSourceReferenceSystem() {
        return this.sourceReferenceSystem;
    }

    public synchronized void setSourceReferenceSystem(ReferenceSystem newValue) {
        this.checkWritePermission();
        this.sourceReferenceSystem = newValue;
    }

    public Citation getSourceCitation() {
        return this.sourceCitation;
    }

    public synchronized void setSourceCitation(Citation newValue) {
        this.checkWritePermission();
        this.sourceCitation = newValue;
    }

    public synchronized Collection<Extent> getSourceExtents() {
        this.sourceExtents = this.nonNullCollection(this.sourceExtents, Extent.class);
        return this.sourceExtents;
    }

    public synchronized void setSourceExtents(Collection<? extends Extent> newValues) {
        this.sourceExtents = this.copyCollection(newValues, this.sourceExtents, Extent.class);
    }

    public synchronized Collection<ProcessStep> getSourceSteps() {
        this.sourceSteps = this.nonNullCollection(this.sourceSteps, ProcessStep.class);
        return this.sourceSteps;
    }

    public synchronized void setSourceSteps(Collection<? extends ProcessStep> newValues) {
        this.sourceSteps = this.copyCollection(newValues, this.sourceSteps, ProcessStep.class);
    }
}

