/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.pbcast;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.annotations.DeprecatedProperty;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.Property;
import org.jgroups.conf.PropertyConverters;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.StateTransferInfo;
import org.jgroups.util.Digest;
import org.jgroups.util.ShutdownRejectedExecutionHandler;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MBean(description="State trasnfer protocol based on streaming state transfer")
@DeprecatedProperty(names={"use_flush", "flush_timeout", "use_reading_thread"})
public class STREAMING_STATE_TRANSFER
extends Protocol {
    @Property(description="The interface (NIC) used to accept state requests", systemProperty={"jgroups.bind_addr", "bind.address"}, defaultValueIPv4="NON_LOOPBACK_ADDRESS", defaultValueIPv6="NON_LOOPBACK_ADDRESS")
    private InetAddress bind_addr;
    @Property(name="bind_interface", converter=PropertyConverters.BindInterface.class, description="The interface (NIC) which should be used by this transport", dependsUpon="bind_addr")
    protected String bind_interface_str = null;
    @Property(description="The port listening for state requests. Default value of 0 binds to any (ephemeral) port")
    private int bind_port = 0;
    @Property(description="Maximum number of pool threads serving state requests. Default is 5")
    private int max_pool = 5;
    @Property(description="Keep alive for pool threads serving state requests. Default is 20000 msec")
    private long pool_thread_keep_alive = 20000L;
    @Property(description="Buffer size for state transfer. Default is 8192 bytes")
    private int socket_buffer_size = 8192;
    @Property(description="If default transport is used the total state buffer size before state producer is blocked. Default is 81920 bytes")
    private int buffer_queue_size = 81920;
    @Property(description="If true default transport is used for state transfer rather than seperate TCP sockets. Default is false")
    boolean use_default_transport = false;
    private final AtomicInteger num_state_reqs = new AtomicInteger(0);
    private final AtomicLong num_bytes_sent = new AtomicLong(0L);
    private volatile double avg_state_size = 0.0;
    private Address local_addr = null;
    private final Vector<Address> members;
    private BlockingQueue<Message> stateQueue;
    private StateProviderThreadSpawner spawner;
    private AtomicBoolean flushProtocolInStack = new AtomicBoolean(false);

    public STREAMING_STATE_TRANSFER() {
        this.members = new Vector();
    }

    @ManagedAttribute
    public int getNumberOfStateRequests() {
        return this.num_state_reqs.get();
    }

    @ManagedAttribute
    public long getNumberOfStateBytesSent() {
        return this.num_bytes_sent.get();
    }

    @ManagedAttribute
    public double getAverageStateSize() {
        return this.avg_state_size;
    }

    @Override
    public Vector<Integer> requiredDownServices() {
        Vector<Integer> retval = new Vector<Integer>();
        retval.addElement(new Integer(39));
        retval.addElement(new Integer(42));
        return retval;
    }

    @Override
    public void resetStats() {
        super.resetStats();
        this.num_state_reqs.set(0);
        this.num_bytes_sent.set(0L);
        this.avg_state_size = 0.0;
    }

    @Override
    public void init() throws Exception {
    }

    @Override
    public void start() throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("state_transfer", Boolean.TRUE);
        map.put("protocol_class", this.getClass().getName());
        this.up_prot.up(new Event(56, map));
        if (this.use_default_transport) {
            int size = this.buffer_queue_size / this.socket_buffer_size;
            if (size <= 1) {
                size = 10;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("buffer_queue_size=" + this.buffer_queue_size + ", socket_buffer_size=" + this.socket_buffer_size + ", creating queue of size " + size);
            }
            this.stateQueue = new ArrayBlockingQueue<Message>(size);
        }
    }

    @Override
    public void stop() {
        super.stop();
        if (this.spawner != null) {
            this.spawner.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                StateHeader hdr = (StateHeader)msg.getHeader(this.getName());
                if (hdr == null) break;
                switch (hdr.type) {
                    case 1: {
                        this.handleStateReq(hdr);
                        break;
                    }
                    case 2: {
                        if (this.isDigestNeeded()) {
                            this.down_prot.down(new Event(76));
                        }
                        try {
                            this.handleStateRsp(hdr);
                            Object var5_4 = null;
                            if (!this.isDigestNeeded()) break;
                            this.down_prot.down(new Event(77));
                        }
                        catch (Throwable throwable) {
                            Object var5_5 = null;
                            if (this.isDigestNeeded()) {
                                this.down_prot.down(new Event(77));
                            }
                            throw throwable;
                        }
                        break;
                    }
                    case 3: {
                        try {
                            this.stateQueue.put(msg);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                        break;
                    }
                    default: {
                        if (!this.log.isErrorEnabled()) break;
                        this.log.error("type " + hdr.type + " not known in StateHeader");
                    }
                }
                return null;
            }
            case 6: 
            case 15: {
                this.handleViewChange((View)evt.getArg());
                break;
            }
            case 56: {
                Map config = (Map)evt.getArg();
                if (this.bind_addr == null && config != null && config.containsKey("bind_addr")) {
                    this.bind_addr = (InetAddress)config.get("bind_addr");
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("using bind_addr from CONFIG event " + this.bind_addr);
                    }
                }
                if (config == null || !config.containsKey("state_transfer")) break;
                this.log.error("Protocol stack must have only one state transfer protocol");
            }
        }
        return this.up_prot.up(evt);
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 6: 
            case 15: {
                this.handleViewChange((View)evt.getArg());
                break;
            }
            case 19: {
                Address target;
                StateTransferInfo info = (StateTransferInfo)evt.getArg();
                if (info.target == null) {
                    target = this.determineCoordinator();
                } else {
                    target = info.target;
                    if (target.equals(this.local_addr)) {
                        if (this.log.isErrorEnabled()) {
                            this.log.error("GET_STATE: cannot fetch state from myself !");
                        }
                        target = null;
                    }
                }
                if (target == null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("GET_STATE: first member (no state)");
                    }
                    this.up_prot.up(new Event(20, new StateTransferInfo()));
                } else {
                    Message state_req = new Message(target, null, null);
                    state_req.putHeader(this.getName(), new StateHeader(1, this.local_addr, info.state_id));
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("GET_STATE: asking " + target + " for state, passing down a SUSPEND_STABLE event, timeout=" + info.timeout);
                    }
                    this.down_prot.down(new Event(65, new Long(info.timeout)));
                    this.down_prot.down(new Event(1, state_req));
                }
                return null;
            }
            case 73: {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("STATE_TRANSFER_INPUTSTREAM_CLOSED received");
                }
                this.down_prot.down(new Event(66));
                return null;
            }
            case 56: {
                Map config = (Map)evt.getArg();
                if (config == null || !config.containsKey("flush_supported")) break;
                this.flushProtocolInStack.set(true);
                break;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
            }
        }
        return this.down_prot.down(evt);
    }

    private boolean isDigestNeeded() {
        return !this.flushProtocolInStack.get();
    }

    private void respondToStateRequester(String id, Address stateRequester, boolean open_barrier) {
        if (this.spawner == null && !this.use_default_transport) {
            this.spawner = new StateProviderThreadSpawner(this.setupThreadPool(), Util.createServerSocket(this.bind_addr, this.bind_port));
            Thread t = this.getThreadFactory().newThread(this.spawner, "STREAMING_STATE_TRANSFER server socket acceptor");
            t.start();
        }
        Digest digest = this.isDigestNeeded() ? (Digest)this.down_prot.down(Event.GET_DIGEST_EVT) : null;
        Message state_rsp = new Message(stateRequester);
        StateHeader hdr = new StateHeader(2, this.local_addr, this.use_default_transport ? null : this.spawner.getServerSocketAddress(), digest, id);
        state_rsp.putHeader(this.getName(), hdr);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Responding to state requester " + state_rsp.getDest() + " with address " + (this.use_default_transport ? null : this.spawner.getServerSocketAddress()) + " and digest " + digest);
        }
        this.down_prot.down(new Event(1, state_rsp));
        if (this.stats) {
            this.num_state_reqs.incrementAndGet();
        }
        if (open_barrier) {
            this.down_prot.down(new Event(77));
        }
        if (this.use_default_transport) {
            this.openAndProvideOutputStreamToStateProvider(stateRequester, id);
        }
    }

    private ThreadPoolExecutor setupThreadPool() {
        ThreadPoolExecutor threadPool = new ThreadPoolExecutor(0, this.max_pool, this.pool_thread_keep_alive, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>());
        ThreadFactory factory = new ThreadFactory(){

            public Thread newThread(Runnable command) {
                return STREAMING_STATE_TRANSFER.this.getThreadFactory().newThread(command, "STREAMING_STATE_TRANSFER sender");
            }
        };
        threadPool.setRejectedExecutionHandler(new ShutdownRejectedExecutionHandler(threadPool.getRejectedExecutionHandler()));
        threadPool.setThreadFactory(factory);
        return threadPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Address determineCoordinator() {
        Vector<Address> vector = this.members;
        synchronized (vector) {
            for (Address member : this.members) {
                if (this.local_addr.equals(member)) continue;
                return member;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleViewChange(View v) {
        Vector<Address> new_members = v.getMembers();
        Vector<Address> vector = this.members;
        synchronized (vector) {
            this.members.clear();
            this.members.addAll(new_members);
        }
    }

    private void handleStateReq(StateHeader hdr) {
        block6: {
            Address sender = hdr.sender;
            String id = hdr.state_id;
            if (sender == null) {
                if (this.log.isErrorEnabled()) {
                    this.log.error("sender is null !");
                }
                return;
            }
            if (this.isDigestNeeded()) {
                this.down_prot.down(new Event(76));
            }
            try {
                this.respondToStateRequester(id, sender, this.isDigestNeeded());
            }
            catch (Throwable t) {
                if (this.log.isErrorEnabled()) {
                    this.log.error("failed fetching state from application", t);
                }
                if (!this.isDigestNeeded()) break block6;
                this.down_prot.down(new Event(77));
            }
        }
    }

    void handleStateRsp(final StateHeader hdr) {
        Digest tmp_digest = hdr.my_digest;
        if (this.isDigestNeeded()) {
            if (tmp_digest == null) {
                if (this.log.isWarnEnabled()) {
                    this.log.warn("digest received from " + hdr.sender + " is null, skipping setting digest !");
                }
            } else {
                this.down_prot.down(new Event(42, tmp_digest));
            }
        }
        if (this.use_default_transport) {
            Thread t = this.getThreadFactory().newThread(new Runnable(){

                public void run() {
                    STREAMING_STATE_TRANSFER.this.openAndProvideInputStreamToStateReceiver(hdr.sender, hdr.getStateId());
                }
            }, "STREAMING_STATE_TRANSFER state reader");
            t.start();
        } else {
            this.connectToStateProvider(hdr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void openAndProvideInputStreamToStateReceiver(Address stateProvider, String state_id) {
        BufferedInputStream bis = null;
        try {
            try {
                bis = new BufferedInputStream(new StateInputStream(), this.socket_buffer_size);
                this.up_prot.up(new Event(71, new StateTransferInfo(stateProvider, bis, state_id)));
            }
            catch (IOException e) {
                this.log.error("Could not provide state recipient with appropriate stream", e);
                InputStream is = null;
                this.up_prot.up(new Event(71, new StateTransferInfo(stateProvider, is, state_id)));
                Object var7_5 = null;
                Util.close(bis);
                return;
            }
            Object var7_4 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            Util.close(bis);
            throw throwable;
        }
        Util.close(bis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void openAndProvideOutputStreamToStateProvider(Address stateRequester, String state_id) {
        BufferedOutputStream bos = null;
        try {
            try {
                bos = new BufferedOutputStream(new StateOutputStream(stateRequester, state_id), this.socket_buffer_size);
                this.up_prot.up(new Event(72, new StateTransferInfo(stateRequester, bos, state_id)));
            }
            catch (IOException e) {
                if (this.log.isWarnEnabled()) {
                    this.log.warn("StateOutputStream could not be given to application", e);
                }
                Object var6_5 = null;
                Util.close(bos);
                return;
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            Util.close(bos);
            throw throwable;
        }
        Util.close(bos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void connectToStateProvider(StateHeader hdr) {
        Socket socket;
        BufferedInputStream bis;
        block10: {
            IpAddress address = hdr.bind_addr;
            String tmp_state_id = hdr.getStateId();
            bis = null;
            StateTransferInfo sti = null;
            socket = new Socket();
            try {
                try {
                    socket.bind(new InetSocketAddress(this.bind_addr, 0));
                    int bufferSize = socket.getReceiveBufferSize();
                    socket.setReceiveBufferSize(this.socket_buffer_size);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Connecting to state provider " + address.getIpAddress() + ":" + address.getPort() + ", original buffer size was " + bufferSize + " and was reset to " + socket.getReceiveBufferSize());
                    }
                    Util.connect(socket, new InetSocketAddress(address.getIpAddress(), address.getPort()), 0);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Connected to state provider, my end of the socket is " + socket.getLocalAddress() + ":" + socket.getLocalPort() + " passing inputstream up...");
                    }
                    ObjectOutputStream out = new ObjectOutputStream(socket.getOutputStream());
                    out.writeObject(tmp_state_id);
                    out.writeObject(this.local_addr);
                    bis = new BufferedInputStream(new StreamingInputStreamWrapper(socket), this.socket_buffer_size);
                    sti = new StateTransferInfo(hdr.sender, bis, tmp_state_id);
                    this.up_prot.up(new Event(71, sti));
                }
                catch (IOException e) {
                    if (this.log.isWarnEnabled()) {
                        this.log.warn("State reader socket thread spawned abnormaly", e);
                    }
                    InputStream is = null;
                    sti = new StateTransferInfo(hdr.sender, is, tmp_state_id);
                    this.up_prot.up(new Event(71, sti));
                    Object var10_12 = null;
                    if (!socket.isConnected() && this.log.isWarnEnabled()) {
                        this.log.warn("Could not connect to state provider. Closing socket...");
                    }
                    Util.close(bis);
                    Util.close(socket);
                    return;
                }
                Object var10_11 = null;
                if (socket.isConnected() || !this.log.isWarnEnabled()) break block10;
                this.log.warn("Could not connect to state provider. Closing socket...");
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                if (!socket.isConnected() && this.log.isWarnEnabled()) {
                    this.log.warn("Could not connect to state provider. Closing socket...");
                }
                Util.close(bis);
                Util.close(socket);
                throw throwable;
            }
        }
        Util.close(bis);
        Util.close(socket);
    }

    public static class StateHeader
    extends Header
    implements Streamable {
        public static final byte STATE_REQ = 1;
        public static final byte STATE_RSP = 2;
        public static final byte STATE_PART = 3;
        long id = 0L;
        byte type = 0;
        Address sender;
        Digest my_digest = null;
        IpAddress bind_addr = null;
        String state_id = null;

        public StateHeader() {
        }

        public StateHeader(byte type, Address sender, String state_id) {
            this.type = type;
            this.sender = sender;
            this.state_id = state_id;
        }

        public StateHeader(byte type, Address sender, long id, Digest digest) {
            this.type = type;
            this.sender = sender;
            this.id = id;
            this.my_digest = digest;
        }

        public StateHeader(byte type, Address sender, IpAddress bind_addr, Digest digest, String state_id) {
            this.type = type;
            this.sender = sender;
            this.my_digest = digest;
            this.bind_addr = bind_addr;
            this.state_id = state_id;
        }

        public int getType() {
            return this.type;
        }

        public Digest getDigest() {
            return this.my_digest;
        }

        public String getStateId() {
            return this.state_id;
        }

        public boolean equals(Object o) {
            if (this.sender != null && o != null) {
                if (!(o instanceof StateHeader)) {
                    return false;
                }
                StateHeader other = (StateHeader)o;
                return this.sender.equals(other.sender) && this.id == other.id;
            }
            return false;
        }

        public int hashCode() {
            if (this.sender != null) {
                return this.sender.hashCode() + (int)this.id;
            }
            return (int)this.id;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("type=").append(StateHeader.type2Str(this.type));
            if (this.sender != null) {
                sb.append(", sender=").append(this.sender).append(" id=").append(this.id);
            }
            if (this.my_digest != null) {
                sb.append(", digest=").append(this.my_digest);
            }
            return sb.toString();
        }

        static String type2Str(int t) {
            switch (t) {
                case 1: {
                    return "STATE_REQ";
                }
                case 2: {
                    return "STATE_RSP";
                }
                case 3: {
                    return "STATE_PART";
                }
            }
            return "<unknown>";
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.sender);
            out.writeLong(this.id);
            out.writeByte(this.type);
            out.writeObject(this.my_digest);
            out.writeObject(this.bind_addr);
            out.writeUTF(this.state_id);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.sender = (Address)in.readObject();
            this.id = in.readLong();
            this.type = in.readByte();
            this.my_digest = (Digest)in.readObject();
            this.bind_addr = (IpAddress)in.readObject();
            this.state_id = in.readUTF();
        }

        public void writeTo(DataOutputStream out) throws IOException {
            out.writeByte(this.type);
            out.writeLong(this.id);
            Util.writeAddress(this.sender, out);
            Util.writeStreamable(this.my_digest, out);
            Util.writeStreamable(this.bind_addr, out);
            Util.writeString(this.state_id, out);
        }

        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            this.type = in.readByte();
            this.id = in.readLong();
            this.sender = Util.readAddress(in);
            this.my_digest = (Digest)Util.readStreamable(Digest.class, in);
            this.bind_addr = (IpAddress)Util.readStreamable(IpAddress.class, in);
            this.state_id = Util.readString(in);
        }

        public int size() {
            int retval = 9;
            retval += Util.size(this.sender);
            ++retval;
            if (this.my_digest != null) {
                retval = (int)((long)retval + this.my_digest.serializedSize());
            }
            retval += Util.size(this.bind_addr);
            ++retval;
            if (this.state_id != null) {
                retval += this.state_id.length() + 2;
            }
            return retval;
        }
    }

    private class StateOutputStream
    extends OutputStream {
        private final Address stateRequester;
        private final String state_id;
        private final AtomicBoolean closed;
        private long bytesWrittenCounter = 0L;

        public StateOutputStream(Address stateRequester, String state_id) throws IOException {
            this.stateRequester = stateRequester;
            this.state_id = state_id;
            this.closed = new AtomicBoolean(false);
        }

        public void close() throws IOException {
            if (this.closed.compareAndSet(false, true)) {
                if (STREAMING_STATE_TRANSFER.this.log.isDebugEnabled()) {
                    STREAMING_STATE_TRANSFER.this.log.debug("State writer " + STREAMING_STATE_TRANSFER.this.local_addr + " is closing the output stream for state_id " + this.state_id);
                }
                STREAMING_STATE_TRANSFER.this.up(new Event(74));
                STREAMING_STATE_TRANSFER.this.down(new Event(74));
                if (STREAMING_STATE_TRANSFER.this.stats) {
                    STREAMING_STATE_TRANSFER.this.avg_state_size = (double)STREAMING_STATE_TRANSFER.this.num_bytes_sent.addAndGet(this.bytesWrittenCounter) / STREAMING_STATE_TRANSFER.this.num_state_reqs.doubleValue();
                }
                super.close();
            }
        }

        public void write(byte[] b, int off, int len) throws IOException {
            if (this.closed.get()) {
                throw this.closed();
            }
            this.sendMessage(b, off, len);
        }

        public void write(byte[] b) throws IOException {
            if (this.closed.get()) {
                throw this.closed();
            }
            this.sendMessage(b, 0, b.length);
        }

        public void write(int b) throws IOException {
            if (this.closed.get()) {
                throw this.closed();
            }
            byte[] buf = new byte[]{(byte)b};
            this.write(buf);
        }

        private void sendMessage(byte[] b, int off, int len) throws IOException {
            Message m = new Message(this.stateRequester);
            m.putHeader(STREAMING_STATE_TRANSFER.this.getName(), new StateHeader(3, STREAMING_STATE_TRANSFER.this.local_addr, this.state_id));
            m.setBuffer(b, off, len);
            this.bytesWrittenCounter += (long)(len - off);
            if (Thread.interrupted()) {
                throw this.interrupted((int)this.bytesWrittenCounter);
            }
            STREAMING_STATE_TRANSFER.this.down_prot.down(new Event(1, m));
            if (STREAMING_STATE_TRANSFER.this.log.isDebugEnabled()) {
                STREAMING_STATE_TRANSFER.this.log.debug(STREAMING_STATE_TRANSFER.this.local_addr + " sent chunk of state to " + this.stateRequester + "byte[] b=" + b.length + ", off=" + off + ", len=" + len);
            }
        }

        private IOException closed() {
            return new IOException("The output stream is closed");
        }

        private InterruptedIOException interrupted(int cnt) {
            InterruptedIOException ex = new InterruptedIOException();
            ex.bytesTransferred = cnt;
            return ex;
        }
    }

    private class StateInputStream
    extends InputStream {
        private final AtomicBoolean closed = new AtomicBoolean(false);

        public void close() throws IOException {
            if (this.closed.compareAndSet(false, true)) {
                if (STREAMING_STATE_TRANSFER.this.log.isDebugEnabled()) {
                    STREAMING_STATE_TRANSFER.this.log.debug("State reader is closing the stream");
                }
                STREAMING_STATE_TRANSFER.this.stateQueue.clear();
                STREAMING_STATE_TRANSFER.this.up(new Event(73));
                STREAMING_STATE_TRANSFER.this.down(new Event(73));
                super.close();
            }
        }

        public int read() throws IOException {
            if (this.closed.get()) {
                return -1;
            }
            byte[] array = new byte[1];
            return this.read(array) == -1 ? -1 : array[0];
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (this.closed.get()) {
                return -1;
            }
            Message m = null;
            try {
                m = (Message)STREAMING_STATE_TRANSFER.this.stateQueue.take();
                StateHeader hdr = (StateHeader)m.getHeader(STREAMING_STATE_TRANSFER.this.getName());
                if (hdr.type == 3) {
                    return this.readAndTransferPayload(m, b, off, len);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new InterruptedIOException();
            }
            return -1;
        }

        private int readAndTransferPayload(Message m, byte[] b, int off, int len) {
            byte[] buffer = m.getBuffer();
            if (STREAMING_STATE_TRANSFER.this.log.isDebugEnabled()) {
                STREAMING_STATE_TRANSFER.this.log.debug(STREAMING_STATE_TRANSFER.this.local_addr + " reading chunk of state  " + "byte[] b=" + b.length + ", off=" + off + ", buffer.length=" + buffer.length);
            }
            System.arraycopy(buffer, 0, b, off, buffer.length);
            return buffer.length;
        }

        public int read(byte[] b) throws IOException {
            if (this.closed.get()) {
                return -1;
            }
            return this.read(b, 0, b.length);
        }
    }

    private class StreamingOutputStreamWrapper
    extends FilterOutputStream {
        private final Socket outputStreamOwner;
        private final AtomicBoolean closed;
        private long bytesWrittenCounter;

        public StreamingOutputStreamWrapper(Socket outputStreamOwner) throws IOException {
            super(outputStreamOwner.getOutputStream());
            this.closed = new AtomicBoolean(false);
            this.bytesWrittenCounter = 0L;
            this.outputStreamOwner = outputStreamOwner;
        }

        public void close() throws IOException {
            if (this.closed.compareAndSet(false, true)) {
                if (STREAMING_STATE_TRANSFER.this.log.isDebugEnabled()) {
                    STREAMING_STATE_TRANSFER.this.log.debug("State writer is closing the socket ");
                }
                Util.close(this.outputStreamOwner);
                STREAMING_STATE_TRANSFER.this.up(new Event(74));
                STREAMING_STATE_TRANSFER.this.down(new Event(74));
                if (STREAMING_STATE_TRANSFER.this.stats) {
                    STREAMING_STATE_TRANSFER.this.avg_state_size = (double)STREAMING_STATE_TRANSFER.this.num_bytes_sent.addAndGet(this.bytesWrittenCounter) / STREAMING_STATE_TRANSFER.this.num_state_reqs.doubleValue();
                }
                super.close();
            }
        }

        public void write(byte[] b, int off, int len) throws IOException {
            super.write(b, off, len);
            this.bytesWrittenCounter += (long)len;
        }

        public void write(byte[] b) throws IOException {
            super.write(b);
            this.bytesWrittenCounter += (long)b.length;
        }

        public void write(int b) throws IOException {
            super.write(b);
            ++this.bytesWrittenCounter;
        }
    }

    private class StreamingInputStreamWrapper
    extends FilterInputStream {
        private final Socket inputStreamOwner;
        private final AtomicBoolean closed;

        public StreamingInputStreamWrapper(Socket inputStreamOwner) throws IOException {
            super(inputStreamOwner.getInputStream());
            this.closed = new AtomicBoolean(false);
            this.inputStreamOwner = inputStreamOwner;
        }

        public void close() throws IOException {
            if (this.closed.compareAndSet(false, true)) {
                if (STREAMING_STATE_TRANSFER.this.log.isDebugEnabled()) {
                    STREAMING_STATE_TRANSFER.this.log.debug("State reader is closing the socket ");
                }
                Util.close(this.inputStreamOwner);
                STREAMING_STATE_TRANSFER.this.up(new Event(73));
                STREAMING_STATE_TRANSFER.this.down(new Event(73));
            }
            super.close();
        }
    }

    private class StateProviderHandler {
        private StateProviderHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void process(Socket socket) {
            BufferedOutputStream bos;
            block11: {
                bos = null;
                ObjectInputStream ois = null;
                try {
                    try {
                        int bufferSize = socket.getSendBufferSize();
                        socket.setSendBufferSize(STREAMING_STATE_TRANSFER.this.socket_buffer_size);
                        if (STREAMING_STATE_TRANSFER.this.log.isDebugEnabled()) {
                            STREAMING_STATE_TRANSFER.this.log.debug("Running on " + Thread.currentThread() + ". Accepted request for state transfer from " + socket.getInetAddress() + ":" + socket.getPort() + ", original buffer size was " + bufferSize + " and was reset to " + socket.getSendBufferSize() + ", passing outputstream up... ");
                        }
                        ois = new ObjectInputStream(socket.getInputStream());
                        String state_id = (String)ois.readObject();
                        Address stateRequester = (Address)ois.readObject();
                        bos = new BufferedOutputStream(new StreamingOutputStreamWrapper(socket), STREAMING_STATE_TRANSFER.this.socket_buffer_size);
                        STREAMING_STATE_TRANSFER.this.up_prot.up(new Event(72, new StateTransferInfo(stateRequester, bos, state_id)));
                    }
                    catch (IOException e) {
                        if (STREAMING_STATE_TRANSFER.this.log.isWarnEnabled()) {
                            STREAMING_STATE_TRANSFER.this.log.warn("State writer socket thread spawned abnormaly", e);
                        }
                        Object var8_10 = null;
                        if (!socket.isConnected() && STREAMING_STATE_TRANSFER.this.log.isWarnEnabled()) {
                            STREAMING_STATE_TRANSFER.this.log.warn("Could not receive connection from state receiver. Closing socket...");
                        }
                        Util.close(bos);
                        Util.close(socket);
                        return;
                    }
                    catch (ClassNotFoundException e) {
                        Object var8_11 = null;
                        if (!socket.isConnected() && STREAMING_STATE_TRANSFER.this.log.isWarnEnabled()) {
                            STREAMING_STATE_TRANSFER.this.log.warn("Could not receive connection from state receiver. Closing socket...");
                        }
                        Util.close(bos);
                        Util.close(socket);
                        return;
                    }
                    Object var8_9 = null;
                    if (socket.isConnected() || !STREAMING_STATE_TRANSFER.this.log.isWarnEnabled()) break block11;
                    STREAMING_STATE_TRANSFER.this.log.warn("Could not receive connection from state receiver. Closing socket...");
                }
                catch (Throwable throwable) {
                    Object var8_12 = null;
                    if (!socket.isConnected() && STREAMING_STATE_TRANSFER.this.log.isWarnEnabled()) {
                        STREAMING_STATE_TRANSFER.this.log.warn("Could not receive connection from state receiver. Closing socket...");
                    }
                    Util.close(bos);
                    Util.close(socket);
                    throw throwable;
                }
            }
            Util.close(bos);
            Util.close(socket);
        }
    }

    private class StateProviderThreadSpawner
    implements Runnable {
        private final ExecutorService pool;
        private final ServerSocket serverSocket;
        private final IpAddress address;
        Thread runner;
        private volatile boolean running = true;

        public StateProviderThreadSpawner(ExecutorService pool, ServerSocket stateServingSocket) {
            this.pool = pool;
            this.serverSocket = stateServingSocket;
            this.address = new IpAddress(STREAMING_STATE_TRANSFER.this.bind_addr, this.serverSocket.getLocalPort());
        }

        public void run() {
            this.runner = Thread.currentThread();
            while (this.running) {
                try {
                    if (STREAMING_STATE_TRANSFER.this.log.isDebugEnabled()) {
                        STREAMING_STATE_TRANSFER.this.log.debug("StateProviderThreadSpawner listening at " + this.getServerSocketAddress() + "...");
                    }
                    final Socket socket = this.serverSocket.accept();
                    this.pool.execute(new Runnable(){

                        public void run() {
                            if (STREAMING_STATE_TRANSFER.this.log.isDebugEnabled()) {
                                STREAMING_STATE_TRANSFER.this.log.debug("Accepted request for state transfer from " + socket.getInetAddress() + ":" + socket.getPort() + " handing of to PooledExecutor thread");
                            }
                            new StateProviderHandler().process(socket);
                        }
                    });
                }
                catch (IOException e) {
                    if (!STREAMING_STATE_TRANSFER.this.log.isWarnEnabled() || this.serverSocket == null || this.serverSocket.isClosed()) continue;
                    STREAMING_STATE_TRANSFER.this.log.warn("Spawning socket from server socket finished abnormaly", e);
                }
            }
        }

        public IpAddress getServerSocketAddress() {
            return this.address;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void stop() {
            block23: {
                InterruptedException ignored2;
                block21: {
                    this.running = false;
                    this.serverSocket.close();
                    Object var3_1 = null;
                    if (STREAMING_STATE_TRANSFER.this.log.isDebugEnabled()) {
                        STREAMING_STATE_TRANSFER.this.log.debug("Waiting for StateProviderThreadSpawner to die ... ");
                    }
                    if (this.runner == null) break block21;
                    try {
                        this.runner.join(300L);
                    }
                    catch (InterruptedException ignored2) {
                        Thread.currentThread().interrupt();
                    }
                }
                if (STREAMING_STATE_TRANSFER.this.log.isDebugEnabled()) {
                    STREAMING_STATE_TRANSFER.this.log.debug("Shutting the thread pool down... ");
                }
                this.pool.shutdownNow();
                try {
                    this.pool.awaitTermination(3000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException ignored2) {
                    Thread.currentThread().interrupt();
                }
                break block23;
                {
                    catch (Exception exception) {
                        Object var3_2 = null;
                        if (STREAMING_STATE_TRANSFER.this.log.isDebugEnabled()) {
                            STREAMING_STATE_TRANSFER.this.log.debug("Waiting for StateProviderThreadSpawner to die ... ");
                        }
                        if (this.runner != null) {
                            try {
                                this.runner.join(300L);
                            }
                            catch (InterruptedException ignored2) {
                                Thread.currentThread().interrupt();
                            }
                        }
                        if (STREAMING_STATE_TRANSFER.this.log.isDebugEnabled()) {
                            STREAMING_STATE_TRANSFER.this.log.debug("Shutting the thread pool down... ");
                        }
                        this.pool.shutdownNow();
                        try {
                            this.pool.awaitTermination(3000L, TimeUnit.MILLISECONDS);
                        }
                        catch (InterruptedException ignored2) {
                            Thread.currentThread().interrupt();
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    if (STREAMING_STATE_TRANSFER.this.log.isDebugEnabled()) {
                        STREAMING_STATE_TRANSFER.this.log.debug("Waiting for StateProviderThreadSpawner to die ... ");
                    }
                    if (this.runner != null) {
                        try {
                            this.runner.join(300L);
                        }
                        catch (InterruptedException ignored2) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    if (STREAMING_STATE_TRANSFER.this.log.isDebugEnabled()) {
                        STREAMING_STATE_TRANSFER.this.log.debug("Shutting the thread pool down... ");
                    }
                    this.pool.shutdownNow();
                    try {
                        this.pool.awaitTermination(3000L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException ignored2) {
                        Thread.currentThread().interrupt();
                    }
                    throw throwable;
                }
            }
            if (STREAMING_STATE_TRANSFER.this.log.isDebugEnabled()) {
                STREAMING_STATE_TRANSFER.this.log.debug("Thread pool is shutdown. All pool threads are cleaned up.");
            }
        }
    }
}

