/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.jmx;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.DynamicMBean;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ReflectionException;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceDMBean
implements DynamicMBean {
    private static final Class<?>[] primitives = new Class[]{Integer.TYPE, Byte.TYPE, Short.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Boolean.TYPE, Character.TYPE};
    private static final String MBEAN_DESCRITION = "Dynamic MBean Description";
    private final Log log = LogFactory.getLog(ResourceDMBean.class);
    private final Object obj;
    private String description = "";
    private final MBeanAttributeInfo[] attrInfo;
    private final MBeanOperationInfo[] opInfo;
    private final HashMap<String, AttributeEntry> atts = new HashMap();
    private final List<MBeanOperationInfo> ops = new ArrayList<MBeanOperationInfo>();

    public ResourceDMBean(Object instance) {
        if (instance == null) {
            throw new NullPointerException("Cannot make an MBean wrapper for null instance");
        }
        this.obj = instance;
        this.findDescription();
        this.findFields();
        this.findMethods();
        this.attrInfo = new MBeanAttributeInfo[this.atts.size()];
        int i = 0;
        MBeanAttributeInfo info = null;
        for (AttributeEntry entry : this.atts.values()) {
            info = entry.getInfo();
            this.attrInfo[i++] = info;
        }
        this.opInfo = new MBeanOperationInfo[this.ops.size()];
        this.ops.toArray(this.opInfo);
    }

    Object getObject() {
        return this.obj;
    }

    private void findDescription() {
        MBean mbean = this.getObject().getClass().getAnnotation(MBean.class);
        if (mbean != null && mbean.description() != null && mbean.description().trim().length() > 0) {
            this.description = mbean.description();
            MBeanAttributeInfo info = new MBeanAttributeInfo(MBEAN_DESCRITION, "java.lang.String", "MBean description", true, false, false);
            try {
                this.atts.put(MBEAN_DESCRITION, new FieldAttributeEntry(info, this.getClass().getDeclaredField("description")));
            }
            catch (NoSuchFieldException e) {
                this.log.warn("Could not reflect field description of this class. Was it removed?");
            }
        }
    }

    @Override
    public synchronized MBeanInfo getMBeanInfo() {
        return new MBeanInfo(this.getObject().getClass().getCanonicalName(), this.description, this.attrInfo, null, this.opInfo, null);
    }

    @Override
    public synchronized Object getAttribute(String name) {
        if (name == null || name.length() == 0) {
            throw new NullPointerException("Invalid attribute requested " + name);
        }
        Attribute attr = this.getNamedAttribute(name);
        return attr.getValue();
    }

    @Override
    public synchronized void setAttribute(Attribute attribute) {
        if (attribute == null || attribute.getName() == null) {
            throw new NullPointerException("Invalid attribute requested " + attribute);
        }
        this.setNamedAttribute(attribute);
    }

    @Override
    public synchronized AttributeList getAttributes(String[] names) {
        AttributeList al = new AttributeList();
        for (String name : names) {
            Attribute attr = this.getNamedAttribute(name);
            if (attr != null) {
                al.add(attr);
                continue;
            }
            this.log.warn("Did not find attribute " + name);
        }
        return al;
    }

    @Override
    public synchronized AttributeList setAttributes(AttributeList list) {
        AttributeList results = new AttributeList();
        for (int i = 0; i < list.size(); ++i) {
            Attribute attr = (Attribute)list.get(i);
            if (this.setNamedAttribute(attr)) {
                results.add(attr);
                continue;
            }
            if (!this.log.isWarnEnabled()) continue;
            this.log.warn("Failed to update attribute name " + attr.getName() + " with value " + attr.getValue());
        }
        return results;
    }

    @Override
    public Object invoke(String name, Object[] args, String[] sig) throws MBeanException, ReflectionException {
        try {
            Class[] classes = new Class[sig.length];
            for (int i = 0; i < classes.length; ++i) {
                classes[i] = ResourceDMBean.getClassForName(sig[i]);
            }
            Method method = this.getObject().getClass().getMethod(name, classes);
            return method.invoke(this.getObject(), args);
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
    }

    public static Class<?> getClassForName(String name) throws ClassNotFoundException {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException cnfe) {
            for (int i = 0; i < primitives.length; ++i) {
                if (!name.equals(primitives[i].getName())) continue;
                return primitives[i];
            }
            throw new ClassNotFoundException("Class " + name + " cannot be found");
        }
    }

    private void findMethods() {
        ArrayList<Method> methods = new ArrayList<Method>(Arrays.asList(this.getObject().getClass().getMethods()));
        ArrayList<Method> objectMethods = new ArrayList<Method>(Arrays.asList(Object.class.getMethods()));
        methods.removeAll(objectMethods);
        for (Method method : methods) {
            if (method.isAnnotationPresent(ManagedAttribute.class) || method.isAnnotationPresent(Property.class)) {
                this.exposeManagedAttribute(method);
                continue;
            }
            if (!method.isAnnotationPresent(ManagedOperation.class) && !this.isMBeanAnnotationPresentWithExposeAll()) continue;
            this.exposeManagedOperation(method);
        }
    }

    private void exposeManagedOperation(Method method) {
        ManagedOperation op = method.getAnnotation(ManagedOperation.class);
        String attName = method.getName();
        if (ResourceDMBean.isSetMethod(method) || ResourceDMBean.isGetMethod(method)) {
            attName = attName.substring(3);
        } else if (ResourceDMBean.isIsMethod(method)) {
            attName = attName.substring(2);
        }
        boolean isAlreadyExposed = this.atts.containsKey(attName);
        if (!isAlreadyExposed) {
            this.ops.add(new MBeanOperationInfo(op != null ? op.description() : "", method));
        }
    }

    private void exposeManagedAttribute(Method method) {
        boolean expose;
        String methodName = method.getName();
        if (!(methodName.startsWith("get") || methodName.startsWith("set") || methodName.startsWith("is"))) {
            if (this.log.isWarnEnabled()) {
                this.log.warn("method name " + methodName + " doesn't start with \"get\", \"set\", or \"is\"" + ", but is annotated with @ManagedAttribute: will be ignored");
            }
            return;
        }
        ManagedAttribute attr = method.getAnnotation(ManagedAttribute.class);
        Property prop = method.getAnnotation(Property.class);
        boolean expose_prop = prop != null && prop.exposeAsManagedAttribute();
        boolean bl = expose = attr != null || expose_prop;
        if (!expose) {
            return;
        }
        String attributeName = attr != null ? attr.name() : null;
        attributeName = attributeName != null && attributeName.trim().length() > 0 ? attributeName.trim() : null;
        String descr = attr != null ? attr.description() : (prop != null ? prop.description() : null);
        boolean writeAttribute = false;
        MBeanAttributeInfo info = null;
        if (ResourceDMBean.isSetMethod(method)) {
            attributeName = attributeName == null ? methodName.substring(3) : attributeName;
            info = new MBeanAttributeInfo(attributeName, method.getParameterTypes()[0].getCanonicalName(), descr, true, true, false);
            writeAttribute = true;
        } else if (method.getParameterTypes().length == 0 && method.getReturnType() != Void.TYPE) {
            boolean hasSetter = this.atts.containsKey(attributeName);
            if (methodName.startsWith("is")) {
                attributeName = attributeName == null ? methodName.substring(2) : attributeName;
                info = new MBeanAttributeInfo(attributeName, method.getReturnType().getCanonicalName(), descr, true, hasSetter, true);
            } else {
                attributeName = attributeName == null ? methodName.substring(3) : attributeName;
                info = new MBeanAttributeInfo(attributeName, method.getReturnType().getCanonicalName(), descr, true, hasSetter, false);
            }
        } else {
            if (this.log.isWarnEnabled()) {
                this.log.warn("Method " + method.getName() + " must have a valid return type and zero parameters");
            }
            return;
        }
        AttributeEntry ae = this.atts.get(attributeName);
        if (!writeAttribute) {
            if (ae instanceof FieldAttributeEntry && ae.getInfo().isReadable()) {
                this.log.warn("not adding annotated method " + method + " since we already have read attribute");
            } else if (ae instanceof MethodAttributeEntry) {
                MethodAttributeEntry mae = (MethodAttributeEntry)ae;
                if (mae.hasSetMethod()) {
                    this.atts.put(attributeName, new MethodAttributeEntry(mae.getInfo(), mae.getSetMethod(), method));
                }
            } else {
                this.atts.put(attributeName, new MethodAttributeEntry(info, ResourceDMBean.findSetter(this.obj.getClass(), attributeName), method));
            }
        } else if (ae instanceof FieldAttributeEntry) {
            if (ae.getInfo().isWritable()) {
                this.log.warn("Not adding annotated method " + methodName + " since we already have writable attribute");
            } else {
                Field f = ((FieldAttributeEntry)ae).getField();
                MBeanAttributeInfo i = new MBeanAttributeInfo(ae.getInfo().getName(), f.getType().getCanonicalName(), descr, true, !Modifier.isFinal(f.getModifiers()), false);
                this.atts.put(attributeName, new FieldAttributeEntry(i, f));
            }
        } else if (ae instanceof MethodAttributeEntry) {
            MethodAttributeEntry mae = (MethodAttributeEntry)ae;
            if (mae.hasIsOrGetMethod()) {
                this.atts.put(attributeName, new MethodAttributeEntry(info, method, mae.getIsOrGetMethod()));
            }
        } else {
            this.atts.put(attributeName, new MethodAttributeEntry(info, method, ResourceDMBean.findGetter(this.obj.getClass(), attributeName)));
        }
    }

    private static boolean isSetMethod(Method method) {
        return method.getName().startsWith("set") && method.getParameterTypes().length == 1 && method.getReturnType() == Void.TYPE;
    }

    private static boolean isGetMethod(Method method) {
        return method.getParameterTypes().length == 0 && method.getReturnType() != Void.TYPE && method.getName().startsWith("get");
    }

    private static boolean isIsMethod(Method method) {
        return method.getParameterTypes().length == 0 && (method.getReturnType() == Boolean.TYPE || method.getReturnType() == Boolean.class) && method.getName().startsWith("is");
    }

    public static Method findGetter(Class clazz, String name) {
        try {
            return clazz.getMethod("get" + name, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            try {
                return clazz.getMethod("is" + name, new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return null;
            }
        }
    }

    public static Method findSetter(Class clazz, String name) {
        try {
            return clazz.getMethod("set" + name, new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private void findFields() {
        for (Class<?> clazz = this.getObject().getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                boolean expose;
                ManagedAttribute attr = field.getAnnotation(ManagedAttribute.class);
                Property prop = field.getAnnotation(Property.class);
                boolean expose_prop = prop != null && prop.exposeAsManagedAttribute();
                boolean bl = expose = attr != null || expose_prop;
                if (!expose) continue;
                String fieldName = Util.attributeNameToMethodName(field.getName());
                String descr = attr != null ? attr.description() : prop.description();
                boolean writable = attr != null ? attr.writable() : prop.writable();
                MBeanAttributeInfo info = new MBeanAttributeInfo(fieldName, field.getType().getCanonicalName(), descr, true, !Modifier.isFinal(field.getModifiers()) && writable, false);
                this.atts.put(fieldName, new FieldAttributeEntry(info, field));
            }
        }
    }

    private Attribute getNamedAttribute(String name) {
        Attribute result = null;
        if (name.equals(MBEAN_DESCRITION)) {
            result = new Attribute(MBEAN_DESCRITION, this.description);
        } else {
            AttributeEntry entry = this.atts.get(name);
            if (entry != null) {
                try {
                    result = new Attribute(name, entry.invoke(null));
                }
                catch (Exception e) {
                    this.log.warn("Exception while reading value of attribute " + name, e);
                }
            } else {
                this.log.warn("Did not find queried attribute with name " + name);
            }
        }
        return result;
    }

    private boolean setNamedAttribute(Attribute attribute) {
        boolean result = false;
        AttributeEntry entry = this.atts.get(attribute.getName());
        if (entry != null) {
            try {
                entry.invoke(attribute);
                result = true;
            }
            catch (Exception e) {
                this.log.warn("Exception while writing value for attribute " + attribute.getName(), e);
            }
        } else {
            this.log.warn("Could not invoke set on attribute " + attribute.getName() + " with value " + attribute.getValue());
        }
        return result;
    }

    private boolean isMBeanAnnotationPresentWithExposeAll() {
        Class<?> c = this.getObject().getClass();
        return c.isAnnotationPresent(MBean.class) && c.getAnnotation(MBean.class).exposeAll();
    }

    private static interface AttributeEntry {
        public Object invoke(Attribute var1) throws Exception;

        public MBeanAttributeInfo getInfo();
    }

    private class FieldAttributeEntry
    implements AttributeEntry {
        private final MBeanAttributeInfo info;
        private final Field field;

        public FieldAttributeEntry(MBeanAttributeInfo info, Field field) {
            this.info = info;
            this.field = field;
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
        }

        public Field getField() {
            return this.field;
        }

        public Object invoke(Attribute a) throws Exception {
            if (a == null) {
                return this.field.get(ResourceDMBean.this.getObject());
            }
            this.field.set(ResourceDMBean.this.getObject(), a.getValue());
            return null;
        }

        public MBeanAttributeInfo getInfo() {
            return this.info;
        }
    }

    private class MethodAttributeEntry
    implements AttributeEntry {
        final MBeanAttributeInfo info;
        final Method isOrGetmethod;
        final Method setMethod;

        public MethodAttributeEntry(MBeanAttributeInfo info, Method setMethod, Method isOrGetMethod) {
            this.info = info;
            this.setMethod = setMethod;
            this.isOrGetmethod = isOrGetMethod;
        }

        public Object invoke(Attribute a) throws Exception {
            if (a == null && this.isOrGetmethod != null) {
                return this.isOrGetmethod.invoke(ResourceDMBean.this.getObject(), new Object[0]);
            }
            if (a != null && this.setMethod != null) {
                return this.setMethod.invoke(ResourceDMBean.this.getObject(), a.getValue());
            }
            return null;
        }

        public MBeanAttributeInfo getInfo() {
            return this.info;
        }

        public boolean hasIsOrGetMethod() {
            return this.isOrGetmethod != null;
        }

        public boolean hasSetMethod() {
            return this.setMethod != null;
        }

        public Method getIsOrGetMethod() {
            return this.isOrGetmethod;
        }

        public Method getSetMethod() {
            return this.setMethod;
        }
    }
}

