/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.ClosedSelectorException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.blocks.PartitionedHashMap;
import org.jgroups.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemcachedConnector
implements Runnable {
    @ManagedAttribute(writable=false)
    private int port = 11211;
    @ManagedAttribute(writable=false)
    private InetAddress bind_addr = null;
    private PartitionedHashMap<String, byte[]> cache = null;
    private Thread thread = null;
    private ServerSocket srv_sock;
    @ManagedAttribute(writable=true)
    private int core_threads = 1;
    @ManagedAttribute(writable=true)
    private int max_threads = 500;
    @ManagedAttribute(writable=true)
    private long idle_time = 5000L;
    private Executor thread_pool;
    private long start_time;
    private final byte[] STORED = "STORED\r\n".getBytes();
    private final byte[] DELETED = "DELETED\r\n".getBytes();
    private final byte[] END = "END\r\n".getBytes();
    private final byte[] RN = "\r\n".getBytes();

    public MemcachedConnector(InetAddress bind_addr, int port, PartitionedHashMap<String, byte[]> cache) {
        this.bind_addr = bind_addr;
        this.cache = cache;
        this.port = port;
    }

    public InetAddress getBindAddress() {
        return this.bind_addr;
    }

    public void setBindAddress(InetAddress bind_addr) {
        this.bind_addr = bind_addr;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public PartitionedHashMap<String, byte[]> getCache() {
        return this.cache;
    }

    public void setCache(PartitionedHashMap<String, byte[]> cache) {
        this.cache = cache;
    }

    public int getThreadPoolCoreThreads() {
        return this.core_threads;
    }

    public void setThreadPoolCoreThreads(int core_threads) {
        this.core_threads = core_threads;
    }

    public int getThreadPoolMaxThreads() {
        return this.max_threads;
    }

    public void setThreadPoolMaxThreads(int max_threads) {
        this.max_threads = max_threads;
    }

    public long getThreadPoolIdleTime() {
        return this.idle_time;
    }

    public void setThreadPoolIdleTime(long idle_time) {
        this.idle_time = idle_time;
    }

    public Executor getThreadPool() {
        return this.thread_pool;
    }

    public void setThreadPool(Executor thread_pool) {
        if (this.thread_pool instanceof ExecutorService) {
            ((ExecutorService)thread_pool).shutdown();
        }
        this.thread_pool = thread_pool;
    }

    public Map<String, Object> getStats() {
        HashMap<String, Object> stats = new HashMap<String, Object>();
        stats.put("time", System.currentTimeMillis());
        stats.put("uptime", (System.currentTimeMillis() - this.start_time) / 1000L);
        return stats;
    }

    @ManagedOperation
    public void start() throws IOException, MalformedObjectNameException, MBeanRegistrationException {
        this.srv_sock = new ServerSocket(this.port, 50, this.bind_addr);
        if (this.thread_pool == null) {
            this.thread_pool = new ThreadPoolExecutor(this.core_threads, this.max_threads, this.idle_time, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), new ThreadPoolExecutor.CallerRunsPolicy());
        }
        if (this.thread == null || !this.thread.isAlive()) {
            this.thread = new Thread((Runnable)this, "Acceptor");
            this.thread.start();
        }
        this.start_time = System.currentTimeMillis();
    }

    @ManagedOperation
    public void stop() throws IOException {
        Util.close(this.srv_sock);
        this.thread = null;
        if (this.thread_pool instanceof ExecutorService) {
            ((ExecutorService)this.thread_pool).shutdown();
        }
    }

    @Override
    public void run() {
        System.out.println("MemcachedConnector listening on " + this.srv_sock.getLocalSocketAddress());
        while (this.thread != null && Thread.currentThread().equals(this.thread)) {
            Socket client_sock = null;
            try {
                client_sock = this.srv_sock.accept();
                RequestHandler handler = new RequestHandler(client_sock);
                this.thread_pool.execute(handler);
            }
            catch (ClosedSelectorException closed) {
                Util.close(client_sock);
                break;
            }
            catch (Throwable throwable) {
            }
        }
    }

    public static class Request {
        Type type;
        String key;
        List<String> keys = null;
        long caching_time;
        int number_of_bytes = 0;

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append((Object)((Object)this.type) + ": ");
            if (this.key != null) {
                sb.append("key=" + this.key);
            } else if (this.keys != null && !this.keys.isEmpty()) {
                sb.append("keys=" + this.keys);
            }
            sb.append(", caching_time=" + this.caching_time + ", number_of_bytes=" + this.number_of_bytes);
            return sb.toString();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Type {
            SET,
            ADD,
            REPLACE,
            PREPEND,
            APPEND,
            CAS,
            INCR,
            DECR,
            GET,
            GETS,
            DELETE,
            STAT,
            STATS;

        }
    }

    private class RequestHandler
    implements Runnable {
        private final Socket client_sock;
        private final InputStream input;
        private final OutputStream output;

        public RequestHandler(Socket client_sock) throws IOException {
            this.client_sock = client_sock;
            this.input = new BufferedInputStream(client_sock.getInputStream());
            this.output = new BufferedOutputStream(client_sock.getOutputStream());
        }

        public void run() {
            while (this.client_sock.isConnected()) {
                try {
                    Request req;
                    String line = Util.readLine(this.input);
                    if (line == null || (req = this.parseRequest(line)) == null) break;
                    switch (req.type) {
                        case SET: {
                            byte[] data = new byte[req.number_of_bytes];
                            int num = this.input.read(data, 0, data.length);
                            if (num == -1) {
                                throw new EOFException();
                            }
                            MemcachedConnector.this.cache.put(req.key, data, req.caching_time);
                            this.output.write(MemcachedConnector.this.STORED);
                            this.output.flush();
                            Util.discardUntilNewLine(this.input);
                            break;
                        }
                        case GET: 
                        case GETS: {
                            if (req.keys != null && !req.keys.isEmpty()) {
                                for (String key : req.keys) {
                                    byte[] val = (byte[])MemcachedConnector.this.cache.get(key);
                                    if (val == null) continue;
                                    int length = val.length;
                                    this.output.write(("VALUE " + key + " 0 " + length + "\r\n").getBytes());
                                    this.output.write(val, 0, length);
                                    this.output.write(MemcachedConnector.this.RN);
                                }
                            }
                            this.output.write(MemcachedConnector.this.END);
                            this.output.flush();
                            break;
                        }
                        case DELETE: {
                            MemcachedConnector.this.cache.remove(req.key);
                            this.output.write(MemcachedConnector.this.DELETED);
                            this.output.flush();
                            break;
                        }
                        case STATS: {
                            Map<String, Object> stats = MemcachedConnector.this.getStats();
                            StringBuilder sb = new StringBuilder();
                            for (Map.Entry<String, Object> entry : stats.entrySet()) {
                                sb.append("STAT ").append(entry.getKey()).append(" ").append(entry.getValue()).append("\r\n");
                            }
                            sb.append("END\r\n");
                            this.output.write(sb.toString().getBytes());
                            this.output.flush();
                        }
                    }
                }
                catch (StreamCorruptedException corrupted_ex) {
                    try {
                        this.output.write(("CLIENT_ERROR failed to parse request: " + corrupted_ex + ":\r\n").getBytes());
                        this.output.flush();
                    }
                    catch (IOException e) {}
                }
                catch (EOFException end_of_file_ex) {
                    break;
                }
                catch (Throwable throwable) {
                }
            }
            Util.close(this.client_sock);
        }

        private Request parseRequest(String line) throws IOException {
            Request req = new Request();
            String[] args = line.trim().split(" +");
            String tmp = args[0];
            if (tmp == null) {
                throw new EOFException();
            }
            if (tmp.equals("set")) {
                req.type = Request.Type.SET;
            } else if (tmp.equals("add")) {
                req.type = Request.Type.ADD;
            } else if (tmp.equals("replace")) {
                req.type = Request.Type.REPLACE;
            } else if (tmp.equals("prepend")) {
                req.type = Request.Type.PREPEND;
            } else if (tmp.equals("append")) {
                req.type = Request.Type.APPEND;
            } else if (tmp.equals("cas")) {
                req.type = Request.Type.CAS;
            } else if (tmp.equals("incr")) {
                req.type = Request.Type.INCR;
            } else if (tmp.equals("decr")) {
                req.type = Request.Type.DECR;
            } else if (tmp.equals("get")) {
                req.type = Request.Type.GET;
            } else if (tmp.equals("gets")) {
                req.type = Request.Type.GETS;
            } else if (tmp.equals("delete")) {
                req.type = Request.Type.DELETE;
            } else if (tmp.equals("stat")) {
                req.type = Request.Type.STAT;
            } else if (tmp.equals("stats")) {
                req.type = Request.Type.STATS;
            } else {
                throw new StreamCorruptedException("request \"" + line + "\" not known");
            }
            switch (req.type) {
                case SET: 
                case ADD: 
                case REPLACE: 
                case PREPEND: 
                case APPEND: {
                    tmp = args[1];
                    if (tmp == null) {
                        throw new EOFException();
                    }
                    req.key = tmp;
                    tmp = args[2];
                    if (tmp == null) {
                        throw new EOFException();
                    }
                    tmp = args[3];
                    if (tmp == null) {
                        throw new EOFException();
                    }
                    req.caching_time = Long.parseLong(tmp) * 1000L;
                    tmp = args[4];
                    if (tmp == null) {
                        throw new EOFException();
                    }
                    req.number_of_bytes = Integer.parseInt(tmp);
                    break;
                }
                case GET: 
                case GETS: {
                    req.keys = new ArrayList<String>(5);
                    req.keys.addAll(Arrays.asList(args).subList(1, args.length));
                    break;
                }
                case DELETE: {
                    tmp = args[1];
                    if (tmp == null) {
                        throw new EOFException();
                    }
                    req.key = tmp;
                    break;
                }
            }
            return req;
        }
    }
}

