/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.core.session;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.gcube.application.framework.accesslogger.library.impl.AccessLogger;
import org.gcube.application.framework.accesslogger.model.AccessLogEntry;
import org.gcube.application.framework.accesslogger.model.LoginToVreAccessLogEntry;
import org.gcube.application.framework.core.session.Notifier;
import org.gcube.application.framework.core.util.ASLGroupModel;
import org.gcube.application.framework.core.util.GenderType;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.scope.impl.ScopeBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class ASLSession {
    private static final long serialVersionUID = 1L;
    private HashMap<String, Object> innerSession;
    private long lastUsedTime;
    private String externalSessionID;
    private String username;
    private String parentScope;
    private String scope;
    private String securityToken;
    private HashMap<String, Notifier> notifiers;
    String scopeName;
    private ASLGroupModel groupModel;
    private boolean loggedIn = false;
    private String userEmailAddress;
    private String fullName;
    private String avatarId;
    private GenderType gender;
    private long sessionTimeout = -1L;
    private static final Logger logger = LoggerFactory.getLogger(ASLSession.class);
    AccessLogger accessLogger = AccessLogger.getAccessLogger();

    ASLSession(String externalSessionId, String user) {
        this.innerSession = new HashMap();
        this.notifiers = new HashMap();
        this.lastUsedTime = System.currentTimeMillis();
        this.username = user;
        this.externalSessionID = externalSessionId;
        this.groupModel = new ASLGroupModel();
    }

    private void initializeAttributes() {
        for (String key : this.innerSession.keySet()) {
            if (!key.equals("collectionsPresentableFields") && !key.equals("collectionsHierarchy")) continue;
            this.innerSession.remove(key);
            break;
        }
    }

    public long getSessionTimeoutMillis() throws IOException, ParserConfigurationException {
        int timeoutMins;
        if (this.sessionTimeout > 0L) {
            return this.sessionTimeout;
        }
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = null;
        try {
            dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e1) {
            e1.printStackTrace();
        }
        String tomcatBasePath = System.getProperty("catalina.base");
        String fullFilePath = tomcatBasePath + "/webapps/ROOT/WEB-INF/web.xml";
        Document webXMLDoc = null;
        try {
            File webXML = new File(fullFilePath);
            webXMLDoc = dBuilder.parse(webXML);
            webXMLDoc.getDocumentElement().normalize();
            NodeList sessionTimeouts = webXMLDoc.getElementsByTagName("session-timeout");
            String timeoutString = sessionTimeouts.item(0).getTextContent();
            if (timeoutString == null || timeoutString == "") {
                logger.debug("No property session-timeout in file, setting it to default");
                timeoutMins = 30;
            } else {
                timeoutMins = Integer.parseInt(timeoutString) + 5;
            }
        }
        catch (Exception e) {
            logger.debug("Could not parse file " + fullFilePath + " for session-timeout property. Parsing from jar.");
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                URL url = classLoader.getResource("/properties.xml");
                webXMLDoc = dBuilder.parse(new File(url.toURI()));
                webXMLDoc.getDocumentElement().normalize();
                NodeList sessionTimeouts = webXMLDoc.getElementsByTagName("session-timeout");
                String timeoutString = sessionTimeouts.item(0).getTextContent();
                if (timeoutString == null || timeoutString == "") {
                    logger.debug("No property session-timeout in local file, setting it to default");
                    timeoutMins = 30;
                } else {
                    timeoutMins = Integer.parseInt(timeoutString);
                }
            }
            catch (Exception e1) {
                logger.debug("Could not parse file properties.xml for property. Setting it to default.");
                timeoutMins = 30;
            }
        }
        this.sessionTimeout = timeoutMins * 60000;
        logger.info("Session Timeout is: " + this.sessionTimeout);
        return this.sessionTimeout;
    }

    public long increaseSessionTimeout(long milliseconds, boolean resetCounting) {
        if (resetCounting) {
            this.lastUsedTime = System.currentTimeMillis();
        }
        this.sessionTimeout += milliseconds;
        return this.sessionTimeout;
    }

    public boolean isValid() {
        long maxTime = -1L;
        try {
            maxTime = this.getSessionTimeoutMillis();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return System.currentTimeMillis() - this.lastUsedTime <= maxTime;
    }

    public boolean isEmpty() {
        this.lastUsedTime = System.currentTimeMillis();
        return this.innerSession.isEmpty();
    }

    public boolean hasAttribute(String name) {
        this.lastUsedTime = System.currentTimeMillis();
        return this.innerSession.containsKey(name);
    }

    public Set<String> getAttributeNames() {
        this.lastUsedTime = System.currentTimeMillis();
        return this.innerSession.keySet();
    }

    public Object getAttribute(String name) {
        this.lastUsedTime = System.currentTimeMillis();
        return this.innerSession.get(name);
    }

    public void setAttribute(String name, Object value) {
        this.lastUsedTime = System.currentTimeMillis();
        this.innerSession.put(name, value);
    }

    public String getOriginalScopeName() {
        return this.scopeName;
    }

    public Object removeAttribute(String name) {
        this.lastUsedTime = System.currentTimeMillis();
        return this.innerSession.remove(name);
    }

    public void removeAll() {
        this.lastUsedTime = System.currentTimeMillis();
        this.innerSession.clear();
    }

    public String getParentScope() {
        ScopeBean bean = new ScopeBean(this.getScope());
        this.parentScope = bean.enclosingScope().toString();
        return this.parentScope;
    }

    public void invalidate() {
        long maxTime = -1L;
        try {
            maxTime = this.getSessionTimeoutMillis();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.lastUsedTime = System.currentTimeMillis() - maxTime - 120000L;
    }

    public String getExternalSessionID() {
        return this.externalSessionID;
    }

    public String getUsername() {
        return this.username;
    }

    public String getScope() {
        if (this.scope == null) {
            logger.debug("Scope is null, returning null");
        }
        return this.scope;
    }

    public String getScopeName() {
        if (this.scope == null) {
            logger.debug("Scope is null, returning null");
        }
        return this.scope;
    }

    public void setScope(String scope) {
        logger.info("The scope about to set is: " + scope);
        this.lastUsedTime = System.currentTimeMillis();
        String previousScopeName = this.scopeName;
        this.scope = scope;
        this.scopeName = scope;
        ScopeProvider.instance.set(scope);
        if (this.loggedIn) {
            this.initializeAttributes();
            this.loggedIn = false;
            logger.debug("Passing the logging because the variable was set");
            return;
        }
        if (previousScopeName != null && !previousScopeName.equals(this.scopeName) || previousScopeName == null) {
            logger.info("Logging the entrance");
            this.innerSession.clear();
            LoginToVreAccessLogEntry loginEntry = new LoginToVreAccessLogEntry();
            this.accessLogger.logEntry(this.username, scope, (AccessLogEntry)loginEntry);
        } else {
            logger.debug("Passing the logging because the scope was the same");
        }
        this.initializeAttributes();
    }

    public void setSecurityToken(String token) {
        SecurityTokenProvider.instance.set(token);
        this.securityToken = token;
    }

    public void logUserLogin(String scope) {
        this.innerSession.clear();
        this.loggedIn = true;
        LoginToVreAccessLogEntry loginEntry = new LoginToVreAccessLogEntry();
        this.accessLogger.logEntry(this.username, scope, (AccessLogEntry)loginEntry);
    }

    public void waitNotification(String notification) throws InterruptedException {
        Notifier notifier = this.notifiers.get(notification);
        if (notifier == null) {
            notifier = new Notifier();
            this.notifiers.put(notification, notifier);
        }
        this.lastUsedTime = System.currentTimeMillis();
        notifier.waitNotification();
    }

    public void notifyAllWaiting(String notification) throws InterruptedException {
        Notifier notifier = this.notifiers.get(notification);
        if (notifier == null) {
            notifier = new Notifier();
            this.notifiers.put(notification, notifier);
        }
        this.lastUsedTime = System.currentTimeMillis();
        notifier.notifyAllWaiting();
    }

    public void setGroupModelInfos(String groupName, long groupId) {
        this.groupModel.setGroupName(groupName);
        this.groupModel.setGroupId(groupId);
    }

    public long getGroupId() {
        return this.groupModel.getGroupId();
    }

    public String getGroupName() {
        return this.groupModel.getGroupName();
    }

    public void setUserEmailAddress(String email) {
        this.userEmailAddress = email;
    }

    public String getUserEmailAddress() {
        return this.userEmailAddress;
    }

    public void setUserFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getUserFullName() {
        return this.fullName;
    }

    public void setUserAvatarId(String avatarId) {
        this.avatarId = avatarId;
    }

    public String getUserAvatarId() {
        return this.avatarId;
    }

    public void setUserGender(GenderType gender) {
        this.gender = gender;
    }

    public GenderType getUserGender() {
        return this.gender;
    }

    public String getSecurityToken() {
        logger.info("getting security token: " + this.securityToken + " in thread " + Thread.currentThread().getId());
        return this.securityToken;
    }
}

