/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.math;

import com.jhlabs.image.ImageMath;
import com.jhlabs.image.PixelUtils;
import com.jhlabs.math.Function2D;
import java.awt.Image;
import java.awt.image.PixelGrabber;

public class ImageFunction2D
implements Function2D {
    public static final int ZERO = 0;
    public static final int CLAMP = 1;
    public static final int WRAP = 2;
    protected int[] pixels;
    protected int width;
    protected int height;
    protected int edgeAction = 0;

    public ImageFunction2D(Image image) {
        this(image, 0);
    }

    public ImageFunction2D(Image image, int n) {
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, -1, -1, null, 0, -1);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("interrupted waiting for pixels!");
        }
        if ((pixelGrabber.status() & 0x80) != 0) {
            throw new RuntimeException("image fetch aborted");
        }
        this.init((int[])pixelGrabber.getPixels(), pixelGrabber.getWidth(), pixelGrabber.getHeight(), n);
    }

    public ImageFunction2D(int[] nArray, int n, int n2, int n3) {
        this.init(nArray, n, n2, n3);
    }

    public void init(int[] nArray, int n, int n2, int n3) {
        this.pixels = nArray;
        this.width = n;
        this.height = n2;
        this.edgeAction = n3;
    }

    public double evaluate(double d, double d2) {
        int n = (int)d;
        int n2 = (int)d2;
        if (this.edgeAction == 2) {
            n = ImageMath.mod(n, this.width);
            n2 = ImageMath.mod(n2, this.height);
        } else if (n < 0 || n2 < 0 || n >= this.width || n2 >= this.height) {
            if (this.edgeAction == 0) {
                return 0.0;
            }
            if (n < 0) {
                n = 0;
            } else if (n >= this.width) {
                n = this.width - 1;
            }
            if (n2 < 0) {
                n2 = 0;
            } else if (n2 >= this.height) {
                n2 = this.height - 1;
            }
        }
        return (double)PixelUtils.brightness(this.pixels[n2 * this.width + n]) / 255.0;
    }

    public void setEdgeAction(int n) {
        this.edgeAction = n;
    }

    public int getEdgeAction() {
        return this.edgeAction;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

