/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.TransformFilter;

public class SphereFilter
extends TransformFilter {
    static final long serialVersionUID = -8148404526162968279L;
    private double a = 0.0;
    private double b = 0.0;
    private double a2 = 0.0;
    private double b2 = 0.0;
    private double refractionIndex = 1.5;

    public void setRefractionIndex(double d) {
        this.refractionIndex = d;
    }

    public double getRefractionIndex() {
        return this.refractionIndex;
    }

    public void setDimensions(int n, int n2) {
        super.setDimensions(n, n2);
        this.a = n / 2;
        this.b = n2 / 2;
        this.a2 = this.a * this.a;
        this.b2 = this.b * this.b;
    }

    protected void transformInverse(int n, int n2, double[] dArray) {
        double d = (double)n2 - this.b;
        double d2 = d * d;
        double d3 = (double)n - this.a;
        double d4 = d3 * d3;
        if (d2 >= this.b2 - this.b2 * d4 / this.a2) {
            dArray[0] = n;
            dArray[1] = n2;
        } else {
            double d5 = 1.0 / this.refractionIndex;
            double d6 = Math.sqrt((1.0 - d4 / this.a2 - d2 / this.b2) * (this.a * this.b));
            double d7 = d6 * d6;
            double d8 = Math.acos(d3 / Math.sqrt(d4 + d7));
            double d9 = 1.5707963267948966 - d8;
            double d10 = Math.asin(Math.sin(d9) * d5);
            d10 = 1.5707963267948966 - d8 - d10;
            dArray[0] = (double)n - Math.tan(d10) * d6;
            double d11 = Math.acos(d / Math.sqrt(d2 + d7));
            d9 = 1.5707963267948966 - d11;
            d10 = Math.asin(Math.sin(d9) * d5);
            d10 = 1.5707963267948966 - d11 - d10;
            dArray[1] = (double)n2 - Math.tan(d10) * d6;
        }
    }

    public String toString() {
        return "Distort/Sphere...";
    }
}

