/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSFloat;
import org.pdfbox.cos.COSInteger;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSNull;
import org.pdfbox.cos.COSNumber;
import org.pdfbox.cos.COSString;
import org.pdfbox.pdmodel.common.COSObjectable;
import org.pdfbox.pdmodel.common.DualCOSObjectable;

public class COSArrayList
implements List {
    private COSArray array;
    private List actual;
    private COSDictionary parentDict;
    private String dictKey;

    public COSArrayList(List actualList, COSArray cosArray) {
        this.actual = actualList;
        this.array = cosArray;
    }

    public COSArrayList(Object actualObject, COSBase item, COSDictionary dictionary, String dictionaryKey) {
        this.array = new COSArray();
        this.array.add(item);
        this.actual = new ArrayList();
        this.actual.add(actualObject);
        this.parentDict = dictionary;
        this.dictKey = dictionaryKey;
    }

    public int size() {
        return this.actual.size();
    }

    public boolean isEmpty() {
        return this.actual.isEmpty();
    }

    public boolean contains(Object o) {
        return this.actual.contains(o);
    }

    public Iterator iterator() {
        return this.actual.iterator();
    }

    public Object[] toArray() {
        return this.actual.toArray();
    }

    public Object[] toArray(Object[] a) {
        return this.actual.toArray(a);
    }

    public boolean add(Object o) {
        if (this.parentDict != null) {
            this.parentDict.setItem(this.dictKey, (COSBase)this.array);
            this.parentDict = null;
        }
        if (o instanceof String) {
            this.array.add(new COSString((String)o));
        } else if (o instanceof DualCOSObjectable) {
            DualCOSObjectable dual = (DualCOSObjectable)o;
            this.array.add(dual.getFirstCOSObject());
            this.array.add(dual.getSecondCOSObject());
        } else {
            this.array.add(((COSObjectable)o).getCOSObject());
        }
        return this.actual.add(o);
    }

    public boolean remove(Object o) {
        if (o instanceof String) {
            this.array.remove(new COSString((String)o));
        } else if (o instanceof DualCOSObjectable) {
            DualCOSObjectable dual = (DualCOSObjectable)o;
            this.array.remove(dual.getFirstCOSObject());
            this.array.remove(dual.getSecondCOSObject());
        } else {
            this.array.remove(((COSObjectable)o).getCOSObject());
        }
        return this.actual.remove(o);
    }

    public boolean containsAll(Collection c) {
        return this.actual.containsAll(c);
    }

    public boolean addAll(Collection c) {
        if (this.parentDict != null && c.size() > 0) {
            this.parentDict.setItem(this.dictKey, (COSBase)this.array);
            this.parentDict = null;
        }
        this.array.addAll(this.toCOSObjectList(c));
        return this.actual.addAll(c);
    }

    public boolean addAll(int index, Collection c) {
        if (this.parentDict != null && c.size() > 0) {
            this.parentDict.setItem(this.dictKey, (COSBase)this.array);
            this.parentDict = null;
        }
        if (c.size() > 0 && c.toArray()[0] instanceof DualCOSObjectable) {
            this.array.addAll(index * 2, this.toCOSObjectList(c));
        } else {
            this.array.addAll(index, this.toCOSObjectList(c));
        }
        return this.actual.addAll(index, c);
    }

    public static List convertIntegerCOSArrayToList(COSArray intArray) {
        ArrayList<Integer> numbers = new ArrayList<Integer>();
        for (int i = 0; i < intArray.size(); ++i) {
            numbers.add(new Integer(((COSNumber)intArray.get(i)).intValue()));
        }
        return new COSArrayList(numbers, intArray);
    }

    public static List convertFloatCOSArrayToList(COSArray floatArray) {
        COSArrayList retval = null;
        if (floatArray != null) {
            ArrayList<Float> numbers = new ArrayList<Float>();
            for (int i = 0; i < floatArray.size(); ++i) {
                numbers.add(new Float(((COSNumber)floatArray.get(i)).floatValue()));
            }
            retval = new COSArrayList(numbers, floatArray);
        }
        return retval;
    }

    public static List convertCOSNameCOSArrayToList(COSArray nameArray) {
        COSArrayList retval = null;
        if (nameArray != null) {
            ArrayList<String> names = new ArrayList<String>();
            for (int i = 0; i < nameArray.size(); ++i) {
                names.add(((COSName)nameArray.getObject(i)).getName());
            }
            retval = new COSArrayList(names, nameArray);
        }
        return retval;
    }

    public static List convertCOSStringCOSArrayToList(COSArray stringArray) {
        COSArrayList retval = null;
        if (stringArray != null) {
            ArrayList<String> string = new ArrayList<String>();
            for (int i = 0; i < stringArray.size(); ++i) {
                string.add(((COSString)stringArray.getObject(i)).getString());
            }
            retval = new COSArrayList(string, stringArray);
        }
        return retval;
    }

    public static COSArray convertStringListToCOSNameCOSArray(List strings) {
        COSArray retval = new COSArray();
        for (int i = 0; i < strings.size(); ++i) {
            Object next = strings.get(i);
            if (next instanceof COSName) {
                retval.add((COSName)next);
                continue;
            }
            retval.add(COSName.getPDFName((String)next));
        }
        return retval;
    }

    public static COSArray convertStringListToCOSStringCOSArray(List strings) {
        COSArray retval = new COSArray();
        for (int i = 0; i < strings.size(); ++i) {
            retval.add(new COSString((String)strings.get(i)));
        }
        return retval;
    }

    public static COSArray converterToCOSArray(List cosObjectableList) {
        COSArray array = null;
        if (cosObjectableList != null) {
            array = new COSArray();
            Iterator iter = cosObjectableList.iterator();
            while (iter.hasNext()) {
                Object object;
                Object next = iter.next();
                if (next instanceof String) {
                    array.add(new COSString((String)next));
                    continue;
                }
                if (next instanceof Integer || next instanceof Long) {
                    array.add(new COSInteger(((Number)next).longValue()));
                    continue;
                }
                if (next instanceof Float || next instanceof Double) {
                    array.add(new COSFloat(((Number)next).floatValue()));
                    continue;
                }
                if (next instanceof COSObjectable) {
                    object = (COSObjectable)next;
                    array.add(object.getCOSObject());
                    continue;
                }
                if (next instanceof DualCOSObjectable) {
                    object = (DualCOSObjectable)next;
                    array.add(object.getFirstCOSObject());
                    array.add(object.getSecondCOSObject());
                    continue;
                }
                if (next == null) {
                    array.add(COSNull.NULL);
                    continue;
                }
                throw new RuntimeException("Error: Don't know how to convert type to COSBase '" + next.getClass().getName() + "'");
            }
        }
        return array;
    }

    private List toCOSObjectList(Collection list) {
        ArrayList<COSBase> cosObjects = new ArrayList<COSBase>();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object next = iter.next();
            if (next instanceof String) {
                cosObjects.add(new COSString((String)next));
                continue;
            }
            if (next instanceof DualCOSObjectable) {
                DualCOSObjectable object = (DualCOSObjectable)next;
                this.array.add(object.getFirstCOSObject());
                this.array.add(object.getSecondCOSObject());
                continue;
            }
            COSObjectable cos = (COSObjectable)next;
            cosObjects.add(cos.getCOSObject());
        }
        return cosObjects;
    }

    public boolean removeAll(Collection c) {
        this.array.removeAll(this.toCOSObjectList(c));
        return this.actual.removeAll(c);
    }

    public boolean retainAll(Collection c) {
        this.array.retainAll(this.toCOSObjectList(c));
        return this.actual.retainAll(c);
    }

    public void clear() {
        if (this.parentDict != null) {
            this.parentDict.setItem(this.dictKey, (COSBase)null);
        }
        this.actual.clear();
        this.array.clear();
    }

    public boolean equals(Object o) {
        return ((Object)this.actual).equals(o);
    }

    public int hashCode() {
        return ((Object)this.actual).hashCode();
    }

    public Object get(int index) {
        return this.actual.get(index);
    }

    public Object set(int index, Object element) {
        if (element instanceof String) {
            COSString item = new COSString((String)element);
            if (this.parentDict != null && index == 0) {
                this.parentDict.setItem(this.dictKey, (COSBase)item);
            }
            this.array.set(index, item);
        } else if (element instanceof DualCOSObjectable) {
            DualCOSObjectable dual = (DualCOSObjectable)element;
            this.array.set(index * 2, dual.getFirstCOSObject());
            this.array.set(index * 2 + 1, dual.getSecondCOSObject());
        } else {
            if (this.parentDict != null && index == 0) {
                this.parentDict.setItem(this.dictKey, ((COSObjectable)element).getCOSObject());
            }
            this.array.set(index, ((COSObjectable)element).getCOSObject());
        }
        return this.actual.set(index, element);
    }

    public void add(int index, Object element) {
        if (this.parentDict != null) {
            this.parentDict.setItem(this.dictKey, (COSBase)this.array);
            this.parentDict = null;
        }
        this.actual.add(index, element);
        if (element instanceof String) {
            this.array.add(index, new COSString((String)element));
        } else if (element instanceof DualCOSObjectable) {
            DualCOSObjectable dual = (DualCOSObjectable)element;
            this.array.add(index * 2, dual.getFirstCOSObject());
            this.array.add(index * 2 + 1, dual.getSecondCOSObject());
        } else {
            this.array.add(index, ((COSObjectable)element).getCOSObject());
        }
    }

    public Object remove(int index) {
        if (this.array.size() > index && this.array.get(index) instanceof DualCOSObjectable) {
            this.array.remove(index);
            this.array.remove(index);
        } else {
            this.array.remove(index);
        }
        return this.actual.remove(index);
    }

    public int indexOf(Object o) {
        return this.actual.indexOf(o);
    }

    public int lastIndexOf(Object o) {
        return this.actual.indexOf(o);
    }

    public ListIterator listIterator() {
        return this.actual.listIterator();
    }

    public ListIterator listIterator(int index) {
        return this.actual.listIterator(index);
    }

    public List subList(int fromIndex, int toIndex) {
        return this.actual.subList(fromIndex, toIndex);
    }
}

