/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class LocaleUtil {
    private static Log _log = LogFactoryUtil.getLog(LocaleUtil.class);
    private static LocaleUtil _instance = new LocaleUtil();
    private String[] _isoCountries;
    private String[] _isoLanguages;
    private Locale _locale;
    private Map<String, Locale> _locales = new HashMap<String, Locale>();

    public static Locale fromLanguageId(String languageId) {
        return _instance._fromLanguageId(languageId);
    }

    public static Locale[] fromLanguageIds(String[] languageIds) {
        return _instance._fromLanguageIds(languageIds);
    }

    public static Locale getDefault() {
        return _instance._getDefault();
    }

    public static LocaleUtil getInstance() {
        return _instance;
    }

    public static void setDefault(String userLanguage, String userCountry, String userVariant) {
        _instance._setDefault(userLanguage, userCountry, userVariant);
    }

    public static String toLanguageId(Locale locale) {
        return _instance._toLanguageId(locale);
    }

    public static String[] toLanguageIds(Locale[] locales) {
        return _instance._toLanguageIds(locales);
    }

    public static String toW3cLanguageId(Locale locale) {
        return _instance._toW3cLanguageId(locale);
    }

    public static String toW3cLanguageId(String languageId) {
        return _instance._toW3cLanguageId(languageId);
    }

    public static String[] toW3cLanguageIds(Locale[] locales) {
        return _instance._toW3cLanguageIds(locales);
    }

    public static String[] toW3cLanguageIds(String[] languageIds) {
        return _instance._toW3cLanguageIds(languageIds);
    }

    private LocaleUtil() {
        this._locale = new Locale("en", "US");
        this._isoCountries = (String[])Locale.getISOCountries().clone();
        int i = 0;
        while (i < this._isoCountries.length) {
            this._isoCountries[i] = this._isoCountries[i].toUpperCase();
            ++i;
        }
        Arrays.sort(this._isoCountries);
        this._isoLanguages = (String[])Locale.getISOLanguages().clone();
        i = 0;
        while (i < this._isoLanguages.length) {
            this._isoLanguages[i] = this._isoLanguages[i].toLowerCase();
            ++i;
        }
        Arrays.sort(this._isoLanguages);
    }

    private Locale _fromLanguageId(String languageId) {
        Locale locale;
        block9: {
            if (languageId == null) {
                return this._locale;
            }
            locale = null;
            try {
                locale = this._locales.get(languageId);
                if (locale == null) {
                    int pos = languageId.indexOf("_");
                    if (pos == -1) {
                        if (Arrays.binarySearch(this._isoLanguages, languageId) < 0) {
                            return this._getDefault();
                        }
                        locale = new Locale(languageId);
                    } else {
                        String languageCode = languageId.substring(0, pos);
                        String countryCode = languageId.substring(pos + 1, languageId.length());
                        if (Arrays.binarySearch(this._isoLanguages, languageCode) < 0 || Arrays.binarySearch(this._isoCountries, countryCode) < 0) {
                            return this._getDefault();
                        }
                        locale = new Locale(languageCode, countryCode);
                    }
                    this._locales.put(languageId, locale);
                }
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block9;
                _log.warn(String.valueOf(languageId) + " is not a valid language id");
            }
        }
        if (locale == null) {
            locale = this._locale;
        }
        return locale;
    }

    private Locale[] _fromLanguageIds(String[] languageIds) {
        Locale[] locales = new Locale[languageIds.length];
        int i = 0;
        while (i < languageIds.length) {
            locales[i] = this._fromLanguageId(languageIds[i]);
            ++i;
        }
        return locales;
    }

    private Locale _getDefault() {
        Locale locale = LocaleThreadLocal.getLocale();
        if (locale != null) {
            return locale;
        }
        return this._locale;
    }

    public void _setDefault(String userLanguage, String userCountry, String userVariant) {
        if (Validator.isNotNull(userLanguage) && Validator.isNull(userCountry) && Validator.isNull(userVariant)) {
            this._locale = new Locale(userLanguage);
        } else if (Validator.isNotNull(userLanguage) && Validator.isNotNull(userCountry) && Validator.isNull(userVariant)) {
            this._locale = new Locale(userLanguage, userCountry);
        } else if (Validator.isNotNull(userLanguage) && Validator.isNotNull(userCountry) && Validator.isNotNull(userVariant)) {
            this._locale = new Locale(userLanguage, userCountry, userVariant);
        }
    }

    private String _toLanguageId(Locale locale) {
        if (locale == null) {
            locale = this._locale;
        }
        String languageId = locale.getLanguage();
        if (Validator.isNotNull(locale.getCountry())) {
            languageId = languageId.concat("_");
            languageId = languageId.concat(locale.getCountry());
        }
        return languageId;
    }

    private String[] _toLanguageIds(Locale[] locales) {
        String[] languageIds = new String[locales.length];
        int i = 0;
        while (i < locales.length) {
            languageIds[i] = this._toLanguageId(locales[i]);
            ++i;
        }
        return languageIds;
    }

    private String _toW3cLanguageId(Locale locale) {
        return this._toW3cLanguageId(this._toLanguageId(locale));
    }

    private String _toW3cLanguageId(String languageId) {
        return StringUtil.replace(languageId, "_", "-");
    }

    private String[] _toW3cLanguageIds(Locale[] locales) {
        return this._toW3cLanguageIds(this._toLanguageIds(locales));
    }

    private String[] _toW3cLanguageIds(String[] languageIds) {
        String[] w3cLanguageIds = new String[languageIds.length];
        int i = 0;
        while (i < languageIds.length) {
            w3cLanguageIds[i] = this._toW3cLanguageId(languageIds[i]);
            ++i;
        }
        return w3cLanguageIds;
    }
}

