/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitialThreadLocal<T>
extends ThreadLocal<T> {
    private static final String _METHOD_CLONE = "clone";
    private static Log _log = LogFactoryUtil.getLog(InitialThreadLocal.class);
    private Method _cloneMethod;
    private T _initialValue;
    private String _name;

    public InitialThreadLocal(String name, T initialValue) {
        this._name = name;
        this._initialValue = initialValue;
        if (this._initialValue instanceof Cloneable) {
            try {
                this._cloneMethod = this._initialValue.getClass().getMethod(_METHOD_CLONE, new Class[0]);
            }
            catch (Exception e) {
                _log.error(e, e);
            }
        }
    }

    public String toString() {
        if (this._name != null) {
            return this._name;
        }
        return super.toString();
    }

    @Override
    protected T initialValue() {
        if (this._cloneMethod != null) {
            try {
                return (T)this._cloneMethod.invoke(this._initialValue, new Object[0]);
            }
            catch (Exception e) {
                _log.error(e, e);
            }
        }
        return this._initialValue;
    }
}

