/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.increment;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.increment.Increment;
import com.liferay.portal.kernel.increment.NumberIncrement;
import com.liferay.portal.kernel.increment.SocialEquityIncrement;
import com.liferay.portlet.social.model.SocialEquityValue;
import java.lang.reflect.Constructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncrementFactory {
    public static Increment createIncrement(Class<? extends Increment<?>> counterClass, Object value) throws SystemException {
        if (counterClass == NumberIncrement.class && value instanceof Number) {
            return new NumberIncrement((Number)value);
        }
        if (counterClass == SocialEquityIncrement.class && value instanceof SocialEquityValue) {
            return new SocialEquityIncrement((SocialEquityValue)value);
        }
        try {
            Constructor<Increment<?>> constructor = counterClass.getConstructor(value.getClass());
            return constructor.newInstance(value);
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
    }
}

