/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io.swing.tree;

import de.schlichtherle.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class FileTreeModel
implements TreeModel {
    private static final Collator collator;
    public static final Comparator FILE_NAME_COMPARATOR;
    private final Map cache = new HashMap();
    private final java.io.File root;
    private final FileFilter filter;
    private final Comparator comparator;
    private final EventListenerList listeners = new EventListenerList();
    static final /* synthetic */ boolean $assertionsDisabled;

    public FileTreeModel() {
        this(null, null, FILE_NAME_COMPARATOR);
    }

    public FileTreeModel(java.io.File root) {
        this(root, null, FILE_NAME_COMPARATOR);
    }

    public FileTreeModel(java.io.File root, FileFilter filter) {
        this(root, filter, FILE_NAME_COMPARATOR);
    }

    public FileTreeModel(java.io.File root, FileFilter filter, Comparator comparator) {
        if (comparator == null) {
            throw new NullPointerException();
        }
        if (root != null && comparator.compare(root, root) != 0) {
            throw new IllegalArgumentException();
        }
        this.root = root;
        this.filter = filter;
        this.comparator = comparator;
    }

    public Object getRoot() {
        return this.root;
    }

    public Object getChild(Object parent, int index) {
        java.io.File[] children = this.getChildren((java.io.File)parent);
        return children != null ? children[index] : null;
    }

    public int getChildCount(Object parent) {
        java.io.File[] children = this.getChildren((java.io.File)parent);
        return children != null ? children.length : 0;
    }

    public boolean isLeaf(Object node) {
        return !((java.io.File)node).isDirectory();
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    public int getIndexOfChild(Object parent, Object child) {
        if (parent == null || child == null) {
            return -1;
        }
        java.io.File[] children = this.getChildren((java.io.File)parent);
        if (children == null) {
            return -1;
        }
        int l = children.length;
        for (int i = 0; i < l; ++i) {
            if (!children[i].equals(child)) continue;
            return i;
        }
        return -1;
    }

    private java.io.File[] getChildren(java.io.File parent) {
        if (!$assertionsDisabled && parent == null) {
            throw new AssertionError();
        }
        java.io.File[] children = (java.io.File[])this.cache.get(parent);
        if (children == null) {
            if (this.cache.containsKey(parent)) {
                return null;
            }
            children = parent.listFiles(this.filter);
            this.cache.put(parent, children);
            if (children != null) {
                Arrays.sort(children, FILE_NAME_COMPARATOR);
            }
        }
        return children;
    }

    public TreePath getTreePath(java.io.File node) {
        return this.createTreePath(node);
    }

    public TreePath createTreePath(java.io.File node) {
        Object[] elements = this.createPath(node);
        return elements != null ? new TreePath(elements) : null;
    }

    private java.io.File[] createPath(java.io.File node) {
        if (this.root == null) {
            return null;
        }
        return this.createPath(node, 1);
    }

    private java.io.File[] createPath(java.io.File node, int level) {
        java.io.File[] path;
        if (!$assertionsDisabled && this.root == null) {
            throw new AssertionError();
        }
        if (this.root.equals(node)) {
            path = new java.io.File[level];
            path[0] = this.root;
        } else if (node != null) {
            path = this.createPath(node.getParentFile(), level + 1);
            if (path != null) {
                path[path.length - level] = node;
            }
        } else {
            path = null;
        }
        return path;
    }

    public boolean createNewFile(java.io.File node) throws IOException {
        if (!node.createNewFile()) {
            return false;
        }
        this.nodeInserted(node);
        return true;
    }

    public boolean mkdir(java.io.File node) {
        if (!node.mkdir()) {
            return false;
        }
        this.nodeInserted(node);
        return true;
    }

    public boolean mkdirs(java.io.File node) {
        if (!node.mkdirs()) {
            return false;
        }
        this.nodeInserted(node);
        return true;
    }

    public boolean copyFrom(File node, InputStream in) {
        if (!node.copyFrom(in)) {
            return false;
        }
        this.nodeInsertedOrStructureChanged(node);
        return true;
    }

    public boolean copyTo(File oldNode, java.io.File node) {
        if (!oldNode.copyTo(node)) {
            return false;
        }
        this.nodeInsertedOrStructureChanged(node);
        return true;
    }

    public boolean copyAllTo(File oldNode, java.io.File node) {
        boolean ok = oldNode.copyAllTo(node);
        this.nodeInsertedOrStructureChanged(node);
        return ok;
    }

    public boolean archiveCopyTo(File oldNode, java.io.File node) {
        if (!oldNode.archiveCopyTo(node)) {
            return false;
        }
        this.nodeInsertedOrStructureChanged(node);
        return true;
    }

    public boolean archiveCopyAllTo(File oldNode, java.io.File node) {
        boolean ok = oldNode.archiveCopyAllTo(node);
        this.nodeInsertedOrStructureChanged(node);
        return ok;
    }

    public boolean renameTo(java.io.File oldNode, java.io.File newNode) {
        if (!oldNode.renameTo(newNode)) {
            return false;
        }
        this.nodeRemoved(oldNode);
        this.nodeInserted(newNode);
        return true;
    }

    public boolean delete(java.io.File node) {
        if (!node.delete()) {
            return false;
        }
        this.nodeRemoved(node);
        return true;
    }

    public boolean deleteAll(File node) {
        if (!node.deleteAll()) {
            return false;
        }
        this.nodeRemoved(node);
        return true;
    }

    public void nodeInsertedOrStructureChanged(java.io.File node) {
        if (node == null) {
            throw new NullPointerException();
        }
        if (this.cache.containsKey(node)) {
            this.structureChanged(node);
        } else {
            this.nodeInserted(node);
        }
    }

    public void nodeInserted(java.io.File node) {
        if (this.cache.containsKey(node)) {
            return;
        }
        java.io.File parent = node.getParentFile();
        this.forget(parent, false);
        int index = this.getIndexOfChild(parent, node);
        if (index == -1) {
            return;
        }
        this.fireTreeNodesInserted(new TreeModelEvent((Object)this, this.createTreePath(parent), new int[]{index}, (Object[])new java.io.File[]{node}));
    }

    public void nodeChanged(java.io.File node) {
        java.io.File parent = node.getParentFile();
        int index = this.getIndexOfChild(parent, node);
        if (index == -1) {
            return;
        }
        this.fireTreeNodesChanged(new TreeModelEvent((Object)this, this.createTreePath(parent), new int[]{index}, (Object[])new java.io.File[]{node}));
    }

    public void nodeRemoved(java.io.File node) {
        java.io.File parent = node.getParentFile();
        int index = this.getIndexOfChild(parent, node);
        if (index == -1) {
            return;
        }
        this.forget(node, true);
        this.forget(parent, false);
        this.getChildren(parent);
        this.fireTreeNodesRemoved(new TreeModelEvent((Object)this, this.createTreePath(parent), new int[]{index}, (Object[])new java.io.File[]{node}));
    }

    public void refresh() {
        this.cache.clear();
        if (this.root != null) {
            this.fireTreeStructureChanged(new TreeModelEvent((Object)this, this.createTreePath(this.root), null, null));
        }
    }

    public final void refresh(java.io.File node) {
        this.structureChanged(node);
    }

    public void structureChanged(java.io.File node) {
        if (node == null) {
            throw new NullPointerException();
        }
        this.forget(node);
        this.fireTreeStructureChanged(new TreeModelEvent((Object)this, this.createTreePath(node), null, null));
    }

    public final void forget(java.io.File node) {
        this.forget(node, true);
    }

    private void forget(java.io.File node, boolean childrenToo) {
        java.io.File[] children = (java.io.File[])this.cache.remove(node);
        if (children != null && childrenToo) {
            int l = children.length;
            for (int i = 0; i < l; ++i) {
                this.forget(children[i], childrenToo);
            }
        }
    }

    public void addTreeModelListener(TreeModelListener l) {
        this.listeners.add(TreeModelListener.class, l);
    }

    public void removeTreeModelListener(TreeModelListener l) {
        this.listeners.remove(TreeModelListener.class, l);
    }

    protected void fireTreeNodesChanged(TreeModelEvent evt) {
        EventListener[] l = this.listeners.getListeners(TreeModelListener.class);
        int ll = l.length;
        for (int i = 0; i < ll; ++i) {
            ((TreeModelListener)l[i]).treeNodesChanged(evt);
        }
    }

    protected void fireTreeNodesInserted(TreeModelEvent evt) {
        EventListener[] l = this.listeners.getListeners(TreeModelListener.class);
        int ll = l.length;
        for (int i = 0; i < ll; ++i) {
            ((TreeModelListener)l[i]).treeNodesInserted(evt);
        }
    }

    protected void fireTreeNodesRemoved(TreeModelEvent evt) {
        EventListener[] l = this.listeners.getListeners(TreeModelListener.class);
        int ll = l.length;
        for (int i = 0; i < ll; ++i) {
            ((TreeModelListener)l[i]).treeNodesRemoved(evt);
        }
    }

    protected void fireTreeStructureChanged(TreeModelEvent evt) {
        EventListener[] l = this.listeners.getListeners(TreeModelListener.class);
        int ll = l.length;
        for (int i = 0; i < ll; ++i) {
            ((TreeModelListener)l[i]).treeStructureChanged(evt);
        }
    }

    static {
        $assertionsDisabled = !FileTreeModel.class.desiredAssertionStatus();
        collator = Collator.getInstance();
        collator.setDecomposition(0);
        collator.setStrength(java.io.File.separatorChar == '\\' ? 1 : 2);
        FILE_NAME_COMPARATOR = new Comparator(){

            public final int compare(Object o1, Object o2) {
                return this.compare((java.io.File)o1, (java.io.File)o2);
            }

            public int compare(java.io.File f1, java.io.File f2) {
                if (f1.isDirectory()) {
                    return f2.isDirectory() ? collator.compare(f1.getName(), f2.getName()) : -1;
                }
                return f2.isDirectory() ? 1 : collator.compare(f1.getName(), f2.getName());
            }
        };
    }
}

