/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.crypto.io.raes;

import de.schlichtherle.crypto.io.raes.RaesAuthenticationException;
import de.schlichtherle.crypto.io.raes.RaesException;
import de.schlichtherle.crypto.io.raes.RaesKeyException;
import de.schlichtherle.crypto.io.raes.RaesOutputStream;
import de.schlichtherle.crypto.io.raes.RaesReadOnlyFile;
import de.schlichtherle.crypto.io.raes.Type0RaesParameters;
import de.schlichtherle.crypto.modes.SICSeekableBlockCipher;
import de.schlichtherle.io.rof.ReadOnlyFile;
import de.schlichtherle.util.Arrays;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.engines.AESFastEngine;
import org.bouncycastle.crypto.generators.PKCS12ParametersGenerator;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

class Type0RaesReadOnlyFile
extends RaesReadOnlyFile {
    private static final long MIN_KEY_RETRY_DELAY = 3000L;
    private final int keyStrength;
    private final CipherParameters macParam;
    private final byte[] footer;
    static final /* synthetic */ boolean $assertionsDisabled;

    Type0RaesReadOnlyFile(ReadOnlyFile rof, Type0RaesParameters parameters) throws NullPointerException, FileNotFoundException, RaesException, RaesKeyException, IOException {
        super(rof);
        CipherParameters macParam;
        ParametersWithIV cipherParam;
        if (!$assertionsDisabled && rof == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && parameters == null) {
            throw new AssertionError();
        }
        byte[] header = new byte[8];
        long fileLength = rof.length();
        rof.seek(0L);
        rof.readFully(header);
        this.keyStrength = Type0RaesReadOnlyFile.readUByte(header, 5);
        if (this.keyStrength != 0 && this.keyStrength != 1 && this.keyStrength != 2) {
            throw new RaesException("Unknown index for cipher key strength: " + this.keyStrength + "!");
        }
        int keyLen = 16 + this.keyStrength * 8;
        int keySize = keyLen * 8;
        int iCount = Type0RaesReadOnlyFile.readUShort(header, 6);
        if (iCount < 1024) {
            throw new RaesException("Iteration count must be 1024 or greater, but is " + iCount + "!");
        }
        long start = header.length + keyLen;
        byte[] salt = new byte[keyLen];
        rof.readFully(salt);
        SHA256Digest digest = new SHA256Digest();
        this.footer = new byte[digest.getDigestSize()];
        long end = fileLength - (long)this.footer.length;
        rof.seek(end);
        rof.readFully(this.footer);
        if (this.rof.read() != -1) {
            throw new RaesException("Expected end of file after data envelope trailer!");
        }
        long length = fileLength - (long)this.footer.length - start;
        PKCS12ParametersGenerator paramGen = new PKCS12ParametersGenerator((Digest)digest);
        long lastTry = 0L;
        while (true) {
            char[] passwd;
            if ((passwd = parameters.getOpenPasswd()) == null) {
                throw new RaesKeyException();
            }
            byte[] pass = PBEParametersGenerator.PKCS12PasswordToBytes((char[])passwd);
            int i = passwd.length;
            while (--i >= 0) {
                passwd[i] = '\u0000';
            }
            paramGen.init(pass, salt, iCount);
            cipherParam = (ParametersWithIV)paramGen.generateDerivedParameters(keySize, 128);
            macParam = paramGen.generateDerivedMacParameters(keySize);
            i = pass.length;
            while (--i >= 0) {
                pass[i] = 0;
            }
            HMac klac = new HMac((Digest)digest);
            klac.init(macParam);
            byte[] cipherKey = ((KeyParameter)cipherParam.getParameters()).getKey();
            klac.update(cipherKey, 0, cipherKey.length);
            byte[] buf = new byte[klac.getMacSize()];
            RaesOutputStream.klac((Mac)klac, length, buf);
            digest.reset();
            lastTry = Type0RaesReadOnlyFile.enforceSuspensionPenalty(lastTry);
            if (Arrays.equals(this.footer, 0, buf, 0, buf.length / 2)) break;
            parameters.invalidOpenPasswd();
        }
        parameters.setKeyStrength(this.keyStrength);
        this.macParam = macParam;
        SICSeekableBlockCipher cipher = new SICSeekableBlockCipher((BlockCipher)new AESFastEngine());
        cipher.init(false, (CipherParameters)cipherParam);
        this.init(cipher, start, length);
    }

    private static long enforceSuspensionPenalty(long last) {
        long delay;
        InterruptedException interrupted = null;
        while ((delay = System.currentTimeMillis() - last) < 3000L) {
            try {
                Thread.sleep(3000L - delay);
            }
            catch (InterruptedException ex) {
                interrupted = ex;
            }
        }
        if (interrupted != null) {
            Thread.currentThread().interrupt();
        }
        return last + delay;
    }

    public int getKeySizeBits() {
        return 128 + this.keyStrength * 64;
    }

    public void authenticate() throws RaesAuthenticationException, IOException {
        HMac mac = new HMac((Digest)new SHA256Digest());
        mac.init(this.macParam);
        byte[] buf = this.computeMac((Mac)mac);
        if (!Arrays.equals(this.footer, this.footer.length / 2, buf, 0, buf.length / 2)) {
            throw new RaesAuthenticationException();
        }
    }

    static {
        $assertionsDisabled = !Type0RaesReadOnlyFile.class.desiredAssertionStatus();
    }
}

