/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.journal;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.jackrabbit.core.journal.DatabaseJournal;
import org.apache.jackrabbit.util.Text;

public class OracleDatabaseJournal
extends DatabaseJournal {
    public static final String TABLE_SPACE_VARIABLE = "${tableSpace}";
    protected String tableSpace;

    public String getTableSpace() {
        return this.tableSpace;
    }

    public void setTableSpace(String tableSpace) {
        this.tableSpace = tableSpace != null ? tableSpace.trim() : null;
    }

    protected String createSchemaSQL(String sql) {
        sql = super.createSchemaSQL(sql);
        String tspace = this.tableSpace == null || "".equals(this.tableSpace) ? "" : "tablespace " + this.tableSpace;
        return Text.replace((String)sql, (String)TABLE_SPACE_VARIABLE, (String)tspace).trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean tableExists(DatabaseMetaData metaData, String tableName) throws SQLException {
        if (metaData.storesLowerCaseIdentifiers()) {
            tableName = tableName.toLowerCase();
        } else if (metaData.storesUpperCaseIdentifiers()) {
            tableName = tableName.toUpperCase();
        }
        String userName = metaData.getUserName();
        ResultSet rs = metaData.getTables(null, userName, tableName, null);
        try {
            boolean bl = rs.next();
            return bl;
        }
        finally {
            rs.close();
        }
    }
}

