/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.generic;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

public class ValueParser {
    private Map source = null;
    private String delimiter = ",";

    public ValueParser() {
    }

    public ValueParser(Map source) {
        this.setSource(source);
    }

    protected void setSource(Map source) {
        this.source = source;
    }

    protected Map getSource() {
        if (this.source == null) {
            throw new NullPointerException("You must set a Map source for values to be parsed.");
        }
        return this.source;
    }

    protected final void setStringsDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    protected final String getStringsDelimiter() {
        return this.delimiter;
    }

    public boolean exists(String key) {
        return this.getString(key) != null;
    }

    public Object get(String key) {
        return this.getString(key);
    }

    public String getString(String key) {
        Object value = this.getSource().get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Collection) {
            Collection values = (Collection)value;
            if (!values.isEmpty()) {
                value = values.iterator().next();
            }
        } else if (value.getClass().isArray() && Array.getLength(value) > 0) {
            value = Array.get(value, 0);
        }
        return String.valueOf(value);
    }

    public String getString(String key, String alternate) {
        String s = this.getString(key);
        return s != null ? s : alternate;
    }

    public Boolean getBoolean(String key) {
        String s = this.getString(key);
        return s != null ? this.parseBoolean(s) : null;
    }

    public boolean getBoolean(String key, boolean alternate) {
        Boolean bool = this.getBoolean(key);
        return bool != null ? bool : alternate;
    }

    public Boolean getBoolean(String key, Boolean alternate) {
        Boolean bool = this.getBoolean(key);
        return bool != null ? bool : alternate;
    }

    public Integer getInteger(String key) {
        Number num = this.getNumber(key);
        if (num == null || num instanceof Integer) {
            return (Integer)num;
        }
        return new Integer(num.intValue());
    }

    public Integer getInteger(String key, Integer alternate) {
        Integer num = this.getInteger(key);
        if (num == null) {
            return alternate;
        }
        return num;
    }

    public Double getDouble(String key) {
        Number num = this.getNumber(key);
        if (num == null || num instanceof Double) {
            return (Double)num;
        }
        return new Double(num.intValue());
    }

    public Double getDouble(String key, Double alternate) {
        Double num = this.getDouble(key);
        if (num == null) {
            return alternate;
        }
        return num;
    }

    public Number getNumber(String key) {
        String s = this.getString(key);
        if (s == null || s.length() == 0) {
            return null;
        }
        try {
            return this.parseNumber(s);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Locale getLocale(String key) {
        String s = this.getString(key);
        if (s == null || s.length() == 0) {
            return null;
        }
        return this.parseLocale(s);
    }

    public Number getNumber(String key, Number alternate) {
        Number n = this.getNumber(key);
        return n != null ? (Number)n : (Number)alternate;
    }

    public int getInt(String key, int alternate) {
        Number n = this.getNumber(key);
        return n != null ? n.intValue() : alternate;
    }

    public double getDouble(String key, double alternate) {
        Number n = this.getNumber(key);
        return n != null ? n.doubleValue() : alternate;
    }

    public Locale getLocale(String key, Locale alternate) {
        Locale l = this.getLocale(key);
        return l != null ? l : alternate;
    }

    public String[] getStrings(String key) {
        Object value = this.getSource().get(key);
        if (value == null) {
            return null;
        }
        String[] strings = null;
        if (value instanceof Collection) {
            Collection values = (Collection)value;
            if (!values.isEmpty()) {
                strings = new String[values.size()];
                int index = 0;
                Iterator i = values.iterator();
                while (i.hasNext()) {
                    strings[index++] = String.valueOf(i.next());
                }
            }
        } else if (value.getClass().isArray()) {
            strings = new String[Array.getLength(value)];
            for (int i = 0; i < strings.length; ++i) {
                strings[i] = String.valueOf(Array.get(value, i));
            }
        } else {
            strings = this.parseStringList(String.valueOf(value));
        }
        return strings;
    }

    public Boolean[] getBooleans(String key) {
        String[] strings = this.getStrings(key);
        if (strings == null) {
            return null;
        }
        Boolean[] bools = new Boolean[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            if (strings[i] == null || strings[i].length() <= 0) continue;
            bools[i] = this.parseBoolean(strings[i]);
        }
        return bools;
    }

    public Number[] getNumbers(String key) {
        String[] strings = this.getStrings(key);
        if (strings == null) {
            return null;
        }
        Number[] nums = new Number[strings.length];
        try {
            for (int i = 0; i < nums.length; ++i) {
                if (strings[i] == null || strings[i].length() <= 0) continue;
                nums[i] = this.parseNumber(strings[i]);
            }
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        return nums;
    }

    public int[] getInts(String key) {
        String[] strings = this.getStrings(key);
        if (strings == null) {
            return null;
        }
        int[] ints = new int[strings.length];
        try {
            for (int i = 0; i < ints.length; ++i) {
                if (strings[i] == null || strings[i].length() <= 0) continue;
                ints[i] = this.parseNumber(strings[i]).intValue();
            }
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        return ints;
    }

    public double[] getDoubles(String key) {
        String[] strings = this.getStrings(key);
        if (strings == null) {
            return null;
        }
        double[] doubles = new double[strings.length];
        try {
            for (int i = 0; i < doubles.length; ++i) {
                if (strings[i] == null || strings[i].length() <= 0) continue;
                doubles[i] = this.parseNumber(strings[i]).doubleValue();
            }
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        return doubles;
    }

    public Locale[] getLocales(String key) {
        String[] strings = this.getStrings(key);
        if (strings == null) {
            return null;
        }
        Locale[] locs = new Locale[strings.length];
        for (int i = 0; i < locs.length; ++i) {
            if (strings[i] == null || strings[i].length() <= 0) continue;
            locs[i] = this.parseLocale(strings[i]);
        }
        return locs;
    }

    protected Number parseNumber(String value) throws NumberFormatException {
        if (value.indexOf(46) >= 0) {
            return new Double(value);
        }
        return new Long(value);
    }

    protected Boolean parseBoolean(String value) {
        return Boolean.valueOf(value);
    }

    protected String[] parseStringList(String value) {
        if (value.indexOf(this.delimiter) < 0) {
            return new String[]{value};
        }
        return value.split(this.delimiter);
    }

    protected Locale parseLocale(String value) {
        if (value.indexOf("_") < 0) {
            return new Locale(value);
        }
        String[] params = value.split("_");
        if (params.length == 2) {
            return new Locale(params[0], params[1]);
        }
        if (params.length == 3) {
            return new Locale(params[0], params[1], params[2]);
        }
        return null;
    }
}

