/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;

public class MappedPropertyDescriptor
extends PropertyDescriptor {
    private Class mappedPropertyType;
    private Method mappedReadMethod;
    private Method mappedWriteMethod;
    private static final Class[] stringClassArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = MappedPropertyDescriptor.class$("java.lang.String")) : class$java$lang$String};
    private static Hashtable declaredMethodCache = new Hashtable();
    static /* synthetic */ Class class$java$lang$String;

    public MappedPropertyDescriptor(String propertyName, Class beanClass) throws IntrospectionException {
        super(propertyName, null, null);
        if (propertyName == null || propertyName.length() == 0) {
            throw new IntrospectionException("bad property name: " + propertyName + " on class: " + beanClass.getClass().getName());
        }
        this.setName(propertyName);
        String base = MappedPropertyDescriptor.capitalizePropertyName(propertyName);
        try {
            this.mappedReadMethod = MappedPropertyDescriptor.findMethod(beanClass, "get" + base, 1, stringClassArray);
            Class[] params = new Class[]{class$java$lang$String == null ? (class$java$lang$String = MappedPropertyDescriptor.class$("java.lang.String")) : class$java$lang$String, this.mappedReadMethod.getReturnType()};
            this.mappedWriteMethod = MappedPropertyDescriptor.findMethod(beanClass, "set" + base, 2, params);
        }
        catch (IntrospectionException e) {
            // empty catch block
        }
        if (this.mappedReadMethod == null) {
            this.mappedWriteMethod = MappedPropertyDescriptor.findMethod(beanClass, "set" + base, 2);
        }
        if (this.mappedReadMethod == null && this.mappedWriteMethod == null) {
            throw new IntrospectionException("Property '" + propertyName + "' not found on " + beanClass.getName());
        }
        this.findMappedPropertyType();
    }

    public MappedPropertyDescriptor(String propertyName, Class beanClass, String mappedGetterName, String mappedSetterName) throws IntrospectionException {
        super(propertyName, null, null);
        if (propertyName == null || propertyName.length() == 0) {
            throw new IntrospectionException("bad property name: " + propertyName);
        }
        this.setName(propertyName);
        this.mappedReadMethod = MappedPropertyDescriptor.findMethod(beanClass, mappedGetterName, 1, stringClassArray);
        if (this.mappedReadMethod != null) {
            Class[] params = new Class[]{class$java$lang$String == null ? (class$java$lang$String = MappedPropertyDescriptor.class$("java.lang.String")) : class$java$lang$String, this.mappedReadMethod.getReturnType()};
            this.mappedWriteMethod = MappedPropertyDescriptor.findMethod(beanClass, mappedSetterName, 2, params);
        } else {
            this.mappedWriteMethod = MappedPropertyDescriptor.findMethod(beanClass, mappedSetterName, 2);
        }
        this.findMappedPropertyType();
    }

    public MappedPropertyDescriptor(String propertyName, Method mappedGetter, Method mappedSetter) throws IntrospectionException {
        super(propertyName, mappedGetter, mappedSetter);
        if (propertyName == null || propertyName.length() == 0) {
            throw new IntrospectionException("bad property name: " + propertyName);
        }
        this.setName(propertyName);
        this.mappedReadMethod = mappedGetter;
        this.mappedWriteMethod = mappedSetter;
        this.findMappedPropertyType();
    }

    public Class getMappedPropertyType() {
        return this.mappedPropertyType;
    }

    public Method getMappedReadMethod() {
        return this.mappedReadMethod;
    }

    public void setMappedReadMethod(Method mappedGetter) throws IntrospectionException {
        this.mappedReadMethod = mappedGetter;
        this.findMappedPropertyType();
    }

    public Method getMappedWriteMethod() {
        return this.mappedWriteMethod;
    }

    public void setMappedWriteMethod(Method mappedSetter) throws IntrospectionException {
        this.mappedWriteMethod = mappedSetter;
        this.findMappedPropertyType();
    }

    private void findMappedPropertyType() throws IntrospectionException {
        this.mappedPropertyType = null;
        if (this.mappedReadMethod != null) {
            if (this.mappedReadMethod.getParameterTypes().length != 1) {
                throw new IntrospectionException("bad mapped read method arg count");
            }
            this.mappedPropertyType = this.mappedReadMethod.getReturnType();
            if (this.mappedPropertyType == Void.TYPE) {
                throw new IntrospectionException("mapped read method " + this.mappedReadMethod.getName() + " returns void");
            }
        }
        if (this.mappedWriteMethod != null) {
            Class<?>[] params = this.mappedWriteMethod.getParameterTypes();
            if (params.length != 2) {
                throw new IntrospectionException("bad mapped write method arg count");
            }
            if (this.mappedPropertyType != null && this.mappedPropertyType != params[1]) {
                throw new IntrospectionException("type mismatch between mapped read and write methods");
            }
            this.mappedPropertyType = params[1];
        }
    }

    private static String capitalizePropertyName(String s) {
        if (s.length() == 0) {
            return s;
        }
        char[] chars = s.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    private static synchronized Method[] getPublicDeclaredMethods(Class clz) {
        final Class fclz = clz;
        Method[] result = (Method[])declaredMethodCache.get(fclz);
        if (result != null) {
            return result;
        }
        result = (Method[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return fclz.getDeclaredMethods();
            }
        });
        int i = 0;
        while (i < result.length) {
            Method method = result[i];
            int mods = method.getModifiers();
            if (!Modifier.isPublic(mods)) {
                result[i] = null;
            }
            ++i;
        }
        declaredMethodCache.put(clz, result);
        return result;
    }

    private static Method internalFindMethod(Class start, String methodName, int argCount) {
        int i;
        Class cl = start;
        while (cl != null) {
            Method[] methods = MappedPropertyDescriptor.getPublicDeclaredMethods(cl);
            i = 0;
            while (i < methods.length) {
                int mods;
                Method method = methods[i];
                if (method != null && !Modifier.isStatic(mods = method.getModifiers()) && method.getName().equals(methodName) && method.getParameterTypes().length == argCount) {
                    return method;
                }
                ++i;
            }
            cl = cl.getSuperclass();
        }
        Class<?>[] ifcs = start.getInterfaces();
        i = 0;
        while (i < ifcs.length) {
            Method m = MappedPropertyDescriptor.internalFindMethod(ifcs[i], methodName, argCount);
            if (m != null) {
                return m;
            }
            ++i;
        }
        return null;
    }

    private static Method internalFindMethod(Class start, String methodName, int argCount, Class[] args) {
        int i;
        Class cl = start;
        while (cl != null) {
            Method[] methods = MappedPropertyDescriptor.getPublicDeclaredMethods(cl);
            i = 0;
            while (i < methods.length) {
                block9: {
                    Method method;
                    block10: {
                        int mods;
                        method = methods[i];
                        if (method == null || Modifier.isStatic(mods = method.getModifiers())) break block9;
                        Class<?>[] params = method.getParameterTypes();
                        if (!method.getName().equals(methodName) || params.length != argCount) break block9;
                        boolean different = false;
                        if (argCount <= 0) break block10;
                        int j = 0;
                        while (j < argCount) {
                            if (params[j] != args[j]) {
                                different = true;
                            }
                            ++j;
                        }
                        if (different) break block9;
                    }
                    return method;
                }
                ++i;
            }
            cl = cl.getSuperclass();
        }
        Class<?>[] ifcs = start.getInterfaces();
        i = 0;
        while (i < ifcs.length) {
            Method m = MappedPropertyDescriptor.internalFindMethod(ifcs[i], methodName, argCount);
            if (m != null) {
                return m;
            }
            ++i;
        }
        return null;
    }

    static Method findMethod(Class cls, String methodName, int argCount) throws IntrospectionException {
        if (methodName == null) {
            return null;
        }
        Method m = MappedPropertyDescriptor.internalFindMethod(cls, methodName, argCount);
        if (m != null) {
            return m;
        }
        throw new IntrospectionException("No method \"" + methodName + "\" with " + argCount + " arg(s)");
    }

    static Method findMethod(Class cls, String methodName, int argCount, Class[] args) throws IntrospectionException {
        if (methodName == null) {
            return null;
        }
        Method m = MappedPropertyDescriptor.internalFindMethod(cls, methodName, argCount, args);
        if (m != null) {
            return m;
        }
        throw new IntrospectionException("No method \"" + methodName + "\" with " + argCount + " arg(s) of matching types.");
    }

    static boolean isSubclass(Class a, Class b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        Class x = a;
        while (x != null) {
            if (x == b) {
                return true;
            }
            if (b.isInterface()) {
                Class<?>[] interfaces = x.getInterfaces();
                int i = 0;
                while (i < interfaces.length) {
                    if (MappedPropertyDescriptor.isSubclass(interfaces[i], b)) {
                        return true;
                    }
                    ++i;
                }
            }
            x = x.getSuperclass();
        }
        return false;
    }

    private boolean throwsException(Method method, Class exception) {
        Class<?>[] exs = method.getExceptionTypes();
        int i = 0;
        while (i < exs.length) {
            if (exs[i] == exception) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

